/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import javax.xml.bind.annotation.XmlAttribute;
import toxi.math.MathUtils;
import toxi.util.datatypes.FloatRange;

public class BiasedFloatRange
extends FloatRange {
    @XmlAttribute
    protected float bias = 0.5f;
    @XmlAttribute
    protected float standardDeviation = this.bias * 0.5f;

    public BiasedFloatRange() {
        this(0.0f, 1.0f, 0.5f, 1.0f);
    }

    public BiasedFloatRange(float f, float f2, float f3, float f4) {
        super(f, f2);
        this.setBias(f3);
        this.setStandardDeviation(f4);
    }

    public BiasedFloatRange copy() {
        BiasedFloatRange biasedFloatRange = new BiasedFloatRange(this.min, this.max, this.bias, this.standardDeviation * 2.0f);
        biasedFloatRange.currValue = this.currValue;
        return biasedFloatRange;
    }

    public float getBias() {
        return this.bias;
    }

    public float getStandardDeviation() {
        return this.standardDeviation;
    }

    public float pickRandom() {
        do {
            this.currValue = (float)(this.random.nextGaussian() * (double)this.standardDeviation * (double)(this.max - this.min)) + this.bias;
        } while (this.currValue < this.min || this.currValue >= this.max);
        return this.currValue;
    }

    public void setBias(float f) {
        this.bias = MathUtils.clip(f, this.min, this.max);
    }

    public void setStandardDeviation(float f) {
        this.standardDeviation = MathUtils.clip(f, 0.0f, 1.0f) * 0.5f;
    }

    public String toString() {
        return "BiasedFloatRange: " + this.min + " -> " + this.max + " bias: " + this.bias + " q: " + this.standardDeviation;
    }
}

