/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import toxi.geom.Ellipse;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;
import toxi.math.MathUtils;

public class Circle
extends Ellipse {
    public static Circle from2Points(Vec2D vec2D, Vec2D vec2D2) {
        Vec2D vec2D3 = vec2D.interpolateTo(vec2D2, 0.5f);
        return new Circle((ReadonlyVec2D)vec2D3, vec2D3.distanceTo(vec2D));
    }

    public static Circle from3Points(Vec2D vec2D, Vec2D vec2D2, Vec2D vec2D3) {
        Circle circle = null;
        Vec2D vec2D4 = vec2D2.sub(vec2D);
        Vec2D vec2D5 = vec2D3.sub(vec2D2);
        if (MathUtils.abs(vec2D4.x) <= 1.0E-7f && MathUtils.abs(vec2D5.y) <= 1.0E-7f) {
            Vec2D vec2D6 = new Vec2D(vec2D2.x + vec2D3.x, vec2D.y + vec2D2.y).scaleSelf(0.5f);
            float f = vec2D6.distanceTo(vec2D);
            circle = new Circle((ReadonlyVec2D)vec2D6, f);
        } else {
            float f = vec2D4.y / vec2D4.x;
            float f2 = vec2D5.y / vec2D5.x;
            if (MathUtils.abs(f - f2) > 1.0E-7f) {
                float f3 = (f * f2 * (vec2D.y - vec2D3.y) + f2 * (vec2D.x + vec2D2.x) - f * (vec2D2.x + vec2D3.x)) / (2.0f * (f2 - f));
                float f4 = -(f3 - (vec2D.x + vec2D2.x) / 2.0f) / f + (vec2D.y + vec2D2.y) / 2.0f;
                Vec2D vec2D7 = new Vec2D(f3, f4);
                float f5 = vec2D7.distanceTo(vec2D);
                circle = new Circle((ReadonlyVec2D)vec2D7, f5);
            }
        }
        return circle;
    }

    public Circle() {
        this((ReadonlyVec2D)new Vec2D(), 1.0f);
    }

    public Circle(Circle circle) {
        this((ReadonlyVec2D)circle, circle.radius.x);
    }

    public Circle(float f) {
        this(0.0f, 0.0f, f);
    }

    public Circle(float f, float f2, float f3) {
        super(f, f2, f3, f3);
    }

    public Circle(ReadonlyVec2D readonlyVec2D, float f) {
        super(readonlyVec2D, f);
    }

    public boolean containsPoint(ReadonlyVec2D readonlyVec2D) {
        return this.distanceToSquared(readonlyVec2D) <= this.radius.x * this.radius.x;
    }

    public float getCircumference() {
        return (float)Math.PI * 2 * this.radius.x;
    }

    public float getRadius() {
        return this.radius.x;
    }

    public Vec2D[] getTangentPoints(ReadonlyVec2D readonlyVec2D) {
        Vec2D vec2D = this.interpolateTo(readonlyVec2D, 0.5f);
        return this.intersectsCircle(new Circle((ReadonlyVec2D)vec2D, vec2D.distanceTo(readonlyVec2D)));
    }

    public Vec2D[] intersectsCircle(Circle circle) {
        float f;
        float f2;
        Vec2D[] vec2DArray = null;
        Vec2D vec2D = circle.sub(this);
        float f3 = vec2D.magnitude();
        if (f3 <= (f2 = this.radius.x) + (f = circle.radius.x) && f3 >= Math.abs(f2 - f)) {
            float f4 = (f2 * f2 - f * f + f3 * f3) / (2.0f * f3);
            f3 = 1.0f / f3;
            Vec2D vec2D2 = this.add(vec2D.scale(f4 * f3));
            float f5 = (float)Math.sqrt(f2 * f2 - f4 * f4);
            vec2D.perpendicular().scaleSelf(f5 * f3);
            Vec2D vec2D3 = vec2D2.add(vec2D);
            Vec2D vec2D4 = vec2D2.sub(vec2D);
            vec2DArray = new Vec2D[]{vec2D3, vec2D4};
        }
        return vec2DArray;
    }

    public Circle setRadius(float f) {
        super.setRadii(f, f);
        return this;
    }
}

