/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import toxi.geom.BernsteinPolynomial;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Spline2D {
    public static final float DEFAULT_TIGHTNESS = 0.25f;
    public static final int DEFAULT_RES = 16;
    @XmlElement
    protected Vec2D[] points;
    @XmlElement(name="p")
    public List<Vec2D> pointList = new ArrayList<Vec2D>();
    @XmlTransient
    public List<Vec2D> vertices;
    @XmlTransient
    public BernsteinPolynomial bernstein;
    @XmlTransient
    public Vec2D[] delta;
    @XmlTransient
    public Vec2D[] coeffA;
    @XmlTransient
    public float[] bi;
    @XmlAttribute
    protected float tightness;
    @XmlTransient
    protected float invTightness;
    @XmlTransient
    protected int numP;
    @XmlTransient
    private float[] arcLenIndex;

    public Spline2D() {
        this.setTightness(0.25f);
    }

    public Spline2D(List<Vec2D> list) {
        this(list, null, 0.25f);
    }

    public Spline2D(List<Vec2D> list, BernsteinPolynomial bernsteinPolynomial, float f) {
        this.pointList.addAll(list);
        this.bernstein = bernsteinPolynomial;
        this.setTightness(f);
    }

    public Spline2D(Vec2D[] vec2DArray) {
        this(vec2DArray, null, 0.25f);
    }

    public Spline2D(Vec2D[] vec2DArray, BernsteinPolynomial bernsteinPolynomial, float f) {
        this(Arrays.asList(vec2DArray), bernsteinPolynomial, f);
    }

    public Spline2D add(float f, float f2) {
        return this.add(new Vec2D(f, f2));
    }

    public Spline2D add(ReadonlyVec2D readonlyVec2D) {
        this.pointList.add(readonlyVec2D.copy());
        return this;
    }

    public List<Vec2D> computeVertices(int n) {
        this.updateCoefficients();
        if (n < 1) {
            n = 1;
        }
        if (this.bernstein == null || this.bernstein.resolution != ++n) {
            this.bernstein = new BernsteinPolynomial(n);
        }
        if (this.vertices == null) {
            this.vertices = new ArrayList<Vec2D>();
        } else {
            this.vertices.clear();
        }
        this.findCPoints();
        Vec2D vec2D = new Vec2D();
        Vec2D vec2D2 = new Vec2D();
        --n;
        for (int i = 0; i < this.numP - 1; ++i) {
            Vec2D vec2D3 = this.points[i];
            Vec2D vec2D4 = this.points[i + 1];
            vec2D.set(this.delta[i]).addSelf(vec2D3);
            vec2D2.set(vec2D4).subSelf(this.delta[i + 1]);
            for (int j = 0; j < n; ++j) {
                float f = vec2D3.x * this.bernstein.b0[j] + vec2D.x * this.bernstein.b1[j] + vec2D2.x * this.bernstein.b2[j] + vec2D4.x * this.bernstein.b3[j];
                float f2 = vec2D3.y * this.bernstein.b0[j] + vec2D.y * this.bernstein.b1[j] + vec2D2.y * this.bernstein.b2[j] + vec2D4.y * this.bernstein.b3[j];
                this.vertices.add(new Vec2D(f, f2));
            }
        }
        this.vertices.add(this.points[this.points.length - 1]);
        return this.vertices;
    }

    protected void findCPoints() {
        int n;
        this.bi[1] = -this.tightness;
        this.coeffA[1].set((this.points[2].x - this.points[0].x - this.delta[0].x) * this.tightness, (this.points[2].y - this.points[0].y - this.delta[0].y) * this.tightness);
        for (n = 2; n < this.numP - 1; ++n) {
            this.bi[n] = -1.0f / (this.invTightness + this.bi[n - 1]);
            this.coeffA[n].set(-(this.points[n + 1].x - this.points[n - 1].x - this.coeffA[n - 1].x) * this.bi[n], -(this.points[n + 1].y - this.points[n - 1].y - this.coeffA[n - 1].y) * this.bi[n]);
        }
        for (n = this.numP - 2; n > 0; --n) {
            this.delta[n].set(this.coeffA[n].x + this.delta[n + 1].x * this.bi[n], this.coeffA[n].y + this.delta[n + 1].y * this.bi[n]);
        }
    }

    public List<Vec2D> getDecimatedVertices(float f) {
        return this.getDecimatedVertices(f, true);
    }

    public List<Vec2D> getDecimatedVertices(float f, boolean bl) {
        if (this.vertices == null || this.vertices.size() < 2) {
            this.computeVertices(16);
        }
        float f2 = this.getEstimatedArcLength();
        ArrayList<Vec2D> arrayList = new ArrayList<Vec2D>();
        double d = f / f2;
        int n = 0;
        for (double d2 = 0.0; d2 < 1.0; d2 += d) {
            double d3 = d2 * (double)f2;
            while (d3 >= (double)this.arcLenIndex[n]) {
                ++n;
            }
            ReadonlyVec2D readonlyVec2D = this.vertices.get(n - 1);
            Vec2D vec2D = this.vertices.get(n);
            float f3 = (float)((d3 - (double)this.arcLenIndex[n - 1]) / (double)(this.arcLenIndex[n] - this.arcLenIndex[n - 1]));
            Vec2D vec2D2 = readonlyVec2D.interpolateTo(vec2D, f3);
            arrayList.add(vec2D2);
        }
        if (bl) {
            arrayList.add(this.vertices.get(this.vertices.size() - 1));
        }
        return arrayList;
    }

    public float getEstimatedArcLength() {
        if (this.arcLenIndex == null || this.arcLenIndex != null && this.arcLenIndex.length != this.vertices.size()) {
            this.arcLenIndex = new float[this.vertices.size()];
        }
        float f = 0.0f;
        for (int i = 1; i < this.arcLenIndex.length; ++i) {
            ReadonlyVec2D readonlyVec2D = this.vertices.get(i - 1);
            Vec2D vec2D = this.vertices.get(i);
            this.arcLenIndex[i] = f += readonlyVec2D.distanceTo(vec2D);
        }
        return f;
    }

    public int getNumPoints() {
        return this.numP;
    }

    public List<Vec2D> getPointList() {
        return this.pointList;
    }

    public float getTightness() {
        return this.tightness;
    }

    public Spline2D setPointList(List<Vec2D> list) {
        this.pointList.clear();
        for (Vec2D vec2D : list) {
            this.add(vec2D);
        }
        return this;
    }

    public Spline2D setTightness(float f) {
        this.tightness = f;
        this.invTightness = 1.0f / f;
        return this;
    }

    public void updateCoefficients() {
        this.numP = this.pointList.size();
        if (this.points == null || this.points != null && this.points.length != this.numP) {
            this.coeffA = new Vec2D[this.numP];
            this.delta = new Vec2D[this.numP];
            this.bi = new float[this.numP];
            for (int i = 0; i < this.numP; ++i) {
                this.coeffA[i] = new Vec2D();
                this.delta[i] = new Vec2D();
            }
            this.setTightness(this.tightness);
        }
        this.points = this.pointList.toArray(new Vec2D[0]);
    }
}

