/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh2d;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import toxi.geom.mesh2d.DelaunayTriangle;
import toxi.geom.mesh2d.DelaunayVertex;
import toxi.util.datatypes.UndirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelaunayTriangulation
extends AbstractSet<DelaunayTriangle> {
    private DelaunayTriangle mostRecent = null;
    private UndirectedGraph<DelaunayTriangle> triGraph = new UndirectedGraph();

    public DelaunayTriangulation(DelaunayTriangle delaunayTriangle) {
        this.triGraph.add(delaunayTriangle);
        this.mostRecent = delaunayTriangle;
    }

    @Override
    public boolean contains(Object object) {
        return this.triGraph.getNodes().contains(object);
    }

    public void delaunayPlace(DelaunayVertex delaunayVertex) {
        DelaunayTriangle delaunayTriangle = this.locate(delaunayVertex);
        if (delaunayTriangle == null) {
            throw new IllegalArgumentException("No containing triangle");
        }
        if (delaunayTriangle.contains(delaunayVertex)) {
            return;
        }
        Set<DelaunayTriangle> set = this.getCavity(delaunayVertex, delaunayTriangle);
        this.mostRecent = this.update(delaunayVertex, set);
    }

    private Set<DelaunayTriangle> getCavity(DelaunayVertex delaunayVertex, DelaunayTriangle delaunayTriangle) {
        HashSet<DelaunayTriangle> hashSet = new HashSet<DelaunayTriangle>();
        LinkedList<DelaunayTriangle> linkedList = new LinkedList<DelaunayTriangle>();
        HashSet<DelaunayTriangle> hashSet2 = new HashSet<DelaunayTriangle>();
        linkedList.add(delaunayTriangle);
        hashSet2.add(delaunayTriangle);
        while (!linkedList.isEmpty()) {
            delaunayTriangle = (DelaunayTriangle)linkedList.remove();
            if (delaunayVertex.vsCircumcircle(delaunayTriangle.toArray(new DelaunayVertex[0])) == 1) continue;
            hashSet.add(delaunayTriangle);
            for (DelaunayTriangle delaunayTriangle2 : this.triGraph.getConnectedNodesFor(delaunayTriangle)) {
                if (hashSet2.contains(delaunayTriangle2)) continue;
                hashSet2.add(delaunayTriangle2);
                linkedList.add(delaunayTriangle2);
            }
        }
        return hashSet;
    }

    @Override
    public Iterator<DelaunayTriangle> iterator() {
        return this.triGraph.getNodes().iterator();
    }

    public DelaunayTriangle locate(DelaunayVertex delaunayVertex) {
        DelaunayTriangle delaunayTriangle = this.mostRecent;
        if (!this.contains(delaunayTriangle)) {
            delaunayTriangle = null;
        }
        HashSet<DelaunayTriangle> hashSet = new HashSet<DelaunayTriangle>();
        while (delaunayTriangle != null) {
            if (hashSet.contains(delaunayTriangle)) {
                System.out.println("Warning: Caught in a locate loop");
                break;
            }
            hashSet.add(delaunayTriangle);
            DelaunayVertex delaunayVertex2 = delaunayVertex.isOutside(delaunayTriangle.toArray(new DelaunayVertex[0]));
            if (delaunayVertex2 == null) {
                return delaunayTriangle;
            }
            delaunayTriangle = this.neighborOpposite(delaunayVertex2, delaunayTriangle);
        }
        System.out.println("Warning: Checking all triangles for " + delaunayVertex);
        for (DelaunayTriangle delaunayTriangle2 : this) {
            if (delaunayVertex.isOutside(delaunayTriangle2.toArray(new DelaunayVertex[0])) != null) continue;
            return delaunayTriangle2;
        }
        System.out.println("Warning: No triangle holds " + delaunayVertex);
        return null;
    }

    public DelaunayTriangle neighborOpposite(DelaunayVertex delaunayVertex, DelaunayTriangle delaunayTriangle) {
        if (!delaunayTriangle.contains(delaunayVertex)) {
            throw new IllegalArgumentException("Bad vertex; not in triangle");
        }
        for (DelaunayTriangle delaunayTriangle2 : this.triGraph.getConnectedNodesFor(delaunayTriangle)) {
            if (delaunayTriangle2.contains(delaunayVertex)) continue;
            return delaunayTriangle2;
        }
        return null;
    }

    public Set<DelaunayTriangle> neighbors(DelaunayTriangle delaunayTriangle) {
        return this.triGraph.getConnectedNodesFor(delaunayTriangle);
    }

    @Override
    public int size() {
        return this.triGraph.getNodes().size();
    }

    public List<DelaunayTriangle> surroundingTriangles(DelaunayVertex delaunayVertex, DelaunayTriangle delaunayTriangle) {
        if (!delaunayTriangle.contains(delaunayVertex)) {
            throw new IllegalArgumentException("Site not in triangle");
        }
        ArrayList<DelaunayTriangle> arrayList = new ArrayList<DelaunayTriangle>();
        DelaunayTriangle delaunayTriangle2 = delaunayTriangle;
        DelaunayVertex delaunayVertex2 = delaunayTriangle.getVertexButNot(delaunayVertex);
        do {
            arrayList.add(delaunayTriangle);
            DelaunayTriangle delaunayTriangle3 = delaunayTriangle;
            delaunayTriangle = this.neighborOpposite(delaunayVertex2, delaunayTriangle);
            delaunayVertex2 = delaunayTriangle3.getVertexButNot(delaunayVertex, delaunayVertex2);
        } while (delaunayTriangle != delaunayTriangle2);
        return arrayList;
    }

    @Override
    public String toString() {
        return "DelaunayTriangulation with " + this.size() + " triangles";
    }

    private DelaunayTriangle update(DelaunayVertex delaunayVertex, Set<DelaunayTriangle> set) {
        HashSet<DelaunayTriangle> hashSet = new HashSet<DelaunayTriangle>();
        HashSet<DelaunayTriangle> hashSet2 = new HashSet<DelaunayTriangle>();
        for (DelaunayTriangle iterator2 : set) {
            hashSet2.addAll(this.neighbors(iterator2));
            for (Object object : iterator2) {
                DelaunayTriangle delaunayTriangle2 = iterator2.facetOpposite((DelaunayVertex)object);
                if (hashSet.contains(delaunayTriangle2)) {
                    hashSet.remove(delaunayTriangle2);
                    continue;
                }
                hashSet.add(delaunayTriangle2);
            }
        }
        hashSet2.removeAll(set);
        for (DelaunayTriangle delaunayTriangle : set) {
            this.triGraph.remove(delaunayTriangle);
        }
        HashSet hashSet3 = new HashSet();
        for (Set set2 : hashSet) {
            Object object;
            set2.add(delaunayVertex);
            object = new DelaunayTriangle(set2);
            this.triGraph.add((DelaunayTriangle)object);
            hashSet3.add(object);
        }
        hashSet2.addAll(hashSet3);
        Iterator iterator = hashSet3.iterator();
        while (iterator.hasNext()) {
            DelaunayTriangle delaunayTriangle = (DelaunayTriangle)iterator.next();
            for (DelaunayTriangle delaunayTriangle2 : hashSet2) {
                if (!delaunayTriangle.isNeighbor(delaunayTriangle2)) continue;
                this.triGraph.connect(delaunayTriangle, delaunayTriangle2);
            }
        }
        return (DelaunayTriangle)hashSet3.iterator().next();
    }
}

