/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics.behaviors;

import toxi.geom.Vec3D;
import toxi.physics.VerletParticle;
import toxi.physics.behaviors.ParticleBehavior;

public class AttractionBehavior
implements ParticleBehavior {
    protected Vec3D attractor;
    protected float attrStrength;
    protected float radius;
    protected float radiusSquared;
    protected float strength;
    protected float jitter;
    protected float timeStep;

    public AttractionBehavior(Vec3D vec3D, float f, float f2) {
        this(vec3D, f, f2, 0.0f);
    }

    public AttractionBehavior(Vec3D vec3D, float f, float f2, float f3) {
        this.attractor = vec3D;
        this.strength = f2;
        this.jitter = f3;
        this.setRadius(f);
    }

    public void apply(VerletParticle verletParticle) {
        Vec3D vec3D = this.attractor.sub((Vec3D)verletParticle);
        float f = vec3D.magSquared();
        if (f < this.radiusSquared) {
            Vec3D vec3D2 = vec3D.normalizeTo(1.0f - f / this.radiusSquared).jitter(this.jitter).scaleSelf(this.attrStrength);
            verletParticle.addForce(vec3D2);
        }
    }

    public void configure(float f) {
        this.timeStep = f;
        this.setStrength(this.strength);
    }

    public Vec3D getAttractor() {
        return this.attractor;
    }

    public float getJitter() {
        return this.jitter;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setAttractor(Vec3D vec3D) {
        this.attractor = vec3D;
    }

    public void setJitter(float f) {
        this.jitter = f;
    }

    public void setRadius(float f) {
        this.radius = f;
        this.radiusSquared = f * f;
    }

    public void setStrength(float f) {
        this.strength = f;
        this.attrStrength = f * this.timeStep;
    }
}

