/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics2d;

import java.util.ArrayList;
import java.util.List;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Rect;
import toxi.geom.Vec2D;
import toxi.physics2d.behaviors.ParticleBehavior2D;
import toxi.physics2d.constraints.ParticleConstraint2D;

public class VerletParticle2D
extends Vec2D {
    protected Vec2D prev;
    protected Vec2D temp;
    protected boolean isLocked;
    public Rect bounds;
    public List<ParticleConstraint2D> constraints;
    public List<ParticleBehavior2D> behaviors;
    protected float weight;
    protected float invWeight;
    protected Vec2D force = new Vec2D();

    public VerletParticle2D(float f, float f2) {
        this(f, f2, 1.0f);
    }

    public VerletParticle2D(float f, float f2, float f3) {
        super(f, f2);
        this.prev = new Vec2D((ReadonlyVec2D)this);
        this.temp = new Vec2D();
        this.setWeight(f3);
    }

    public VerletParticle2D(ReadonlyVec2D readonlyVec2D) {
        this(readonlyVec2D.x(), readonlyVec2D.y(), 1.0f);
    }

    public VerletParticle2D(ReadonlyVec2D readonlyVec2D, float f) {
        this(readonlyVec2D.x(), readonlyVec2D.y(), f);
    }

    public VerletParticle2D(VerletParticle2D verletParticle2D) {
        this(verletParticle2D.x, verletParticle2D.y, verletParticle2D.weight);
        this.isLocked = verletParticle2D.isLocked;
    }

    public VerletParticle2D addBehavior(ParticleBehavior2D particleBehavior2D) {
        return this.addBehavior(particleBehavior2D, 1.0f);
    }

    public VerletParticle2D addBehavior(ParticleBehavior2D particleBehavior2D, float f) {
        if (this.behaviors == null) {
            this.behaviors = new ArrayList<ParticleBehavior2D>(1);
        }
        particleBehavior2D.configure(f);
        this.behaviors.add(particleBehavior2D);
        return this;
    }

    public VerletParticle2D addConstraint(ParticleConstraint2D particleConstraint2D) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ParticleConstraint2D>(1);
        }
        this.constraints.add(particleConstraint2D);
        return this;
    }

    public VerletParticle2D addForce(Vec2D vec2D) {
        this.force.addSelf(vec2D);
        return this;
    }

    public VerletParticle2D addVelocity(Vec2D vec2D) {
        this.prev.subSelf(vec2D);
        return this;
    }

    public void applyBehaviors() {
        if (this.behaviors != null) {
            for (ParticleBehavior2D particleBehavior2D : this.behaviors) {
                particleBehavior2D.apply(this);
            }
        }
    }

    public void applyConstraints() {
        if (this.constraints != null) {
            for (ParticleConstraint2D particleConstraint2D : this.constraints) {
                particleConstraint2D.apply(this);
            }
        }
    }

    protected void applyForce() {
        this.temp.set((Vec2D)this);
        this.addSelf(this.sub(this.prev).addSelf(this.force.scale(this.weight)));
        this.prev.set(this.temp);
        this.force.clear();
    }

    public VerletParticle2D clearForce() {
        this.force.clear();
        return this;
    }

    public VerletParticle2D clearVelocity() {
        this.prev.set((Vec2D)this);
        return this;
    }

    public final float getInvWeight() {
        return this.invWeight;
    }

    public Vec2D getPreviousPosition() {
        return this.prev;
    }

    public Vec2D getVelocity() {
        return this.sub(this.prev);
    }

    public final float getWeight() {
        return this.weight;
    }

    public final boolean isLocked() {
        return this.isLocked;
    }

    public VerletParticle2D lock() {
        this.isLocked = true;
        return this;
    }

    public VerletParticle2D removeAllBehaviors() {
        this.behaviors.clear();
        return this;
    }

    public VerletParticle2D removeAllConstraints() {
        this.constraints.clear();
        return this;
    }

    public boolean removeBehavior(ParticleBehavior2D particleBehavior2D) {
        return this.behaviors.remove(particleBehavior2D);
    }

    public boolean removeConstraint(ParticleConstraint2D particleConstraint2D) {
        return this.constraints.remove(particleConstraint2D);
    }

    public VerletParticle2D scaleVelocity(float f) {
        this.prev.interpolateToSelf((ReadonlyVec2D)this, 1.0f - f);
        return this;
    }

    public VerletParticle2D setPreviousPosition(Vec2D vec2D) {
        this.prev.set(vec2D);
        return this;
    }

    public void setWeight(float f) {
        this.weight = f;
        this.invWeight = 1.0f / f;
    }

    public VerletParticle2D unlock() {
        this.clearVelocity();
        this.isLocked = false;
        return this;
    }

    public void update() {
        if (!this.isLocked) {
            this.applyBehaviors();
            this.applyForce();
            this.applyConstraints();
        }
    }
}

