/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics2d.constraints;

import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;
import toxi.math.MathUtils;
import toxi.physics2d.VerletParticle2D;
import toxi.physics2d.constraints.ParticleConstraint2D;

public class AngularConstraint
implements ParticleConstraint2D {
    public Vec2D rootPos;
    public float theta;

    public AngularConstraint(float f) {
        this.theta = f;
    }

    public AngularConstraint(int n) {
        this.theta = MathUtils.radians((float)n);
    }

    public AngularConstraint(Vec2D vec2D, int n) {
        this.rootPos = new Vec2D((ReadonlyVec2D)vec2D);
        this.theta = MathUtils.radians((float)n);
    }

    public void apply(VerletParticle2D verletParticle2D) {
        Vec2D vec2D = verletParticle2D.sub(this.rootPos);
        float f = (float)MathUtils.floor((float)(vec2D.heading() / this.theta)) * this.theta;
        verletParticle2D.set(this.rootPos.add(Vec2D.fromTheta((float)f).scaleSelf(vec2D.magnitude())));
    }
}

