/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics2d.constraints;

import toxi.geom.Ray2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Rect;
import toxi.geom.Vec2D;
import toxi.physics2d.VerletParticle2D;
import toxi.physics2d.constraints.ParticleConstraint2D;

public class RectConstraint
implements ParticleConstraint2D {
    protected Rect rect;
    protected Ray2D intersectRay;

    public RectConstraint(Rect rect) {
        this.rect = rect.copy();
        this.intersectRay = new Ray2D((ReadonlyVec2D)rect.getCentroid(), (ReadonlyVec2D)new Vec2D());
    }

    public RectConstraint(Vec2D vec2D, Vec2D vec2D2) {
        this(new Rect((ReadonlyVec2D)vec2D, (ReadonlyVec2D)vec2D2));
    }

    public void apply(VerletParticle2D verletParticle2D) {
        if (this.rect.containsPoint((ReadonlyVec2D)verletParticle2D)) {
            verletParticle2D.set(this.rect.intersectsRay(this.intersectRay.setDirection((ReadonlyVec2D)this.intersectRay.sub((Vec2D)verletParticle2D)), 0.0f, Float.MAX_VALUE));
        }
    }

    public Rect getBox() {
        return this.rect.copy();
    }

    public void setBox(Rect rect) {
        this.rect = rect.copy();
        this.intersectRay.set(rect.getCentroid());
    }
}

