/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import java.util.ArrayList;
import moonlander.library.ControllerListener;

abstract class Controller {
    protected double currentRow = 0.0;
    protected double rowsPerSecond;
    private boolean playing;
    ArrayList<ControllerListener> listeners = new ArrayList();

    public Controller(double d) {
        this.rowsPerSecond = d;
        this.playing = false;
    }

    public void addEventListener(ControllerListener controllerListener) {
        this.listeners.add(controllerListener);
    }

    public void removeEventListener(ControllerListener controllerListener) {
        this.listeners.remove(controllerListener);
    }

    public double getCurrentRow() {
        return this.currentRow;
    }

    public double getCurrentTime() {
        return this.currentRow / this.rowsPerSecond;
    }

    public void setCurrentRow(double d, boolean bl) {
        if ((int)d != (int)this.currentRow && !bl) {
            for (ControllerListener controllerListener : this.listeners) {
                controllerListener.controllerRowChanged((int)d);
            }
        }
        this.currentRow = d;
    }

    public abstract void update();

    public boolean isPlaying() {
        return this.playing;
    }

    private void setPlayState(boolean bl) {
        if (bl != this.playing) {
            this.playing = bl;
            for (ControllerListener controllerListener : this.listeners) {
                controllerListener.controllerStatusChanged(bl);
            }
        }
    }

    public void pause() {
        this.setPlayState(false);
    }

    public void play() {
        this.setPlayState(true);
    }
}

