#define highp
#define lowp

struct MATERIAL
{
  lowp vec3 specular ;
  lowp vec3 emission ;
  lowp float transparency ;
  lowp int numTextures ;
  lowp int useLights ;
  vec2 offset_animacion0 ;
  vec2 offset_animacion1 ;
} ;


struct LIGHT
{
  lowp vec3 diffuse ;
  highp float attenuation_start ;

  highp vec3 position ;
  highp float attenuation_end ;

  lowp vec3 direction ;
  highp float hotspot_beam ;

  highp float falloff ;

  lowp int type ;
} ;


struct LightModelParameters
{
  lowp vec3 ambient ;
} ;



uniform highp mat4 NormalMatrix ;
uniform highp mat4 ModelViewProjectionMatrix ;
uniform highp mat4 WorldMatrix ;
uniform highp mat4 ProjectionMatrix ;
uniform highp vec3 posicion_camara_world ;
uniform LIGHT g_Lights[MAX_LIGHTS] ;
uniform LightModelParameters g_LightModel ;
uniform MATERIAL g_DatosMaterial ;
uniform highp sampler2D shader_texture_ids[NUMERO_MAXIMO_TEXTURAS_POR_MATERIAL] ;


varying lowp vec4  color_final_BLUR ;
varying /*lowp*/ vec2 text_coord[NUMERO_MAXIMO_TEXTURAS_POR_MATERIAL] ;
varying lowp vec3 light_final_intensity ;
varying lowp vec3 light_final_specular ;
