uniform float iGlobalTime;
uniform vec3 iResolution;

uniform float u_mode;

const float beam_w = 0.001;

float lined(vec2 l1, vec2 l2, vec2 p)
{
/*    float num = abs(lv.y*p.x - lv.x*p.y + l2.x*l1.y-l2.y*l1.x);
	float den = length(lv);
	
	return num / den;
*/
/*
	vec2 lv = l2 - l1;

	float len2 = dot(lv,lv);
	float t = dot(p-l1, lv) / len2;
	if (t < 0.0)
		return distance(l1, p);
	else if (t > 1.0)
		return distance(l2, p);
	
	vec2 proj = l1  + t * lv;
	
	return distance(proj, p);*/

	vec2 pl1 = p - l1;
	vec2 l2l1 = l2 - l1;
	float h = clamp(dot(pl1, l2l1)/dot(l2l1, l2l1), 0.0, 1.0);
	return length(pl1 - l2l1 * h) - beam_w;
}

float circled(vec2 c, float r, vec2 p)
{
	return abs(distance(c,p) - r) - beam_w;
}

float dotd(vec2 c, vec2 p)
{
	return distance(c, p)- beam_w;
}

vec2 uv2;

float shade(float d)
{
  //  d += sin(abs(uv2.x) * 9.0 - iGlobalTime * 12.0) * 0.01;
	
	float c = 0.0;
	c += max(0.0, 1.0-d * 90.0);
	
	float bloom = 0.5; //0.9 + sin(iGlobalTime * 16.7)*0.06 + sin(iGlobalTime * 35.4)*0.05;

	c += pow(max(0.0, 1.0 - d), 12.0) * 0.3 * bloom;
	
	return c;
}


float rand(float x)
{
 return fract(sin(x) * 43758.5453);
}

vec2 clockpos = vec2(0.0, 0.1);

float viisari(float ang, float l, float w, vec2 p)
{
	vec2 p1 = vec2(sin(ang), cos(ang)) * l;
	vec2 p2 = vec2(cos(ang), -sin(ang)) * w;
	vec2 p3 = -p2;
	
	p1 += clockpos;
	p2 += clockpos;
	p3 += clockpos;
	
	float c = 0.0;
	c += shade(lined(p1, p2, p));
	c += shade(lined(p2, p3, p));
	c += shade(lined(p3, p1, p));
	
	return c;
}

float letter_h(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.0)*scl, pos+vec2(0.0, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.1, 0.0)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl, pos+vec2(0.1, 0.1)*scl,uv2));
	return c;
}

float letter_a(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.05, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.1, 0.0)*scl,pos+vec2(0.05, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.1,  0.0)*scl,uv2));   
	return c;
}

float letter_c(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.0, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.1, 0.0)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}

float letter_k(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.0, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.0)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}

float letter_e(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.0, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.1, 0.0)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}

float letter_f(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.0, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}

float letter_o(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.0, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.1, 0.0)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.1, 0.0)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}


float letter_r(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.0, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.1, 0.2)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.0)*scl,uv2));
	return c;
}

float letter_s(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.1, 0.0)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.0, 0.2)*scl,uv2));

	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.1, 0.0)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}

float letter_1(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.1, 0.0)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}
float letter_9(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.1, 0.0)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.0, 0.2)*scl,uv2));

	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.1, 0.0)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}

float letter_8(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.1, 0.0)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.0, 0.2)*scl,uv2));

	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.1, 0.0)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}

float letter_5(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.1, 0.0)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.0, 0.2)*scl,uv2));

	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.1, 0.0)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}

float letter_y(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.05, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.1, 0.2)*scl,pos+vec2(0.05, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.05, 0.0)*scl,pos+vec2(0.05,  0.1)*scl,uv2));
	return c;
}

float letter_p(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.0, 0.2)*scl,uv2));
	c += shade(lined(pos+vec2(0.1, 0.2)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.1, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.1, 0.2)*scl,uv2));
	return c;
}

float letter_b(vec2 pos, vec2 scl)
{
	float c = 0.0;
	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.0, 0.2)*scl,uv2));

	c += shade(lined(pos+vec2(0.0, 0.0)*scl,pos+vec2(0.05, 0.0)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.1)*scl,pos+vec2(0.05, 0.1)*scl,uv2));
	c += shade(lined(pos+vec2(0.0, 0.2)*scl,pos+vec2(0.05, 0.2)*scl,uv2));

	c += shade(lined(pos+vec2(0.05, 0.0)*scl,pos+vec2(0.1, 0.05)*scl,uv2));
	c += shade(lined(pos+vec2(0.05, 0.1)*scl,pos+vec2(0.1, 0.05)*scl,uv2));
	c += shade(lined(pos+vec2(0.05, 0.1)*scl,pos+vec2(0.1, 0.15)*scl,uv2));
	c += shade(lined(pos+vec2(0.05, 0.2)*scl,pos+vec2(0.1, 0.15)*scl,uv2));

	return c;
}



void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
	
	uv2 = uv-vec2(0.5);
	
	uv2.x *= iResolution.z;
	uv2 *= 2.3;
	uv2.x += sin(uv.y * 9.0 + iGlobalTime * 2.0) * 0.001;
	uv2.y += sin(uv.x * 8.0 + iGlobalTime * 3.0) * 0.001;
	
	float c = 0.0;
	
	float sec = iGlobalTime*(134.0/120.0) + ((4.0*60.0+19.0)*60.0);

	float v1 = mod(floor(sec), 60.0);
	float v2 = mod(floor(sec/ 60.0), 60.0);
	float v3 = (sec/ (60.0 * 60.0));
	

	if (u_mode < 0.5)
	{
		for (int i = 0; i < 12; i++)
		{
			float ang = float(i) * 2.0 * 3.14159 / 12.0;
			vec2 newpos = clockpos + vec2(cos(ang), sin(ang)) * 0.76;
			c += shade(dotd(newpos, uv2));
		}

		c += viisari(v1 * 3.14159 / 30.0, 0.72, 0.02,uv2);
		c += viisari(v2 * 3.14159 / 30.0, 0.65, 0.05,uv2);
		c += viisari(v3 * 3.14159 / 6.0, 0.5, 0.03, uv2);

		c += shade(circled(clockpos, 0.8, uv2));

		float uhh = 2.5 / 7.0;
		float og = 0.0 - uhh*6.5*0.5;
		c += letter_h(vec2(og+uhh*0.0, -0.95), vec2(1.0));
		c += letter_a(vec2(og+uhh*1.0, -0.95), vec2(1.0));
		c += letter_c(vec2(og+uhh*2.0, -0.95), vec2(1.0));
		c += letter_k(vec2(og+uhh*3.0, -0.95), vec2(1.0));
		c += letter_e(vec2(og+uhh*4.0, -0.95), vec2(1.0));
		c += letter_r(vec2(og+uhh*5.0, -0.95), vec2(1.0));
		c += letter_s(vec2(og+uhh*6.0, -0.95), vec2(1.0));
	}
	else
	{
		vec2 uhh2 = vec2(0.3, 0.0);
		vec2 og2 = vec2(0.0, -0.45) - vec2((0.1 * 4.5 + 0.2 * 3.0) * 0.5, 0.0);
		c += letter_1(og2+uhh2*0.0, vec2(1.0));
		c += letter_9(og2+uhh2*1.0, vec2(1.0));
		c += letter_8(og2+uhh2*2.0, vec2(1.0));
		c += letter_5(og2+uhh2*3.0, vec2(1.0));
	
		vec2 uhh3 = vec2(0.3, 0.0);
		vec2 og3 = vec2(0.0, -0.10) - vec2((0.1 * 7.0 + 0.2 * 6.0) * 0.5, 0.0);
		c += letter_p(og3+uhh3*0.0, vec2(1.0,2.0));
		c += letter_a(og3+uhh3*1.0, vec2(1.0,2.0));
		c += letter_y(og3+uhh3*2.0, vec2(1.0,2.0));
		c += letter_b(og3+uhh3*3.0, vec2(1.0,2.0));
		c += letter_a(og3+uhh3*4.0, vec2(1.0,2.0));
		c += letter_c(og3+uhh3*5.0, vec2(1.0,2.0));
		c += letter_k(og3+uhh3*6.0, vec2(1.0,2.0));

		vec2 uhh4 = vec2(0.3, 0.0);
		vec2 og4 = vec2(0.0, 0.45) - vec2((0.05 * 3.0 + 0.25 * 2.0) * 0.5, 0.0);
		c += letter_f(og4+uhh4*0.0, vec2(0.5));
		c += letter_o(og4+uhh4*1.0, vec2(0.5));
		c += letter_r(og4+uhh4*2.0, vec2(0.5));
	}

	float vignet = min(1.0 - (abs(uv.x - 0.5) - 0.4) * 10.0, 1.0);
	vignet = min(vignet, min(1.0 - (abs(uv.y - 0.5) - 0.4) * 10.0, 1.0));
//	vignet = min(vignet, min(pow(1.0 / (0.2 + abs(uv.y - 0.5) * 5.0), 0.5), 1.0));

	c *= vignet;

	gl_FragColor = vec4(c) * vec4(0.5, 0.2, 2.0, 1.0);
	
	
   // float d = lined(vec2(0.2, 0.5), vec2(0.8,0.5 + sin(iGlobalTime) * 0.4), uv);
	//d = circled(vec2(0.5, 0.5), 0.4, uv);
	//gl_FragColor = vec4(d);
}