#version 330 core

// inputz
in vec2 UV;
in vec2 ray;
uniform sampler2D inputtext;
uniform float seed;

// outputz
out vec4 color;

mat2 rotate(float a) {
  return mat2(cos(a), -sin(a), sin(a), cos(a));
}

float rand(vec2 co){
    return (fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453) - 0.5) * 2.0;
}

void main() {
    color = texture(inputtext, UV);
    for (int i = 0; i < 15; i++) {
        float gradius = rand(UV + vec2(color.gr + vec2(seed, -seed)));
        color += texture(inputtext, UV + 0.01 * gradius * rotate(6.6 * rand(UV + vec2(color.rg + seed))) * vec2(1.0, 0.0));
    }
    color /= 16.0;
}
