#version 330 core
layout(location=0) in vec3 vertex;
layout(location=1) in vec3 normal;
layout(location=2) in vec2 uv;
out vec2 UV;
out vec3 n;
out vec4 worldPos;
out vec4 modelPos;
uniform mat4 MVP;
uniform mat4 MV;
uniform sampler2D disp;
uniform float iGlobalTime;
uniform float ampliytude;

uniform sampler2D fft;
uniform float fftAmplitude;
uniform float fftChannel;
uniform int modelType;

uniform float a1a; uniform float b1a; uniform float m1a; uniform float n11a; uniform float n21a; uniform float n31a;
uniform float a2b; uniform float b2b; uniform float m2b; uniform float n12b; uniform float n22b; uniform float n32b;


vec2 hash( vec2 p )
{
	p = vec2( dot(p,vec2(127.1,311.7)),
			  dot(p,vec2(269.5,183.3)) );

	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise( in vec2 p )
{
    const float K1 = 0.366025404; // (sqrt(3)-1)/2;
    const float K2 = 0.211324865; // (3-sqrt(3))/6;

	vec2 i = floor( p + (p.x+p.y)*K1 );
	
    vec2 a = p - i + (i.x+i.y)*K2;
    vec2 o = (a.x>a.y) ? vec2(1.0,0.0) : vec2(0.0,1.0); //vec2 of = 0.5 + 0.5*vec2(sign(a.x-a.y), sign(a.y-a.x));
    vec2 b = a - o + K2;
	vec2 c = a - 1.0 + 2.0*K2;

    vec3 h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );

	vec3 n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));

    return dot( n, vec3(70.0) );
	
}

float snoise(vec2 uv) {
	uv *= 5.0;
    mat2 m = mat2( 1.6,  1.2, -1.2,  1.6 );
	float f  = 0.5000*noise( uv ); uv = m*uv;
	f += 0.2500*noise( uv ); uv = m*uv;
	f += 0.1250*noise( uv ); uv = m*uv;
	f += 0.0625*noise( uv ); uv = m*uv;
	f = 0.5 + 0.5*f;
	return f;
}

mat2 rotate(float a) {
	return mat2(
		cos(a), -sin(a),
		sin(a), cos(a)
		);
}

float radius(float x, float a, float b, float m, float n1, float n2, float n3) {
	float absA = pow(abs(cos(m * x / 4.0) / a), n2);
	float absB = pow(abs(sin(m * x / 4.0) / b), n3);
	float absthing = absA + absB;
	return pow(absthing, -1.0 / n1);
}

vec3 toSpherical(vec3 xyz) {
	float radius = length(xyz);
	return vec3(radius,
		        atan(xyz.y, xyz.x),
		        acos(xyz.z / radius));
}

vec3 superjormula(vec2 inpval, // <-- UV
	              float a1, float b1, float m1, float n11, float n21, float n31,
	              float a2, float b2, float m2, float n12, float n22, float n32) {
	float y = 3.1415926 * (-0.5 + inpval.x);
	float x = 2.0 * (-0.5 + inpval.y) * 3.1415926;
	float r1 = radius(x, a1, b1, m1, n11, n21, n31);
	float r2 = radius(y, a2, b2, m2, n12, n22, n32);
	return vec3(
			r1 * cos(x) * r2 * cos(y),
			r1 * sin(x) * r2 * cos(y),
			r2 * sin(y)
		);
}

vec3 supernormal(vec2 inpval, // <-- UV
	              float a1, float b1, float m1, float n11, float n21, float n31,
	              float a2, float b2, float m2, float n12, float n22, float n32) {
	const float delta = 1e-3;
	vec3 central = superjormula(inpval, a1, b1, m1, n11, n21, n31, a2, b2, m2, n12, n22, n32);
	vec3 centralx = superjormula(inpval + vec2(delta, 0.0), a1, b1, m1, n11, n21, n31, a2, b2, m2, n12, n22, n32);
	vec3 centraly = superjormula(inpval + vec2(0.0, delta), a1, b1, m1, n11, n21, n31, a2, b2, m2, n12, n22, n32);
	return normalize(cross(centralx - central, centraly - central));
}

vec3 getVertex() {
	if (modelType == 0) {
		return vertex;
	} else {
		return superjormula(uv.yx,
							a1a,  b1a,  m1a,  n11a,  n21a,  n31a,
							a2b,  b2b,  m2b,  n12b,  n22b,  n32b);
	}
}

vec3 getNormal() {
	if (modelType == 0) {
		return normal;
	} else {
		return supernormal(uv.yx,
							a1a,  b1a,  m1a,  n11a,  n21a,  n31a,
							a2b,  b2b,  m2b,  n12b,  n22b,  n32b);
	}
}

const float multipluyier = 0.0;
void main() {
	vec3 curVertex = getVertex();
	vec3 curNormal = getNormal();
	float frectum = texture(fft, vec2(fftChannel, 0.0)).x;
	float zval = round(10.0 * curVertex.y) / 10.0;
	vec3 hormal = normalize(vec3(curVertex.xy, 0.0));
	UV = rotate(multipluyier*iGlobalTime + fftAmplitude * frectum)*(uv - vec2(0.5) + multipluyier*0.05*iGlobalTime) + vec2(0.5);
	UV = round(UV * 20.0) / 20.0;
	float amplitude = ampliytude*snoise(vec2(zval, multipluyier*0.5*iGlobalTime)); // 2.0 * (0.5 + 0.5 * snoise(vec2(0.1*iGlobalTime, UV.x + UV.y)));
	vec3 distorsopart = float(modelType == 0) * (0.01*curNormal + hormal * (amplitude * (texture(disp, UV).x-0.0)));
	gl_Position = MVP * vec4(curVertex + distorsopart, 1.0);
	n = (transpose(inverse(MV)) * vec4(curNormal, 0.0)).xyz;
	worldPos = MV * vec4(curVertex, 1.0);
	modelPos = vec4(curVertex, 1.0);
}
