#version 330 core
layout(location=0) in vec3 deltaVertex;
layout(location=1) in vec4 vertex;
uniform mat4 M;
uniform mat4 V;
uniform mat4 P;
const float iGlobalTime = 0.0;

out vec2 UV;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec2 finalUV() {
	vec2 beg = round(2.0*vec2(rand(vec2(0.0, vertex.w)), rand(vec2(vertex.w, 0.0)))) / 2.0;
	return beg + 0.5 * (deltaVertex.xy + vec2(0.5));
}

vec2 hash( vec2 p ) {  						// rand in [-1,1]
	p = vec2( dot(p,vec2(127.1,311.7)),
			  dot(p,vec2(269.5,183.3)) );
	return -1. + 2.*fract(sin(p+20.)*53758.5453123);
}

float noise( in vec2 p ) {
    vec2 i = floor(p), f = fract(p);
	vec2 u = f*f*(3.-2.*f);
    return mix( mix( dot( hash( i + vec2(0.,0.) ), f - vec2(0.,0.) ), 
                     dot( hash( i + vec2(1.,0.) ), f - vec2(1.,0.) ), u.x),
                mix( dot( hash( i + vec2(0.,1.) ), f - vec2(0.,1.) ), 
                     dot( hash( i + vec2(1.,1.) ), f - vec2(1.,1.) ), u.x), u.y);
}

void main() {
	//gl_Position = P * V * M * vec4(vertex.xy + 0.1*(deltaVertex.xy * (1.0 + 0.4*noise(24579.0*vertex.xy + 0.5 * iGlobalTime))), 0.0, 1.0);
	vec3 radial = vertex.xyz;
	radial = radial * (0.9 + 0.2 * noise(vec2(iGlobalTime + vertex.y + vertex.z, vertex.x)));
	vec4 viewTfd = V * M * vec4(radial + 0.5*deltaVertex, 1.0);
	vec4 projd = P * viewTfd;
	gl_Position = projd;
	UV = finalUV();
}
