#ifdef GL_ES
    precision mediump float;
#endif

uniform float time;
uniform vec2 iResolution;
varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
uniform mat4 u_projTrans;
vec2 iMouse = vec2(cos(time),sin(time));

mat3 rotY(in float a){
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}
mat3 rotX(in float a){
    return mat3( 1.0, 0.0, 0.0,
                 0.0, cos(a), sin(a),
                0.0, -sin(a), cos(a)
                );
}
mat3 rotZ(in float a){
    return mat3( 
                cos(a), sin(a), 0.0,
                -sin(a), cos(a), 0.0,
                0.0,0.0,1.0
                );
}
mat2 rotate(float Angle){
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}
float udRoundBox( vec3 p, vec3 b, float r ){
  return length(max(abs(p)-b,0.0))-r;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float sdBox( vec3 p, vec3 b ){
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}
float udBox( vec3 p, vec3 b ){
    return length(max(abs(p)-b,0.0));
}
float sdCapsule( vec3 p, vec3 a, vec3 b, float r ){
    r*=max(min(time-2.6,1.),0.);
    vec3 pa = p - a , ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
float pallo(vec3 pos, float size){
    return length(pos)-size;  
}
float sdPlane( vec3 p, vec4 n ){
  // n must be normalized
  return dot(p,n.xyz) + n.w;
}

float length2( vec2 p ) {
    return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p ) {
    p = p*p*p; p = p*p;
    return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p ) {
    p = p*p; p = p*p; p = p*p;
    return pow( p.x + p.y, 1.0/8.0 );
}
float sdTorus88( vec3 p, vec2 t ) {
  vec2 q = vec2(length8(p.zy)-t.x,p.x);
  return length8(q)-t.y;
}
float sdTorus82( vec3 p, vec2 t ) {
  vec2 q = vec2(length2(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}

float palkki(in vec3 p, out vec3 color, out float reflectiveValue){
    float finalDistance = 10000000.;
    vec3 p_magic = vec3(p.x,p.y,p.z);
    p_magic *= rotY(-time+p_magic.y*0.1);
    p_magic.x += sin(p.y-time*3.4)*2.2;
    p_magic.z += sin(p.y-time*3.83+p.x*0.01)*2.2;
    p_magic.xz *= 1.0+sin(p.y*0.5-time*2.2)*0.2+sin(p.y*0.1-time*4.7)*0.2;
    p_magic.x = mod(p_magic.x,16.0)-8.0;
    p_magic.z = mod(p_magic.z,16.0)-8.0;
    vec3 bump = texture2D(iChannel0, (p_magic.yz * vec2(0.03) + vec2(1.0) )*rotate(p_magic.x*0.07) ).rgb*0.05;
    finalDistance = min(finalDistance, udRoundBox( p_magic-vec3(0.0), vec3(2.0,8.0,2.0)+bump , 0.1) );
    vec3 p2 = p_magic;
    vec3 p3 = p_magic;
    vec3 p4 = p_magic;
    p2.yxz *= rotY(3.14145*0.25);
    finalDistance = min(finalDistance, udRoundBox( (p2-vec3(2.0,0.0,0.0)), vec3(0.2,1.0,1.0)+bump , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p2-vec3(2.0,0.0,0.0)), vec3(0.4,0.8,0.8)+bump , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p_magic-vec3(2.0,-0.8,0.0)), vec3(0.4,1.2,0.8)+bump , 0.1 ) );
    
    
    p3.zyx *= rotY(3.14145*0.5);
    p3.yxz *= rotY(3.14145*0.25);
    p_magic.zyx *= rotY(3.14145*0.5);
    finalDistance = min(finalDistance, udRoundBox( (p3-vec3(2.0,0.0,0.0)), vec3(0.2,1.0,1.0)+bump , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p3-vec3(2.0,0.0,0.0)), vec3(0.4,0.8,0.8)+bump , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p_magic-vec3(2.0,-0.8,0.0)), vec3(0.4,1.2,0.8)+bump , 0.1 ) );
    
    
    p4.zyx *= rotY(-3.14145*0.5);
    p4.yxz *= rotY(3.14145*0.25);
    p_magic.zyx *= rotY(3.14145);
    finalDistance = min(finalDistance, udRoundBox( (p4-vec3(2.0,0.0,0.0)), vec3(0.2,1.0,1.0)+bump , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p4-vec3(2.0,0.0,0.0)), vec3(0.4,0.8,0.8)+bump , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p_magic-vec3(2.0,-0.8,0.0)), vec3(0.4,1.2,0.8)+bump , 0.1 ) );
    color = vec3(0.8,0.6,0.5)*bump*20.0;
    reflectiveValue = bump.r;
    return finalDistance;
}
float calculateDistance(in vec3 p, out vec3 color, out float reflectiveValue) {
    float height = texture2D(iChannel1, vec2(p.xz+time)*0.01 ).r;
    color = height+vec3(1.0);  
    reflectiveValue = 0.5;
    float finalDistance = 10000000.;
    p.y+=pow(length(p.xz*0.4),3.0)*0.001;
    /*
    float r = sqrt(p.x*p.x+p.y*p.y+p.z*p.z);
    float theta = acos(p.z/r);
    float gamma = atan(p.x,p.y)/3.14159;
    p = vec3( r, theta*r, gamma*r);
    */

    vec3 p3 = vec3(mod(p.x,12.0)-6.0, p.y+1.6, mod(p.z+time*16.0,8.0)-4.0);
    vec3 bump2 = texture2D(iChannel0, (p3.yz * vec2(0.03) + vec2(1.0) )*rotate(p3.x*0.07) ).rgb;
    finalDistance = min(finalDistance, udBox( p-vec3(0.0,-2.0+height*0.1+sin(p.x*0.6+time)*0.1,0.0), vec3(30.,0.7,30.0) ) );
    float dist1 = palkki(p,color,reflectiveValue);
    if(dist1 < finalDistance){
        finalDistance = dist1;
        reflectiveValue = 0.001;
    }
    return finalDistance;
}


float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource){
    const float epsilon = 0.02;
    vec3 rayStartPosition = rayPosition + normalVector*0.001;
    vec3 finalColor = vec3(0., 0., 0.);
    vec3 lightNormal = normalize(lightSource - rayPosition);
    float dist = 0.0;
    float lightAmount = 1.0;
        for(float i=0.; i<28.; i++) {
            rayPosition = rayStartPosition + dist * lightNormal;
            vec3 color;
            float dummy;
            float stepable = calculateDistance(rayPosition, color,dummy);
            dist += stepable;
            lightAmount = min(900.0*abs(stepable),lightAmount);
            if(length(rayPosition)>10.0)
                break;
        }
    return clamp(lightAmount,0.01,9.0);
}
vec3 tracer(vec3 rayStartPosition, vec3 rayDirection) {
    float epsilon = 0.01;
    
    vec3 rayPosition = rayStartPosition;

    vec3 normalVector;
    float dist = 0.1;
    vec3 returnColor = vec3(0.0);
    vec3 finalColor = vec3(0.0);
    vec3 lightSource = vec3(0.0,5.0,0.0);
    float reflectiveValue = 1.0;
    float reflectionNow = 1.0;
    float finalLight = 1.0;
    float stepable = 1000000.0;
    float possibleFogLight = 1.0;
    
    for(float k=0.; k<3.; k++) {
         stepable = 1000000.0;
         epsilon = 0.01;
        for(float i=0.; i<48.; i++) {
            vec3 color;
            stepable = calculateDistance(rayPosition, color, reflectiveValue);
            dist += stepable;
            rayPosition = rayStartPosition + dist * rayDirection;
            
            if(length(rayPosition)>32.5)
                break;
                
            epsilon += 0.0001*i;
            possibleFogLight -= 0.01;
            returnColor -= vec3(0.1,0.11,0.2) * i * 0.005;

            returnColor += vec3(0.1+time*0.011,0.11+time*0.008,0.2) * (1.0/length(rayPosition-vec3(0.0,time*0.02,time*0.02))) * (-0.05*time+0.7);
        
            if( abs(stepable) < epsilon) {
                vec3 C;
                float dummy = 0.0;
                normalVector = vec3(    calculateDistance(rayPosition+vec3(epsilon,0,0),C,dummy)-calculateDistance(rayPosition+vec3(-epsilon,0,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,epsilon,0),C,dummy)-calculateDistance(rayPosition+vec3(0,-epsilon,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,0,epsilon),C,dummy)-calculateDistance(rayPosition+vec3(0,0,-epsilon),C,dummy));
                normalVector = normalize(normalVector);
                float light = traceToLight(rayPosition, normalVector, lightSource);
                finalLight = min(finalLight, light);
                float lightDistance = distance(rayStartPosition,lightSource);
                
                finalColor = color * vec3(dot(normalVector, -rayDirection));
                
                
                vec3 lightDir = (lightSource-rayPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(normalVector, lightDir);
                reflectionNow = min(reflectionNow,reflectiveValue);
                
                finalColor+=max(pow(directLight,4.)*vec3(6.7,1.1,0.9),0.01)*reflectionNow;
                
                returnColor += ( vec3(finalLight) / (k*0.1/reflectionNow + 1.0)) * finalColor;
               
                break;
                
            }
        }
        dist = 0.1;
        rayStartPosition = rayPosition + normalVector;
        rayPosition = rayStartPosition;
        rayDirection = reflect(rayDirection, normalVector);
    } 
    vec2 dir = vec2(atan(rayDirection.x,rayDirection.z)/3.14159+1.0,rayDirection.y*0.5+0.5);
    returnColor+=2.0*vec3(dir.y*dir.y*0.1) / (1.0/reflectionNow);
    return returnColor;
}


void main() {
    vec3 cameraPosition = vec3( 0.+cos(time*0.643), 5., 0.+sin(time*1.53));
    cameraPosition *= rotY(time*0.037 - 1.0 );
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    float aspect = iResolution.x / iResolution.y;
    
    if(abs(uv.y)>10.0/16.0) {
        gl_FragColor = vec4(0.0,0.0,0.0,1.0);
    } else {
    vec3 direction = normalize(vec3(.5 * uv * vec2(aspect, 2.0), 1. )) ;
    direction *= rotY(time*0.04 - 1.0 );

    direction *= rotX(sin(time)*1.5 );
    direction *= rotY(0.7 );
    direction *= rotZ(cos(time*1.641)*0.04);

    float vignette = 1.0 / max(0.25 + 1.5*dot(uv,uv),1.);
    gl_FragColor = texture2D(u_texture,uv)*0.001  +  pow(vec4(tracer(cameraPosition, direction),1.1),1.6);
    }
}