
#ifdef vertexcompile

layout (location=0) in vec3 a_position;
layout (location=1) in float a_uv;

uniform mat4 world_to_cam;
uniform mat4 cam_to_clip;

uniform float t;

out float uv;

void main() {
	uv = a_uv;
	vec4 cpos = world_to_cam * vec4(a_position,1.0);
	gl_Position = cam_to_clip *cpos;
}

#endif

#ifdef fragmentcompile

layout (location=0) out vec4 outcol;
layout (location=1) out vec4 outbloom;

in float uv;
uniform float t;

void main() {
	if(uv>t || t>93.0)
		discard;
	outcol = vec4(.8, .9, 1.0, 1.0);
	outbloom = vec4(.04, .04, .08, 1.0);
}

#endif
