/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.Entity;
import game.Enemy;
import game.Game;
import game.Vec3;
import javax.vecmath.Vector3f;
import lights.DecayingLight;
import physics.Physics;
import renderer.ResourceHandler;
import renderer.glengine.Matrix4f;
import renderer.glengine.MeshBatch;
import renderer.glengine.Window;

public class AK47
extends Entity {
    private double damage = 20.0;
    private int ammo = 30;
    private int reloadTime = -1;
    Game game;
    private final int RELOAD_TIME = 6;

    public AK47(Physics physics, Vector3f pos, Vector3f rot, Game game) {
        this(physics, pos, rot, game, -1);
    }

    public AK47(Physics physics, Vector3f pos, Vector3f rot, Game game, int itemSpawnIndex) {
        super(physics, pos, rot, ResourceHandler.ak2, null, true, ResourceHandler.akTexture, 2.0, 0.8f);
        this.game = game;
        this.throwDamage = 34.0;
        this.spawnIndex = itemSpawnIndex;
    }

    @Override
    public boolean canBePickedUp() {
        return true;
    }

    @Override
    public void pickUp(Game game) {
        super.pickUp(game);
        game.sound.play(game.sound.CHAMBERING);
    }

    @Override
    public boolean use(Game game, Physics.CustomClosestRayResultCallback c) {
        this.reloadTime = 6;
        if (this.ammo <= 0) {
            return false;
        }
        if (c.e != null) {
            c.e.onHit(game);
            if (c.e instanceof Enemy) {
                Enemy e = (Enemy)c.e;
                e.hp -= this.damage;
            }
        }
        game.sound.play(game.sound.AK);
        --this.ammo;
        this.light();
        return false;
    }

    private void light() {
        Vec3 v = this.game.player.pos.subtract(new Vec3(this.getCenter()));
        v.multiply(2.0);
        this.game.lights.add(new DecayingLight(new Vec3(this.game.player.pos.x + v.x, this.game.player.pos.y + v.y, this.game.player.pos.z + v.z), new Vec3(1.0, 0.5, 0.1), 1.0f, 200){

            @Override
            public float getLightDirPow() {
                return 0.0f;
            }

            @Override
            public Vec3 getDir() {
                return new Vec3(0.0, 0.0, 0.0);
            }

            @Override
            public boolean volumetric() {
                return false;
            }
        });
    }

    @Override
    public void useDown(Game game, Physics.CustomClosestRayResultCallback c) {
        if (this.reloadTime <= 0) {
            this.use(game, c);
            this.reloadTime = 6;
        }
    }

    @Override
    public void update() {
        --this.reloadTime;
    }

    @Override
    public void renderInHand(MeshBatch mb, boolean leftHand) {
        if (this.reloadTime >= 4 && this.ammo > 0) {
            float angle = !leftHand ? -0.25f : 0.2f;
            Vec3 l = new Vec3(0.0, 0.0, 0.0);
            float a = 0.1f;
            float b = 4.0f;
            l.x = Math.cos(-this.game.player.headingUpDownRad / (double)b + (double)a) * Math.sin(this.game.player.headingRad + (double)angle);
            l.y = Math.sin(-this.game.player.headingUpDownRad / (double)b + (double)a);
            l.z = Math.cos(-this.game.player.headingUpDownRad / (double)b + (double)a) * Math.cos(this.game.player.headingRad + (double)angle);
            l.normalize();
            l.normalize();
            l.multiply(2.5);
            float x = (float)(this.game.player.pos.x - l.x);
            float y = (float)(this.game.player.pos.y - l.y);
            float z = (float)(this.game.player.pos.z - l.z);
            Matrix4f.Pipeline p = new Matrix4f.Pipeline();
            p.add(Matrix4f.rotate((float)(Math.random() * 360.0), 0.0f, 0.0f, 1.0f));
            p.add(Matrix4f.rotate((float)Math.toDegrees(this.game.player.headingRad), 0.0f, 1.0f, 0.0f));
            float scale = 0.4f + (float)Math.random() * 0.2f;
            p.add(Matrix4f.scale(scale, scale, scale));
            p.addTranslate(x, y, z);
            mb.addTransparent(ResourceHandler.quad, ResourceHandler.muzzleFlash, p.getMatrix(), mb.nextVector3f(1.0f, 1.0f, 1.0f), true, 0.5f, 1.0, new Vec3(x, y, z));
        }
        if (leftHand) {
            mb.addString("AK47 AMMO " + this.ammo, mb.nextVector3f(20.0f, Window.height - 80, 0.0f), mb.nextVector3f(1.0f, 1.0f, 0.3f), ResourceHandler.ui);
        } else {
            mb.addString("AK47 AMMO " + this.ammo, mb.nextVector3f(Window.width - 265, Window.height - 80, 0.0f), mb.nextVector3f(1.0f, 1.0f, 0.3f), ResourceHandler.ui);
        }
    }
}

