/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.AllianshallenFloor;
import entities.AllianshallenKiosk;
import entities.Chair;
import entities.Computer;
import entities.Entity;
import entities.Grandstand;
import entities.GrandstandMetal;
import entities.Monitor;
import entities.Scene;
import entities.Screen;
import entities.Speaker;
import entities.Table;
import game.Game;
import javax.vecmath.Vector3f;
import physics.Physics;
import renderer.ResourceHandler;

public class Allianshallen
extends Entity {
    public Allianshallen(Physics physics, Vector3f pos, Vector3f rot, Game game) {
        super(physics, pos, rot, ResourceHandler.allianshallenInnerWall, ResourceHandler.allianshallenInnerWall, false, ResourceHandler.allianshallenInnerWallTexture, 0.0, 1.0f);
        float x;
        game.entities.add(new AllianshallenFloor(physics, pos, rot, game));
        game.entities.add(new Entity(physics, pos, rot, ResourceHandler.allianshallenYellowWalls, ResourceHandler.allianshallenYellowWalls, false, ResourceHandler.allianshallenYellowWallTexture, 0.0, 1.0f));
        game.entities.add(new Entity(physics, pos, rot, ResourceHandler.allianshallenCeiling, ResourceHandler.allianshallenCeiling, false, ResourceHandler.allianshallenCeilingTexture, 0.0, 1.0f));
        game.entities.add(new AllianshallenKiosk(physics, pos, rot, game));
        float cx = pos.x;
        float cz = pos.z;
        game.entities.add(new Grandstand(physics, new Vector3f(cx + 7.0f, 0.4f, cz - 13.0f), new Vector3f(0.0f, (float)Math.toRadians(-90.0), 0.0f)));
        game.entities.add(new GrandstandMetal(physics, new Vector3f(cx + 7.0f, 0.4f, cz - 13.0f), new Vector3f(0.0f, (float)Math.toRadians(-90.0), 0.0f)));
        game.entities.add(new Grandstand(physics, new Vector3f(cx - 15.0f, 0.4f, cz - 13.0f), new Vector3f(0.0f, (float)Math.toRadians(-90.0), 0.0f)));
        game.entities.add(new GrandstandMetal(physics, new Vector3f(cx - 15.0f, 0.4f, cz - 13.0f), new Vector3f(0.0f, (float)Math.toRadians(-90.0), 0.0f)));
        game.entities.add(new Scene(physics, new Vector3f(cx - 3.5f, 0.4f, cz + 17.0f), new Vector3f(0.0f, (float)Math.toRadians(-90.0), 0.0f)));
        game.entities.add(new Screen(physics, new Vector3f(cx - 3.5f, 0.4f, cz + 19.0f), new Vector3f(0.0f, (float)Math.toRadians(-90.0), 0.0f)));
        int i = 0;
        while (i < 4) {
            float h = 1.15f;
            float y = -0.55f;
            game.entities.add(new Speaker(physics, new Vector3f(cx - 7.0f, y + (float)i * h, cz + 17.0f), new Vector3f(0.0f, (float)Math.toRadians(90.0), 0.0f)));
            game.entities.add(new Speaker(physics, new Vector3f(cx - 8.0f, y + (float)i * h, cz + 17.0f), new Vector3f(0.0f, (float)Math.toRadians(90.0), 0.0f)));
            game.entities.add(new Speaker(physics, new Vector3f(cx + 0.0f, y + (float)i * h, cz + 17.0f), new Vector3f(0.0f, (float)Math.toRadians(90.0), 0.0f)));
            game.entities.add(new Speaker(physics, new Vector3f(cx + 1.0f, y + (float)i * h, cz + 17.0f), new Vector3f(0.0f, (float)Math.toRadians(90.0), 0.0f)));
            ++i;
        }
        float rw = 3.9f;
        float td = 2.3f;
        float z = cz - 17.5f;
        while (z < cz + 0.0f) {
            x = cx + 25.0f;
            while (x < cx + 48.0f) {
                this.add(game, x, z, false);
                x += td;
            }
            z += rw;
        }
        z = cz - 15.0f;
        while (z < cz + 0.0f) {
            x = cx - 47.0f;
            while (x < cx - 30.0f) {
                this.add(game, x, z, false);
                x += td;
            }
            z += rw;
        }
        float x2 = cx - 23.0f;
        while (x2 < cx + 17.0f) {
            float z2 = cz - 7.0f;
            while (z2 < cz + (float)(Math.abs(cx - x2 - 5.0f) < 10.0f ? 10 : 13)) {
                if (Math.abs(cx - x2 - 5.0f) > 2.0f) {
                    this.add(game, x2, z2, true);
                }
                z2 += td;
            }
            x2 += rw;
        }
    }

    private void add(Game game, float x, float z, boolean b) {
        float r = b ? 90 : 0;
        int i = 0;
        while (i < 2) {
            float xx = (float)i * 0.8f;
            float zz = 0.0f;
            game.entities.add(new Table(this.physics, new Vector3f(x + (b ? xx : zz), 0.3f, z + (b ? zz : xx)), new Vector3f(0.0f, (float)Math.toRadians(r), 0.0f)));
            float w = 1.0f;
            float dx = 0.0f;
            while (dx <= w) {
                xx = (float)i * 0.8f;
                zz = dx - 0.9f;
                game.entities.add(new Computer(this.physics, new Vector3f(x + (b ? xx : zz), 0.55f, z + (b ? zz : xx)), new Vector3f(0.0f, (float)Math.toRadians((float)(90 + i * 180) + r), 0.0f)));
                xx = 0.1f + (b ? 0.1f : 0.0f) + (float)i * 0.6f;
                zz = dx - 0.4f;
                game.entities.add(new Monitor(this.physics, new Vector3f(x + (b ? xx : zz), -0.05f, z + (b ? zz : xx)), new Vector3f(0.0f, (float)Math.toRadians((float)(90 + i * 180) + r), 0.0f)));
                xx = -0.7f + (float)i * 2.2f;
                zz = dx - 0.5f;
                game.entities.add(new Chair(this.physics, new Vector3f(x + (b ? xx : zz), 0.3f, z + (b ? zz : xx)), new Vector3f(0.0f, (float)Math.toRadians((float)(i * 180) + r), 0.0f)));
                dx += w;
            }
            ++i;
        }
    }
}

