/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.Chair;
import entities.Computer;
import entities.Entity;
import entities.Keyboard;
import entities.Monitor;
import entities.Table;
import game.Game;
import javax.vecmath.Vector3f;
import physics.Physics;
import renderer.ResourceHandler;

public class Hall
extends Entity {
    private static float scale = 10.0f;

    public Hall(Physics physics, Vector3f pos, Vector3f rot, Game game) {
        super(physics, pos, rot, ResourceHandler.hall, ResourceHandler.hall, false, ResourceHandler.hallTexture, 0.0, scale);
        float w = 4.0f * scale;
        float h = 2.0f * scale;
        int z = (int)((double)pos.z - (double)w * 0.5 + 2.0);
        while (z < (int)((double)pos.z + (double)w * 0.5 - 2.0)) {
            float x = pos.x - h * 0.5f + 2.0f;
            while (x < pos.x + h * 0.5f - 2.0f) {
                game.entities.add(new Table(physics, new Vector3f(x, 0.2f, (float)z), new Vector3f(0.0f, 0.0f, 0.0f)));
                float dx = 0.0f;
                while (dx <= 1.5f) {
                    game.entities.add(new Computer(physics, new Vector3f(x + dx - 1.3f, 1.0f, (float)z), new Vector3f(0.0f, (float)Math.toRadians(-90.0), 0.0f)));
                    game.entities.add(new Keyboard(physics, new Vector3f(x + dx - 0.55f, 1.1f, (float)z + 0.3f), new Vector3f(0.0f, (float)Math.toRadians(-90.0), 0.0f)));
                    game.entities.add(new Monitor(physics, new Vector3f(x + dx - 0.4f, 0.3f, (float)z - 0.3f), new Vector3f(0.0f, (float)Math.toRadians(-90.0), 0.0f)));
                    game.entities.add(new Chair(physics, new Vector3f(x + dx - 0.5f, 0.3f, (float)z + 1.2f), new Vector3f(0.0f, (float)Math.toRadians(180.0), 0.0f)));
                    dx += 1.5f;
                }
                x += 3.3f;
            }
            z += 6;
        }
    }
}

