/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Enemy;
import game.Model;
import game.Vec3;
import renderer.ResourceHandler;
import renderer.glengine.Matrix4f;
import renderer.glengine.MeshBatch;

public class DroidModel
extends Model {
    public DroidModel(Enemy e) {
        super(e);
        this.bodyTopWidth = 0.5f;
        this.bodyBotWidth = 0.2f;
        this.bodyHeight = 0.7f;
        this.armUpperLength = 0.3f;
        this.armLowerLength = 0.3f;
        this.handLength = 0.2f;
        this.headLength = 0.4f;
        this.legUpperLength = 0.35f;
        this.legLowerLength = 0.35f;
        this.feetLength = 0.3f;
    }

    @Override
    public void renderHead(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim) {
        if (!this.enemy.isHeadShotted) {
            Matrix4f mc = Matrix4f.scale(-1.0f, -1.0f, -1.0f);
            mc.set(m);
            Matrix4f f = mc.multiply(Matrix4f.translate((float)pos.x, (float)pos.y, (float)pos.z));
            mb.add(ResourceHandler.zombieHead, ResourceHandler.zombieHeadTexture, f);
        }
    }

    @Override
    public void renderArm(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim) {
        Matrix4f mc = Matrix4f.scale(-1.0f, -1.0f, -1.0f);
        mc.set(m);
        Matrix4f f = mc.multiply(Matrix4f.translate((float)pos.x, (float)pos.y, (float)pos.z).multiply(Matrix4f.scale((float)dim.x, (float)dim.y, (float)dim.z)));
        mb.add(ResourceHandler.zombieArm, ResourceHandler.zombieHeadTexture, f);
    }

    @Override
    public void renderLeg(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim) {
        Matrix4f mc = Matrix4f.scale(-1.0f, -1.0f, -1.0f);
        mc.set(m);
        Matrix4f f = mc.multiply(Matrix4f.translate((float)pos.x, (float)pos.y, (float)pos.z).multiply(Matrix4f.scale((float)dim.x, (float)dim.y, (float)dim.z)));
        mb.add(ResourceHandler.zombieLeg, ResourceHandler.zombieHeadTexture, f);
    }

    @Override
    public void renderBody(MeshBatch mb, Matrix4f m) {
        Matrix4f mc = Matrix4f.scale(1.0f, 1.0f, 1.0f);
        mc.set(m);
        mb.add(ResourceHandler.zombieBody, ResourceHandler.zombieHeadTexture, mc);
    }

    @Override
    public void renderHand(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim, boolean left) {
        Matrix4f mc = Matrix4f.scale(-1.0f, -1.0f, -1.0f);
        mc.set(m);
        Matrix4f f = mc.multiply(Matrix4f.translate((float)pos.x, (float)pos.y, (float)pos.z).multiply(Matrix4f.scale((float)dim.x, (float)dim.y, (float)dim.z)));
        mb.add(left ? ResourceHandler.zombieHand : ResourceHandler.zombieHandFlip, ResourceHandler.zombieHeadTexture, f);
    }

    @Override
    public void renderFoot(MeshBatch mb, Matrix4f m, Vec3 pos, Vec3 dim, boolean left) {
        Matrix4f mc = Matrix4f.scale(-1.0f, -1.0f, -1.0f);
        mc.set(m);
        Matrix4f f = mc.multiply(Matrix4f.translate((float)pos.x, (float)pos.y, (float)pos.z).multiply(Matrix4f.scale((float)dim.x, (float)dim.y, (float)dim.z)));
        mb.add(ResourceHandler.zombieFoot, ResourceHandler.zombieHeadTexture, f);
    }
}

