/*
 * Decompiled with CFR 0.152.
 */
package lights;

import game.Game;
import game.Player;
import game.Vec3;
import lights.Light;

public class PlayerLight
extends Light {
    private Vec3 color;
    private float strength;
    private Player player;

    public PlayerLight(Vec3 color, float strength, Player player) {
        this.strength = strength;
        this.color = color;
        this.player = player;
    }

    @Override
    public Vec3 getColor() {
        return this.color;
    }

    @Override
    public Vec3 getPosition() {
        double r = -0.9f;
        double a = -0.5;
        this.strength = 5.0f;
        Vec3 l = new Vec3(0.0, 0.0, 0.0);
        l.x = Math.cos(-this.player.headingUpDownRad) * Math.sin(this.player.headingRad - (double)0.1f);
        l.y = Math.sin(-this.player.headingUpDownRad);
        l.z = Math.cos(-this.player.headingUpDownRad) * Math.cos(this.player.headingRad - (double)0.1f);
        l.normalize();
        return new Vec3(this.player.pos.x - r * l.x, this.player.pos.y - r * l.y, this.player.pos.z - r * l.z);
    }

    @Override
    public float getLightDirPow() {
        return 10.0f;
    }

    @Override
    public float getStrength() {
        return this.strength;
    }

    @Override
    public boolean shallBeRemoved(Game game) {
        return false;
    }

    @Override
    public boolean volumetric() {
        return false;
    }

    @Override
    public Vec3 getDir() {
        Vec3 l = new Vec3(0.0, 0.0, 0.0);
        l.x = Math.cos(-this.player.headingUpDownRad) * Math.sin(this.player.headingRad - (double)0.1f);
        l.y = Math.sin(-this.player.headingUpDownRad);
        l.z = Math.cos(-this.player.headingUpDownRad) * Math.cos(this.player.headingRad - (double)0.1f);
        l.normalize();
        return new Vec3(l.x, l.y, l.z);
    }
}

