/*
 * Decompiled with CFR 0.152.
 */
package physics;

import com.bulletphysics.BulletStats;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.BvhTriangleMeshShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.StridingMeshInterface;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.InternalTickCallback;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.util.ObjectArrayList;
import entities.Entity;
import javax.vecmath.Vector3f;
import org.lwjgl.assimp.AIMesh;
import physics.TriangleMesh;

public class Physics {
    private ObjectArrayList<CollisionShape> collisionShapes = new ObjectArrayList();
    private BroadphaseInterface broadphase;
    private CollisionDispatcher dispatcher;
    private ConstraintSolver solver;
    private DefaultCollisionConfiguration collisionConfiguration;
    private static final float STEPSIZE = 5.0f;
    public static int numObjects = 0;
    public static final int maxNumObjects = 16384;
    public static Transform[] startTransforms = new Transform[16384];
    public static CollisionShape[] gShapePtr = new CollisionShape[16384];
    public static RigidBody pickedBody = null;
    protected DynamicsWorld dynamicsWorld = null;
    protected TypedConstraint pickConstraint = null;

    static {
        int i = 0;
        while (i < startTransforms.length) {
            Physics.startTransforms[i] = new Transform();
            ++i;
        }
    }

    public Physics() {
        this.init();
    }

    private void init() {
        this.collisionConfiguration = new DefaultCollisionConfiguration();
        this.dispatcher = new CollisionDispatcher((CollisionConfiguration)this.collisionConfiguration);
        this.broadphase = new DbvtBroadphase();
        SequentialImpulseConstraintSolver sol = new SequentialImpulseConstraintSolver();
        this.solver = sol;
        this.dynamicsWorld = new DiscreteDynamicsWorld((Dispatcher)this.dispatcher, this.broadphase, this.solver, (CollisionConfiguration)this.collisionConfiguration);
        this.dynamicsWorld.setGravity(new Vector3f(0.0f, -10.0f, 0.0f));
        this.dynamicsWorld.setInternalTickCallback(new InternalTickCallback(){

            public void internalTick(DynamicsWorld dynamicsWorld, float timeStep) {
                Dispatcher dispatcher = dynamicsWorld.getDispatcher();
                int manifoldCount = dispatcher.getNumManifolds();
                int i = 0;
                while (i < manifoldCount) {
                    PersistentManifold manifold = dispatcher.getManifoldByIndexInternal(i);
                    RigidBody object1 = (RigidBody)manifold.getBody0();
                    RigidBody object2 = (RigidBody)manifold.getBody1();
                    Entity entity1 = (Entity)object1.getUserPointer();
                    Entity entity2 = (Entity)object2.getUserPointer();
                    boolean hit = false;
                    Vector3f normal = null;
                    int j = 0;
                    while (j < manifold.getNumContacts()) {
                        ManifoldPoint contactPoint = manifold.getContactPoint(j);
                        if (contactPoint.getDistance() < 0.0f) {
                            hit = true;
                            normal = contactPoint.normalWorldOnB;
                            break;
                        }
                        ++j;
                    }
                    if (hit && entity1 != null && entity2 != null) {
                        entity1.collidedWith(entity2);
                        entity2.collidedWith(entity1);
                    }
                    ++i;
                }
            }
        }, null);
        this.clientResetScene();
    }

    public synchronized void clientResetScene() {
        BulletStats.gNumDeepPenetrationChecks = 0;
        BulletStats.gNumGjkChecks = 0;
        int numObjects = 0;
        if (this.dynamicsWorld != null) {
            this.dynamicsWorld.stepSimulation(0.016666668f, 0);
            numObjects = this.dynamicsWorld.getNumCollisionObjects();
        }
        int i = 0;
        while (i < numObjects) {
            CollisionObject colObj = (CollisionObject)this.dynamicsWorld.getCollisionObjectArray().getQuick(i);
            RigidBody body = RigidBody.upcast((CollisionObject)colObj);
            if (body != null) {
                if (body.getMotionState() != null) {
                    DefaultMotionState myMotionState = (DefaultMotionState)body.getMotionState();
                    myMotionState.graphicsWorldTrans.set(myMotionState.startWorldTrans);
                    colObj.setWorldTransform(myMotionState.graphicsWorldTrans);
                    colObj.setInterpolationWorldTransform(myMotionState.startWorldTrans);
                    colObj.activate();
                }
                this.dynamicsWorld.getBroadphase().getOverlappingPairCache().cleanProxyFromPairs(colObj.getBroadphaseHandle(), this.dynamicsWorld.getDispatcher());
                body = RigidBody.upcast((CollisionObject)colObj);
                if (body != null && !body.isStaticObject()) {
                    RigidBody.upcast((CollisionObject)colObj).setLinearVelocity(new Vector3f(0.0f, 0.0f, 0.0f));
                    RigidBody.upcast((CollisionObject)colObj).setAngularVelocity(new Vector3f(0.0f, 0.0f, 0.0f));
                }
            }
            ++i;
        }
    }

    public synchronized void update() {
        if (this.dynamicsWorld != null) {
            long t0 = System.currentTimeMillis();
            this.dynamicsWorld.stepSimulation(0.016666668f);
        }
    }

    public synchronized CustomClosestRayResultCallback rayTest(Vector3f from, Vector3f towards) {
        CustomClosestRayResultCallback c = new CustomClosestRayResultCallback(from, towards);
        this.dynamicsWorld.rayTest(from, towards, (CollisionWorld.RayResultCallback)c);
        return c;
    }

    public synchronized RigidBody createStaticBox(Vector3f size, Vector3f position) {
        return this.createBox(size, position, 0.0f);
    }

    public synchronized RigidBody createBox(Vector3f size, Vector3f position, float mass) {
        return this.createBox(size, position, mass, new Vector3f());
    }

    public synchronized RigidBody createBox(Vector3f size, Vector3f position, float mass, Vector3f rot) {
        BoxShape shape = new BoxShape(size);
        this.collisionShapes.add((Object)shape);
        Transform transform = new Transform();
        transform.setIdentity();
        transform.origin.set(position.x, position.y, position.z);
        transform.basis.rotY(rot.y);
        return this.localCreateRigidBody(mass, transform, (CollisionShape)shape);
    }

    public synchronized RigidBody createBodyFromMesh(AIMesh mesh, Vector3f position, float mass) {
        return this.createBodyFromMesh(mesh, position, mass, new Vector3f(), 1.0f);
    }

    public synchronized RigidBody createBodyFromMesh(AIMesh mesh, Vector3f position, float mass, Vector3f rot, float scale) {
        TriangleMesh triangleMesh = new TriangleMesh(mesh, scale);
        BvhTriangleMeshShape shape = new BvhTriangleMeshShape((StridingMeshInterface)triangleMesh, true);
        Transform transform = new Transform();
        transform.setIdentity();
        transform.origin.set(position.x, position.y, position.z);
        transform.basis.rotY(rot.y);
        return this.localCreateRigidBody(mass, transform, (CollisionShape)shape);
    }

    public synchronized void remove(RigidBody body) {
        this.dynamicsWorld.removeRigidBody(body);
    }

    public synchronized void add(RigidBody body) {
        this.dynamicsWorld.addRigidBody(body);
    }

    public synchronized RigidBody localCreateRigidBody(float mass, Transform startTransform, CollisionShape shape) {
        boolean isDynamic = mass != 0.0f;
        Vector3f localInertia = new Vector3f(0.0f, 0.0f, 0.0f);
        if (isDynamic) {
            shape.calculateLocalInertia(mass, localInertia);
        }
        DefaultMotionState myMotionState = new DefaultMotionState(startTransform);
        RigidBodyConstructionInfo cInfo = new RigidBodyConstructionInfo(mass, (MotionState)myMotionState, shape, localInertia);
        RigidBody body = new RigidBody(cInfo);
        this.dynamicsWorld.addRigidBody(body);
        return body;
    }

    public synchronized ObjectArrayList<CollisionShape> getCollisionShapes() {
        return this.collisionShapes;
    }

    public synchronized DynamicsWorld getDynamicsWorld() {
        return this.dynamicsWorld;
    }

    public class CustomClosestRayResultCallback
    extends CollisionWorld.ClosestRayResultCallback {
        public Vector3f pos;
        public Entity e;
        public double hitFraction;
        public int num;

        public CustomClosestRayResultCallback(Vector3f rayFromWorld, Vector3f rayToWorld) {
            super(rayFromWorld, rayToWorld);
            this.pos = null;
            this.e = null;
            this.hitFraction = Double.MAX_VALUE;
            this.num = 0;
        }

        public float addSingleResult(CollisionWorld.LocalRayResult lrr, boolean arg1) {
            Entity e;
            Transform trans = new Transform();
            lrr.collisionObject.getWorldTransform(trans);
            double hf = lrr.hitFraction;
            double rhf = 1.0 - hf;
            ++this.num;
            if ((double)lrr.hitFraction < this.hitFraction && ((e = (Entity)lrr.collisionObject.getUserPointer()) == null || !e.isPlayer())) {
                this.hitFraction = lrr.hitFraction;
                this.e = e;
                this.pos = new Vector3f();
                this.pos.x = (float)((double)this.rayFromWorld.x * rhf + (double)this.rayToWorld.x * hf);
                this.pos.y = (float)((double)this.rayFromWorld.y * rhf + (double)this.rayToWorld.y * hf);
                this.pos.z = (float)((double)this.rayFromWorld.z * rhf + (double)this.rayToWorld.z * hf);
            }
            return 0.0f;
        }
    }
}

