/*
 * Decompiled with CFR 0.152.
 */
package renderer.glengine;

import entities.Jolt;
import game.Game;
import game.Player;
import game.Vec3;
import input.MouseHandler;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import lights.Light;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIMesh;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import renderer.ResourceHandler;
import renderer.TextureFont;
import renderer.glengine.CubeFBO;
import renderer.glengine.FBO;
import renderer.glengine.FBOMRT;
import renderer.glengine.GLSLProgram;
import renderer.glengine.Matrix4f;
import renderer.glengine.MeshBatchBase;
import renderer.glengine.Model;
import renderer.glengine.Sprite;
import renderer.glengine.Texture;
import renderer.glengine.Vector3f;
import renderer.glengine.Window;

public class MeshBatch
extends MeshBatchBase {
    private GLSLProgram modelShader;
    private GLSLProgram terrainShader;
    private GLSLProgram waterShader;
    private GLSLProgram spriteShader;
    private GLSLProgram shadowShader;
    private GLSLProgram pointShadowShader;
    private GLSLProgram buildSpriteShader;
    private GLSLProgram skyBoxShader;
    private GLSLProgram instancedShader;
    private GLSLProgram deferredGeometryShader;
    private GLSLProgram deferredLightningShader;
    private GLSLProgram postShader;
    private GLSLProgram screenShader;
    private long startTime;
    private FBO shadowMap = new FBO(2048, 2048);
    private FBOMRT gFBO;
    private FBO outFBO;
    private CubeFBO cubeShadowMap = new CubeFBO(512, 512);
    private FloatBuffer pvBuffer = BufferUtils.createFloatBuffer((int)16);
    private FloatBuffer mBuffer = BufferUtils.createFloatBuffer((int)16);
    private Model terrainModel;
    private Model skyBoxModel;
    private Matrix4f[] shadowTransforms = new Matrix4f[6];
    float far = 100.0f;
    private Vector3f lightPos = (Vector3f)Vector3f.POOL.next();
    public static float fov = 59.0f;
    float prevFov = 59.0f;
    Model screenModel;
    int quadVaoId;
    int quadVboId;
    int quadVertexCount;

    public MeshBatch(int width, int height) {
        this.gFBO = new FBOMRT(width, height);
        this.outFBO = new FBO(width, height, true);
    }

    @Override
    public void init() {
        this.setupQuad();
        this.reloadShaders();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void begin() {
        this.renderList.clear();
        this.transparentList.clear();
        this.spriteList.clear();
    }

    @Override
    public void end(Game game, Window window, final Player player) {
        GL11.glClear((int)16640);
        float shadowSizeIncrease = 2.0f;
        float s = 50.0f;
        Matrix4f PV = Matrix4f.orthographic(-s, s, -s, s, -100.0f, 100.0f);
        PV = PV.multiply(Matrix4f.rotate(60.0f, 1.0f, 0.0f, 0.0f));
        PV = PV.multiply(Matrix4f.rotate(45.0f, 0.0f, 1.0f, 0.0f));
        PV = PV.multiply(Matrix4f.translate(-((float)player.pos.x), 0.0f, -((float)player.pos.z)));
        long t0 = System.currentTimeMillis();
        this.renderPointShadowMap(game, player);
        this.renderMeshes(game, Matrix4f.bias().multiply(PV), player);
        Collections.sort(this.transparentList, new Comparator<Model>(){

            @Override
            public int compare(Model a, Model b) {
                double d2;
                double d1 = a.pos.lengthDifference(player.pos);
                if (d1 > (d2 = b.pos.lengthDifference(player.pos))) {
                    return -1;
                }
                if (d1 < d2) {
                    return 1;
                }
                return 0;
            }
        });
        GL30.glBindFramebuffer((int)36008, (int)this.gFBO.gBuffer);
        GL30.glBindFramebuffer((int)36009, (int)0);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)Window.width, (int)Window.height, (int)0, (int)0, (int)Window.width, (int)Window.height, (int)256, (int)9728);
        GL30.glBindFramebuffer((int)36160, (int)0);
        this.renderTransparent(game, 0, this.transparentList.size() - 1, player);
        this.renderSprites();
        Matrix4f.POOL.reset();
        Model.POOL.reset();
        Vector3f.POOL.reset();
        Sprite.POOL.reset();
    }

    public Matrix4f nextMatrix4f(Matrix4f matrix4f) {
        return Matrix4f.POOL.next(matrix4f);
    }

    public Model nextModel() {
        return Model.POOL.next();
    }

    public Vector3f nextVector3f() {
        return (Vector3f)Vector3f.POOL.next();
    }

    public Vector3f nextVector3f(float x, float y, float z) {
        return Vector3f.POOL.next(x, y, z);
    }

    public Sprite nextSprite() {
        return Sprite.POOL.next();
    }

    private void setupShadowTransforms(Player player) {
        double r = 1.0;
        Vec3 l = new Vec3(0.0, 0.0, 0.0);
        l.x = Math.cos(-player.headingUpDownRad) * Math.sin(player.headingRad - (double)0.1f);
        l.y = Math.sin(-player.headingUpDownRad);
        l.z = Math.cos(player.headingUpDownRad) * Math.cos(player.headingRad - (double)0.1f);
        l.normalize();
        this.lightPos = Vector3f.POOL.next((float)(player.pos.x - r * l.x), (float)(player.pos.y - r * l.y), (float)(player.pos.z - r * l.z));
        this.shadowTransforms[0] = Matrix4f.lookAt(this.lightPos, this.lightPos.add(Vector3f.POOL.next(1.0f, 0.0f, 0.0f)), Vector3f.POOL.next(0.0f, -1.0f, 0.0f));
        this.shadowTransforms[1] = Matrix4f.lookAt(this.lightPos, this.lightPos.add(Vector3f.POOL.next(-1.0f, 0.0f, 0.0f)), Vector3f.POOL.next(0.0f, -1.0f, 0.0f));
        this.shadowTransforms[2] = Matrix4f.lookAt(this.lightPos, this.lightPos.add(Vector3f.POOL.next(0.0f, 1.0f, 0.0f)), Vector3f.POOL.next(0.0f, 0.0f, 1.0f));
        this.shadowTransforms[3] = Matrix4f.lookAt(this.lightPos, this.lightPos.add(Vector3f.POOL.next(0.0f, -1.0f, 0.0f)), Vector3f.POOL.next(0.0f, 0.0f, -1.0f));
        Matrix4f.Pipeline p = new Matrix4f.Pipeline();
        p.addTranslate(-this.lightPos.x, -this.lightPos.y, -this.lightPos.z);
        p.addRotate(90.0f, 1.0f, 0.0f, 0.0f);
        this.shadowTransforms[3] = p.getMatrix();
        this.shadowTransforms[4] = Matrix4f.lookAt(this.lightPos, this.lightPos.add(Vector3f.POOL.next(0.0f, 0.0f, 1.0f)), Vector3f.POOL.next(0.0f, -1.0f, 0.0f));
        this.shadowTransforms[5] = Matrix4f.lookAt(this.lightPos, this.lightPos.add(Vector3f.POOL.next(0.0f, 0.0f, -1.0f)), Vector3f.POOL.next(0.0f, -1.0f, 0.0f));
    }

    private void renderPointShadowMap(Game game, Player player) {
        this.setupShadowTransforms(player);
        GL30.glBindFramebuffer((int)36009, (int)this.cubeShadowMap.fbo);
        GL11.glViewport((int)0, (int)0, (int)this.cubeShadowMap.width, (int)this.cubeShadowMap.height);
        GL11.glClear((int)256);
        GL20.glUseProgram((int)this.pointShadowShader.programID);
        Matrix4f P = Matrix4f.perspective(90.0f, (float)this.cubeShadowMap.width / (float)this.cubeShadowMap.height, 0.01f, this.far);
        P.setBuffer(this.mBuffer);
        int i = 0;
        while (i < 6) {
            Matrix4f PV = P.multiply(this.shadowTransforms[i]);
            PV.setBuffer(this.mBuffer);
            GL20.glUniformMatrix4fv((int)GL20.glGetUniformLocation((int)this.pointShadowShader.programID, (CharSequence)("shadowTransforms[" + i + "]")), (boolean)false, (FloatBuffer)this.mBuffer);
            ++i;
        }
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)this.pointShadowShader.programID, (CharSequence)"far_plane"), (float)this.far);
        GL20.glUniform3f((int)GL20.glGetUniformLocation((int)this.pointShadowShader.programID, (CharSequence)"lightPos"), (float)this.lightPos.x, (float)this.lightPos.y, (float)this.lightPos.z);
        int mLoc = GL20.glGetUniformLocation((int)this.pointShadowShader.programID, (CharSequence)"model");
        int i2 = 0;
        while (i2 < this.renderList.size()) {
            Model model = (Model)this.renderList.get(i2);
            if (model.giveShadow) {
                Matrix4f M = model.modelMatrix;
                M.setBuffer(this.mBuffer);
                GL20.glUniformMatrix4fv((int)mLoc, (boolean)false, (FloatBuffer)this.mBuffer);
                MeshBatchBase.VAO vao = (MeshBatchBase.VAO)this.vaoMap.get(model.mesh);
                GL30.glBindVertexArray((int)vao.VAO);
                GL11.glDrawElements((int)4, (int)(model.mesh.mNumFaces() * 3), (int)5125, (long)0L);
            }
            ++i2;
        }
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL11.glViewport((int)0, (int)0, (int)Window.width, (int)Window.height);
    }

    private void renderShadowMap(Game game, Matrix4f PV) {
        GL30.glBindFramebuffer((int)36160, (int)this.shadowMap.fbo);
        GL11.glViewport((int)0, (int)0, (int)this.shadowMap.width, (int)this.shadowMap.height);
        GL11.glClear((int)16640);
        GL20.glUseProgram((int)this.shadowShader.programID);
        int m = GL20.glGetUniformLocation((int)this.shadowShader.programID, (CharSequence)"depthMVP");
        int i = 0;
        while (i < this.renderList.size()) {
            Model model = (Model)this.renderList.get(i);
            if (model.giveShadow) {
                Matrix4f depthModelMatrix = model.modelMatrix;
                Matrix4f depthMVP = PV.multiply(depthModelMatrix);
                depthMVP.setBuffer(this.mBuffer);
                GL20.glUniformMatrix4fv((int)m, (boolean)false, (FloatBuffer)this.mBuffer);
                MeshBatchBase.VAO vao = (MeshBatchBase.VAO)this.vaoMap.get(model.mesh);
                GL30.glBindVertexArray((int)vao.VAO);
                GL11.glDrawElements((int)4, (int)(model.mesh.mNumFaces() * 3), (int)5125, (long)0L);
            }
            ++i;
        }
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL11.glViewport((int)0, (int)0, (int)Window.width, (int)Window.height);
    }

    public Matrix4f getPV(Player player) {
        float newFov;
        fov = player.joltTimer > 0 && player.joltTimer < Jolt.DURATION - 60 ? 70 : 59;
        this.prevFov = newFov = this.prevFov + 0.05f * (fov - this.prevFov);
        Matrix4f PV = Matrix4f.perspective(newFov, (float)Window.width / (float)Window.height, 0.001f, 5000.0f);
        PV = PV.multiply(Matrix4f.rotate((float)(-Math.toDegrees(player.headingUpDownRad)), 1.0f, 0.0f, 0.0f));
        PV = PV.multiply(Matrix4f.rotate((float)(-Math.toDegrees(player.headingRad)), 0.0f, 1.0f, 0.0f));
        PV = PV.multiply(Matrix4f.translate(-((float)player.pos.x), -((float)player.pos.y), -((float)player.pos.z)));
        return PV;
    }

    @Override
    public void free() {
        super.free();
        this.modelShader.free();
        this.spriteShader.free();
    }

    public void renderMeshes(Game game, Matrix4f depthBiasMVP, Player player) {
        Vec3 dir;
        Vec3 p;
        Model model;
        int pvLoc = GL20.glGetUniformLocation((int)this.deferredGeometryShader.programID, (CharSequence)"PV");
        int mLoc = GL20.glGetUniformLocation((int)this.deferredGeometryShader.programID, (CharSequence)"M");
        int texLoc = GL20.glGetUniformLocation((int)this.deferredGeometryShader.programID, (CharSequence)"modelTexture");
        int normalLoc = GL20.glGetUniformLocation((int)this.deferredGeometryShader.programID, (CharSequence)"normalTexture");
        int specularLoc = GL20.glGetUniformLocation((int)this.deferredGeometryShader.programID, (CharSequence)"specularTexture");
        int stencilLoc = GL20.glGetUniformLocation((int)this.deferredGeometryShader.programID, (CharSequence)"stencil");
        GL30.glBindFramebuffer((int)36160, (int)this.gFBO.gBuffer);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)1029);
        GL11.glViewport((int)0, (int)0, (int)this.gFBO.width, (int)this.gFBO.height);
        GL11.glClear((int)16640);
        GL20.glUseProgram((int)this.deferredGeometryShader.programID);
        Matrix4f PV = this.getPV(player);
        PV.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)pvLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        Vec3 l = new Vec3(0.0, 0.0, 0.0);
        l.x = Math.cos(-player.headingUpDownRad) * Math.sin(player.headingRad);
        l.y = Math.sin(-player.headingUpDownRad);
        l.z = Math.cos(-player.headingUpDownRad) * Math.cos(player.headingRad);
        l.normalize();
        int i = 0;
        while (i < this.renderList.size()) {
            model = (Model)this.renderList.get(i);
            p = new Vec3(model.modelMatrix.m03, model.modelMatrix.m13, model.modelMatrix.m23);
            dir = player.pos.subtract(p);
            dir.normalize();
            if (!(p.lengthDifference(player.pos) > 150.0)) {
                GL20.glUniform1i((int)normalLoc, (int)1);
                GL13.glActiveTexture((int)33985);
                GL11.glBindTexture((int)3553, (int)model.normalTexture.textureID);
                GL20.glUniform1i((int)specularLoc, (int)2);
                GL13.glActiveTexture((int)33986);
                GL11.glBindTexture((int)3553, (int)model.specularTexture.textureID);
                GL20.glUniform1i((int)texLoc, (int)0);
                GL13.glActiveTexture((int)33984);
                GL11.glBindTexture((int)3553, (int)model.texture.textureID);
                model.modelMatrix.setBuffer(this.mBuffer);
                GL20.glUniformMatrix4fv((int)mLoc, (boolean)false, (FloatBuffer)this.mBuffer);
                GL20.glUniform1i((int)stencilLoc, (int)(model.affectedByShadow ? 1 : 0));
                GL30.glBindVertexArray((int)model.meshVAO);
                GL11.glDrawElements((int)4, (int)(model.mesh.mNumFaces() * 3), (int)5125, (long)0L);
            }
            ++i;
        }
        this.addScreenModel();
        pvLoc = GL20.glGetUniformLocation((int)this.screenShader.programID, (CharSequence)"PV");
        mLoc = GL20.glGetUniformLocation((int)this.screenShader.programID, (CharSequence)"M");
        texLoc = GL20.glGetUniformLocation((int)this.screenShader.programID, (CharSequence)"modelTexture");
        normalLoc = GL20.glGetUniformLocation((int)this.screenShader.programID, (CharSequence)"normalTexture");
        specularLoc = GL20.glGetUniformLocation((int)this.screenShader.programID, (CharSequence)"specularTexture");
        stencilLoc = GL20.glGetUniformLocation((int)this.screenShader.programID, (CharSequence)"stencil");
        int tickLoc = GL20.glGetUniformLocation((int)this.screenShader.programID, (CharSequence)"iGlobalTime");
        GL30.glBindFramebuffer((int)36160, (int)this.gFBO.gBuffer);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glCullFace((int)1029);
        GL11.glViewport((int)0, (int)0, (int)this.gFBO.width, (int)this.gFBO.height);
        GL20.glUseProgram((int)this.screenShader.programID);
        PV = this.getPV(player);
        PV.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)pvLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        model = this.screenModel;
        p = new Vec3(model.modelMatrix.m03, model.modelMatrix.m13, model.modelMatrix.m23);
        dir = player.pos.subtract(p);
        dir.normalize();
        GL20.glUniform1f((int)tickLoc, (float)((float)game.tick / 60.0f));
        GL20.glUniform1i((int)normalLoc, (int)1);
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)model.normalTexture.textureID);
        GL20.glUniform1i((int)specularLoc, (int)2);
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)model.specularTexture.textureID);
        GL20.glUniform1i((int)texLoc, (int)0);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)model.texture.textureID);
        model.modelMatrix.setBuffer(this.mBuffer);
        GL20.glUniformMatrix4fv((int)mLoc, (boolean)false, (FloatBuffer)this.mBuffer);
        GL20.glUniform1i((int)stencilLoc, (int)(model.affectedByShadow ? 1 : 0));
        GL30.glBindVertexArray((int)model.meshVAO);
        GL11.glDrawElements((int)4, (int)(model.mesh.mNumFaces() * 3), (int)5125, (long)0L);
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
        GL11.glEnable((int)3042);
        GL30.glBindFramebuffer((int)36160, (int)this.outFBO.fbo);
        GL11.glViewport((int)0, (int)0, (int)Window.width, (int)Window.height);
        GL11.glClear((int)16640);
        GL20.glUseProgram((int)this.deferredLightningShader.programID);
        this.setLightning(game, this.deferredLightningShader);
        int biasLoc = GL20.glGetUniformLocation((int)this.deferredLightningShader.programID, (CharSequence)"depthBiasMVP");
        int shadowLoc = GL20.glGetUniformLocation((int)this.deferredLightningShader.programID, (CharSequence)"shadowMap");
        int cubeShadowLoc = GL20.glGetUniformLocation((int)this.deferredLightningShader.programID, (CharSequence)"cubeShadowMap");
        int pointLightPos = GL20.glGetUniformLocation((int)this.deferredLightningShader.programID, (CharSequence)"pointLightPos");
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)this.deferredLightningShader.programID, (CharSequence)"gPosition"), (int)0);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)this.deferredLightningShader.programID, (CharSequence)"gNormal"), (int)1);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)this.deferredLightningShader.programID, (CharSequence)"gColorSpec"), (int)2);
        GL20.glUniform3f((int)GL20.glGetUniformLocation((int)this.deferredLightningShader.programID, (CharSequence)"cameraPos"), (float)((float)player.pos.x), (float)((float)player.pos.y), (float)((float)player.pos.z));
        GL20.glUniform1i((int)shadowLoc, (int)3);
        GL20.glUniform1i((int)cubeShadowLoc, (int)4);
        depthBiasMVP.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)biasLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)this.gFBO.gPosition);
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)this.gFBO.gNormal);
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)this.gFBO.gColorSpecular);
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)this.shadowMap.textureID);
        GL13.glActiveTexture((int)33988);
        GL11.glBindTexture((int)34067, (int)this.cubeShadowMap.textureID);
        GL20.glUniform3f((int)pointLightPos, (float)this.lightPos.x, (float)this.lightPos.y, (float)this.lightPos.z);
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)this.deferredLightningShader.programID, (CharSequence)"far_plane"), (float)this.far);
        GL30.glBindVertexArray((int)this.quadVaoId);
        GL11.glDrawArrays((int)4, (int)0, (int)this.quadVertexCount);
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
        GL30.glBindFramebuffer((int)36160, (int)0);
        GL11.glViewport((int)0, (int)0, (int)Window.width, (int)Window.height);
        GL11.glClear((int)16640);
        GL20.glUseProgram((int)this.postShader.programID);
        texLoc = GL20.glGetUniformLocation((int)this.postShader.programID, (CharSequence)"modelTexture");
        Vec3 color = new Vec3();
        float str = 0.0f;
        if (game.tick - (long)player.lastDamageTick < 30L) {
            long d = game.tick - (long)player.lastDamageTick;
            str = d < 15L ? (float)d / 15.0f : 1.0f - (float)(d - 15L) / 15.0f;
            color = new Vec3(0.9, 0.1, 0.1);
        } else if (player.joltTimer > 0 && player.joltTimer < Jolt.DURATION - 60) {
            str = Math.min(1.0f, (float)player.prevJoltTimer + 0.05f * (float)(player.joltTimer - player.prevJoltTimer));
            str = Math.max(str, 0.0f);
            str *= (float)(0.5 + 0.5 * Math.sin((double)game.tick * Math.PI * 2.0 / 45.0)) * 0.3f;
            color = new Vec3(0.9, 0.9, 0.1);
        }
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)this.postShader.programID, (CharSequence)"strength"), (float)str);
        GL20.glUniform3f((int)GL20.glGetUniformLocation((int)this.postShader.programID, (CharSequence)"color"), (float)((float)color.x), (float)((float)color.y), (float)((float)color.z));
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)this.outFBO.textureID);
        GL30.glBindVertexArray((int)this.quadVaoId);
        GL11.glDrawArrays((int)4, (int)0, (int)this.quadVertexCount);
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
    }

    public void addScreenModel() {
        AIMesh mesh = ResourceHandler.cube;
        if (!this.vaoMap.containsKey(mesh)) {
            this.allocateVAO(mesh);
        }
        Model m = Model.POOL.next();
        m.mesh = mesh;
        m.texture = ResourceHandler.metal.diffuse;
        m.normalTexture = ResourceHandler.metal.normal;
        m.specularTexture = ResourceHandler.metal.specular;
        Matrix4f.Pipeline p = new Matrix4f.Pipeline();
        p.add(Matrix4f.scale(4.8f, 2.9f, 0.01f));
        p.add(Matrix4f.translate(66.5f, 4.5f, 88.7f));
        m.modelMatrix = p.getMatrix();
        m.color = (Vector3f)Vector3f.POOL.next();
        m.meshVAO = ((MeshBatchBase.VAO)this.vaoMap.get((Object)mesh)).VAO;
        m.effects = true;
        m.colorMix = 1.0f;
        this.screenModel = m;
    }

    public void setupQuad() {
        float[] vertices = new float[]{-1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f};
        FloatBuffer verticesBuffer = BufferUtils.createFloatBuffer((int)vertices.length);
        verticesBuffer.put(vertices);
        verticesBuffer.flip();
        this.quadVertexCount = 6;
        this.quadVaoId = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.quadVaoId);
        GL20.glEnableVertexAttribArray((int)0);
        this.quadVboId = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.quadVboId);
        GL15.glBufferData((int)34962, (FloatBuffer)verticesBuffer, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)0);
        GL30.glBindVertexArray((int)0);
    }

    public void renderInstanced(Game game, Matrix4f depthBiasMVP, Player player) {
        int pvLoc = GL20.glGetUniformLocation((int)this.instancedShader.programID, (CharSequence)"PV");
        int mLoc = GL20.glGetUniformLocation((int)this.instancedShader.programID, (CharSequence)"M");
        int texLoc = GL20.glGetUniformLocation((int)this.instancedShader.programID, (CharSequence)"modelTexture");
        int biasLoc = GL20.glGetUniformLocation((int)this.instancedShader.programID, (CharSequence)"bias");
        int colorLoc = GL20.glGetUniformLocation((int)this.instancedShader.programID, (CharSequence)"color");
        int colorMixLoc = GL20.glGetUniformLocation((int)this.instancedShader.programID, (CharSequence)"colorMix");
        int cameraPosLoc = GL20.glGetUniformLocation((int)this.instancedShader.programID, (CharSequence)"cameraPos");
        GL20.glUseProgram((int)this.instancedShader.programID);
        Matrix4f PV = this.getPV(player);
        PV.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)pvLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        GL20.glUniform1i((int)texLoc, (int)0);
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)this.shadowMap.textureID);
        GL20.glUniform3f((int)cameraPosLoc, (float)((float)player.pos.x), (float)((float)player.pos.y), (float)((float)player.pos.z));
        GL13.glActiveTexture((int)33984);
        depthBiasMVP.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)biasLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        GL30.glBindVertexArray((int)this.instancedVAO);
        GL31.glDrawElementsInstanced((int)4, (int)(ResourceHandler.droid.mNumFaces() * 3), (int)5125, (long)0L, (int)10000);
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
    }

    public void renderTransparent(Game game, int startIndex, int endIndex, Player player) {
        int pvLoc = GL20.glGetUniformLocation((int)this.modelShader.programID, (CharSequence)"PV");
        int mLoc = GL20.glGetUniformLocation((int)this.modelShader.programID, (CharSequence)"M");
        int texLoc = GL20.glGetUniformLocation((int)this.modelShader.programID, (CharSequence)"modelTexture");
        int tickLoc = GL20.glGetUniformLocation((int)this.modelShader.programID, (CharSequence)"tick");
        int mouseLoc = GL20.glGetUniformLocation((int)this.modelShader.programID, (CharSequence)"mousePos");
        int colLoc = GL20.glGetUniformLocation((int)this.modelShader.programID, (CharSequence)"color");
        int effectsLoc = GL20.glGetUniformLocation((int)this.modelShader.programID, (CharSequence)"effects");
        int colorMixLoc = GL20.glGetUniformLocation((int)this.modelShader.programID, (CharSequence)"colorMix");
        int isUnitLoc = GL20.glGetUniformLocation((int)this.modelShader.programID, (CharSequence)"isUnit");
        GL20.glUseProgram((int)this.modelShader.programID);
        GL11.glDisable((int)2884);
        Matrix4f PV = this.getPV(player);
        PV.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)pvLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        GL20.glUniform1i((int)tickLoc, (int)0);
        GL13.glActiveTexture((int)33984);
        GL20.glUniform2f((int)mouseLoc, (float)((float)MouseHandler.x), (float)((float)MouseHandler.y));
        GL20.glUniform1i((int)isUnitLoc, (int)0);
        int i = startIndex;
        while (i <= endIndex) {
            Model model = (Model)this.transparentList.get(i);
            GL11.glBindTexture((int)3553, (int)model.texture.textureID);
            GL20.glUniform1i((int)texLoc, (int)0);
            GL20.glUniform1i((int)effectsLoc, (int)(model.effects ? 1 : 0));
            model.modelMatrix.setBuffer(this.mBuffer);
            GL20.glUniformMatrix4fv((int)mLoc, (boolean)false, (FloatBuffer)this.mBuffer);
            GL20.glUniform3f((int)colLoc, (float)model.color.x, (float)model.color.y, (float)model.color.z);
            GL20.glUniform1f((int)colorMixLoc, (float)model.colorMix);
            GL30.glBindVertexArray((int)model.meshVAO);
            GL11.glDrawElements((int)4, (int)(model.mesh.mNumFaces() * 3), (int)5125, (long)0L);
            ++i;
        }
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
    }

    private void renderSprites() {
        int pvLoc = GL20.glGetUniformLocation((int)this.spriteShader.programID, (CharSequence)"PV");
        int mLoc = GL20.glGetUniformLocation((int)this.spriteShader.programID, (CharSequence)"M");
        int texLoc = GL20.glGetUniformLocation((int)this.spriteShader.programID, (CharSequence)"texSampler");
        int colorLoc = GL20.glGetUniformLocation((int)this.spriteShader.programID, (CharSequence)"color");
        int colorMix = GL20.glGetUniformLocation((int)this.spriteShader.programID, (CharSequence)"colorMix");
        GL20.glUseProgram((int)this.spriteShader.programID);
        GL11.glDisable((int)2929);
        Matrix4f PV = Matrix4f.orthographic(0.0f, Window.width, Window.height, 0.0f, -500.0f, 500.0f);
        PV.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)pvLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        int i = 0;
        while (i < this.spriteList.size()) {
            Sprite s = (Sprite)this.spriteList.get(i);
            s.modelMatrix.setBuffer(this.mBuffer);
            GL20.glUniformMatrix4fv((int)mLoc, (boolean)false, (FloatBuffer)this.mBuffer);
            GL20.glUniform3f((int)colorLoc, (float)s.color.x, (float)s.color.y, (float)s.color.z);
            GL20.glUniform1f((int)colorMix, (float)s.colorMix);
            GL13.glActiveTexture((int)33984);
            GL20.glUniform1i((int)texLoc, (int)0);
            GL11.glBindTexture((int)3553, (int)s.textureID);
            if (s.mesh == null) {
                GL30.glBindVertexArray((int)this.quadVAO.VAO);
                GL11.glDrawElements((int)4, (int)6, (int)5125, (long)0L);
            } else {
                GL30.glBindVertexArray((int)s.meshVAO);
                GL11.glDrawElements((int)4, (int)(s.mesh.mNumFaces() * 3), (int)5125, (long)0L);
            }
            GL30.glBindVertexArray((int)0);
            GL11.glBindTexture((int)3553, (int)0);
            ++i;
        }
        GL11.glEnable((int)2929);
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
    }

    private void renderTerrain(Game game, Matrix4f depthBiasMVP, Player player) {
        if (this.terrainModel == null) {
            return;
        }
        int pvLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"PV");
        int mLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"M");
        int texLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"modelTexture");
        int tickLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"tick");
        int mouseLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"mousePos");
        int colLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"color");
        int effectsLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"effects");
        int colorMixLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"colorMix");
        int shadowMapLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"shadowMap");
        int biasLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"depthBiasMVP");
        int mapSizeLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"mapSize");
        int fogLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"fogTexture");
        int displacementLoc = GL20.glGetUniformLocation((int)this.terrainShader.programID, (CharSequence)"displacement");
        GL20.glUseProgram((int)this.terrainShader.programID);
        Matrix4f PV = this.getPV(player);
        PV.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)pvLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        GL20.glUniform1i((int)texLoc, (int)0);
        GL20.glUniform1i((int)shadowMapLoc, (int)1);
        GL20.glUniform1i((int)fogLoc, (int)2);
        GL20.glUniform1i((int)displacementLoc, (int)3);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)this.terrainModel.texture.textureID);
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)this.shadowMap.textureID);
        GL13.glActiveTexture((int)33986);
        depthBiasMVP.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)biasLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        GL20.glUniform1i((int)effectsLoc, (int)(this.terrainModel.effects ? 1 : 0));
        this.terrainModel.modelMatrix.setBuffer(this.mBuffer);
        GL20.glUniformMatrix4fv((int)mLoc, (boolean)false, (FloatBuffer)this.mBuffer);
        GL20.glUniform3f((int)colLoc, (float)this.terrainModel.color.x, (float)this.terrainModel.color.y, (float)this.terrainModel.color.z);
        GL20.glUniform1f((int)colorMixLoc, (float)this.terrainModel.colorMix);
        GL20.glUniform2f((int)mapSizeLoc, (float)0.0f, (float)0.0f);
        GL30.glBindVertexArray((int)this.terrainModel.meshVAO);
        GL11.glDrawElements((int)4, (int)(this.terrainModel.mesh.mNumFaces() * 3), (int)5125, (long)0L);
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
    }

    private void renderSkyBox(Game game, Matrix4f depthBiasMVP, Player player) {
        if (this.skyBoxModel == null) {
            return;
        }
        int pvLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"PV");
        int mLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"M");
        int texLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"modelTexture");
        int tickLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"tick");
        int mouseLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"mousePos");
        int colLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"color");
        int effectsLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"effects");
        int colorMixLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"colorMix");
        int shadowMapLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"shadowMap");
        int biasLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"depthBiasMVP");
        int mapSizeLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"mapSize");
        int fogLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"fogTexture");
        int displacementLoc = GL20.glGetUniformLocation((int)this.skyBoxShader.programID, (CharSequence)"displacement");
        GL20.glUseProgram((int)this.skyBoxShader.programID);
        Matrix4f PV = this.getPV(player);
        PV.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)pvLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        GL20.glUniform1i((int)texLoc, (int)0);
        GL20.glUniform1i((int)shadowMapLoc, (int)1);
        GL20.glUniform1i((int)fogLoc, (int)2);
        GL20.glUniform1i((int)displacementLoc, (int)3);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)this.skyBoxModel.texture.textureID);
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)this.shadowMap.textureID);
        GL13.glActiveTexture((int)33986);
        depthBiasMVP.setBuffer(this.pvBuffer);
        GL20.glUniformMatrix4fv((int)biasLoc, (boolean)false, (FloatBuffer)this.pvBuffer);
        GL20.glUniform1i((int)effectsLoc, (int)(this.skyBoxModel.effects ? 1 : 0));
        this.skyBoxModel.modelMatrix.setBuffer(this.mBuffer);
        GL20.glUniformMatrix4fv((int)mLoc, (boolean)false, (FloatBuffer)this.mBuffer);
        GL20.glUniform1f((int)colorMixLoc, (float)this.terrainModel.colorMix);
        GL20.glUniform2f((int)mapSizeLoc, (float)0.0f, (float)0.0f);
        GL30.glBindVertexArray((int)this.skyBoxModel.meshVAO);
        GL11.glDrawElements((int)4, (int)(this.skyBoxModel.mesh.mNumFaces() * 3), (int)5125, (long)0L);
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
    }

    private void setLightning(Game game, GLSLProgram program) {
        int lightLoc = GL20.glGetUniformLocation((int)program.programID, (CharSequence)"lightPos");
        int colorLoc = GL20.glGetUniformLocation((int)program.programID, (CharSequence)"lightColor");
        int strengthLoc = GL20.glGetUniformLocation((int)program.programID, (CharSequence)"lightStrength");
        int numLightLoc = GL20.glGetUniformLocation((int)program.programID, (CharSequence)"numLights");
        int numVolumetricLightsLoc = GL20.glGetUniformLocation((int)program.programID, (CharSequence)"numVolumetricLights");
        int lightDirLoc = GL20.glGetUniformLocation((int)program.programID, (CharSequence)"lightDirs");
        int lightDirPowsLoc = GL20.glGetUniformLocation((int)program.programID, (CharSequence)"lightDirPows");
        if (game != null) {
            ArrayList<Light> lights = game.lights;
            Collections.sort(lights, new Comparator<Light>(){

                @Override
                public int compare(Light a, Light b) {
                    boolean v1 = a.volumetric();
                    boolean v2 = b.volumetric();
                    if (v1 && !v2) {
                        return -1;
                    }
                    if (!v1 && v2) {
                        return 1;
                    }
                    return 0;
                }
            });
            int numLights = lights.size();
            GL20.glUniform1i((int)numLightLoc, (int)numLights);
            int numVolumetric = 0;
            int i = 0;
            while (i < lights.size()) {
                if (((Light)lights.get(i)).volumetric()) {
                    ++numVolumetric;
                }
                ++i;
            }
            GL20.glUniform1i((int)numVolumetricLightsLoc, (int)numVolumetric);
            float[] positions = new float[numLights * 3];
            float[] colors = new float[numLights * 3];
            float[] dirs = new float[numLights * 3];
            float[] strengths = new float[numLights];
            float[] dirPows = new float[numLights];
            int i2 = 0;
            while (i2 < numLights && i2 < 100) {
                try {
                    Light l = game.lights.get(i2);
                    if (l != null) {
                        Vec3 pos = l.getPosition();
                        Vec3 color = l.getColor();
                        Vec3 dir = l.getDir();
                        dir.normalize();
                        positions[i2 * 3 + 0] = (float)pos.x;
                        positions[i2 * 3 + 1] = (float)pos.y;
                        positions[i2 * 3 + 2] = (float)pos.z;
                        colors[i2 * 3 + 0] = (float)color.x;
                        colors[i2 * 3 + 1] = (float)color.y;
                        colors[i2 * 3 + 2] = (float)color.z;
                        dirs[i2 * 3 + 0] = (float)dir.x;
                        dirs[i2 * 3 + 1] = (float)dir.y;
                        dirs[i2 * 3 + 2] = (float)dir.z;
                        strengths[i2] = l.getStrength();
                        dirPows[i2] = l.getLightDirPow();
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.println("Non critical exception in setLightning");
                }
                ++i2;
            }
            GL20.glUniform3fv((int)lightLoc, (float[])positions);
            GL20.glUniform3fv((int)colorLoc, (float[])colors);
            GL20.glUniform3fv((int)lightDirLoc, (float[])dirs);
            GL20.glUniform1fv((int)strengthLoc, (float[])strengths);
            GL20.glUniform1fv((int)lightDirPowsLoc, (float[])dirPows);
        }
    }

    public void addString(String text, Vector3f pos) {
        this.addString(text, pos, this.nextVector3f(1.0f, 1.0f, 1.0f), ResourceHandler.helvetica);
    }

    public void addString(String text, Vector3f pos, Vector3f color) {
        this.addString(text, pos, color, ResourceHandler.helvetica);
    }

    public void addString(String text, Vector3f pos, Vector3f color, TextureFont textureFont) {
        int x = 0;
        int y = 0;
        int fontSize = textureFont.getFontSize();
        int i = 0;
        while (i < text.length()) {
            Sprite m = Sprite.POOL.next();
            char c = text.charAt(i);
            if (c == '\n') {
                x = 0;
                y += fontSize;
            } else {
                Texture ch = textureFont.getCharTexture(text.charAt(i));
                int width = ch.width;
                int height = ch.height;
                Matrix4f.Pipeline p = new Matrix4f.Pipeline();
                p.add(Matrix4f.scale(width, height, 1.0f));
                p.add(Matrix4f.translate(pos.x + (float)x, pos.y + (float)y, pos.z));
                m.textureID = ch.textureID;
                m.modelMatrix = p.getMatrix();
                m.color = color;
                m.colorMix = 1.0f;
                x += width;
                this.spriteList.add(m);
            }
            ++i;
        }
    }

    public void addTerrain(AIMesh mesh, Texture texture, Matrix4f modelMatrix, Vector3f color, boolean effects, float colorMix) {
        if (!this.vaoMap.containsKey(mesh)) {
            this.allocateVAO(mesh);
        }
        Model m = Model.POOL.next();
        m.mesh = mesh;
        m.texture = texture;
        m.modelMatrix = modelMatrix;
        m.color = color;
        m.meshVAO = ((MeshBatchBase.VAO)this.vaoMap.get((Object)mesh)).VAO;
        m.effects = effects;
        m.colorMix = colorMix;
        m.giveShadow = false;
        m.affectedByShadow = true;
        this.renderList.add(m);
    }

    public void addSkybox(AIMesh mesh, Texture texture, Matrix4f matrix, Vector3f nextVector3f, boolean b, float f) {
        if (!this.vaoMap.containsKey(mesh)) {
            this.allocateVAO(mesh);
        }
        Model m = Model.POOL.next();
        m.mesh = mesh;
        m.texture = texture;
        m.modelMatrix = matrix;
        m.meshVAO = ((MeshBatchBase.VAO)this.vaoMap.get((Object)mesh)).VAO;
        this.skyBoxModel = m;
    }

    public void reloadShaders() {
        if (this.modelShader != null) {
            this.modelShader.free();
        }
        this.modelShader = GLSLProgram.getProgram("/shaders/vertex.vert", "/shaders/fragment.frag");
        if (this.shadowShader != null) {
            this.shadowShader.free();
        }
        this.shadowShader = GLSLProgram.getProgram("/shaders/vertexShadow.vert", "/shaders/fragmentShadow.frag");
        if (this.spriteShader != null) {
            this.spriteShader.free();
        }
        this.spriteShader = GLSLProgram.getProgram("/shaders/vertex2D.vert", "/shaders/fragment2D.frag");
        if (this.terrainShader != null) {
            this.terrainShader.free();
        }
        this.terrainShader = GLSLProgram.getProgram("/shaders/vertexTerrain.vert", "/shaders/fragmentTerrain.frag");
        if (this.skyBoxShader != null) {
            this.skyBoxShader.free();
        }
        this.skyBoxShader = GLSLProgram.getProgram("/shaders/vertexSkyBox.vert", "/shaders/fragmentSkyBox.frag");
        if (this.instancedShader != null) {
            this.instancedShader.free();
        }
        this.instancedShader = GLSLProgram.getProgram("/shaders/vertexInstanced.vert", "/shaders/fragmentInstanced.frag");
        if (this.deferredGeometryShader != null) {
            this.deferredGeometryShader.free();
        }
        this.deferredGeometryShader = GLSLProgram.getProgram("/shaders/deferredGeometry.vert", "/shaders/deferredGeometry.frag");
        if (this.deferredLightningShader != null) {
            this.deferredLightningShader.free();
        }
        this.deferredLightningShader = GLSLProgram.getProgram("/shaders/deferredLightning.vert", "/shaders/deferredLightning.frag");
        if (this.postShader != null) {
            this.postShader.free();
        }
        this.postShader = GLSLProgram.getProgram("/shaders/post.vert", "/shaders/post.frag");
        if (this.pointShadowShader != null) {
            this.pointShadowShader.free();
        }
        this.pointShadowShader = GLSLProgram.getProgram("/shaders/pointShadow.vert", "/shaders/pointShadow.frag", "/shaders/pointShadow.geom");
        if (this.screenShader != null) {
            this.screenShader.free();
        }
        this.screenShader = GLSLProgram.getProgram("/shaders/screen.vert", "/shaders/screen.frag");
    }
}

