/*
 * Decompiled with CFR 0.152.
 */
package sound;

import java.util.HashMap;
import java.util.List;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.ALUtil;
import sound.EFXUtil;

public class OpenALInfo {
    public static void main(String[] args) {
        long device = ALC10.alcOpenDevice(args.length == 0 ? null : args[0]);
        ALCCapabilities deviceCaps = ALC.createCapabilities((long)device);
        long alContext = ALC10.alcCreateContext((long)device, null);
        OpenALInfo.checkALCError(device);
        ALC10.alcMakeContextCurrent((long)alContext);
        ALCapabilities contextCaps = AL.createCapabilities((ALCCapabilities)deviceCaps);
        OpenALInfo.printALCInfo(device, deviceCaps);
        OpenALInfo.printALInfo();
        if (deviceCaps.ALC_EXT_EFX) {
            OpenALInfo.printEFXInfo(device);
        }
        ALC10.alcDestroyContext((long)alContext);
        ALC10.alcCloseDevice((long)device);
    }

    private static void printALCInfo(long device, ALCCapabilities caps) {
        if (caps.ALC_ENUMERATION_EXT) {
            if (caps.ALC_ENUMERATE_ALL_EXT) {
                OpenALInfo.printDevices(4115, "playback");
            } else {
                OpenALInfo.printDevices(4101, "playback");
            }
            OpenALInfo.printDevices(784, "capture");
        } else {
            System.out.println("No device enumeration available");
        }
        if (caps.ALC_ENUMERATE_ALL_EXT) {
            System.out.println("Default playback device: " + ALC10.alcGetString((long)0L, (int)4114));
        } else {
            System.out.println("Default playback device: " + ALC10.alcGetString((long)0L, (int)4100));
        }
        System.out.println("Default capture device: " + ALC10.alcGetString((long)0L, (int)785));
        int majorVersion = ALC10.alcGetInteger((long)device, (int)4096);
        int minorVersion = ALC10.alcGetInteger((long)device, (int)4097);
        OpenALInfo.checkALCError(device);
        System.out.println("ALC version: " + majorVersion + "." + minorVersion);
        System.out.println("ALC extensions:");
        String[] extensions = ALC10.alcGetString((long)device, (int)4102).split(" ");
        OpenALInfo.checkALCError(device);
        String[] stringArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (!extension.trim().isEmpty()) {
                System.out.println("    " + extension);
            }
            ++n2;
        }
    }

    private static void printALInfo() {
        String[] extensions;
        System.out.println("OpenAL vendor string: " + AL10.alGetString((int)45057));
        System.out.println("OpenAL renderer string: " + AL10.alGetString((int)45059));
        System.out.println("OpenAL version string: " + AL10.alGetString((int)45058));
        System.out.println("AL extensions:");
        String[] stringArray = extensions = AL10.alGetString((int)45060).split(" ");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            if (!extension.trim().isEmpty()) {
                System.out.println("    " + extension);
            }
            ++n2;
        }
        OpenALInfo.checkALError();
    }

    private static void printEFXInfo(long device) {
        int efxMajor = ALC10.alcGetInteger((long)device, (int)131073);
        int efxMinor = ALC10.alcGetInteger((long)device, (int)131074);
        if (ALC10.alcGetError((long)device) == 0) {
            System.out.println("EFX version: " + efxMajor + "." + efxMinor);
        }
        int auxSends = ALC10.alcGetInteger((long)device, (int)131075);
        if (ALC10.alcGetError((long)device) == 0) {
            System.out.println("Max auxiliary sends: " + auxSends);
        }
        System.out.println("Supported filters: ");
        HashMap<String, Integer> filters = new HashMap<String, Integer>();
        filters.put("Low-pass", 1);
        filters.put("High-pass", 2);
        filters.put("Band-pass", 3);
        filters.entrySet().stream().filter(entry -> EFXUtil.isFilterSupported((Integer)entry.getValue())).forEach(entry -> System.out.println("    " + (String)entry.getKey()));
        System.out.println("Supported effects: ");
        HashMap<String, Integer> effects = new HashMap<String, Integer>();
        effects.put("EAX Reverb", 32768);
        effects.put("Reverb", 1);
        effects.put("Chorus", 2);
        effects.put("Distortion", 3);
        effects.put("Echo", 4);
        effects.put("Flanger", 5);
        effects.put("Frequency Shifter", 6);
        effects.put("Vocal Morpher", 7);
        effects.put("Pitch Shifter", 8);
        effects.put("Ring Modulator", 9);
        effects.put("Autowah", 10);
        effects.put("Compressor", 11);
        effects.put("Equalizer", 12);
        effects.entrySet().stream().filter(e -> EFXUtil.isEffectSupported((Integer)e.getValue())).forEach(e -> System.out.println("    " + (String)e.getKey()));
    }

    private static void printDevices(int which, String kind) {
        List devices = ALUtil.getStringList((long)0L, (int)which);
        System.out.println("Available " + kind + " devices: ");
        for (String d : devices) {
            System.out.println("    " + d);
        }
    }

    static void checkALCError(long device) {
        int err = ALC10.alcGetError((long)device);
        if (err != 0) {
            throw new RuntimeException(ALC10.alcGetString((long)device, (int)err));
        }
    }

    static void checkALError() {
        int err = AL10.alGetError();
        if (err != 0) {
            throw new RuntimeException(AL10.alGetString((int)err));
        }
    }
}

