#version 330

in vec2 fragUV;
in vec3 fragNormal;
in vec3 fragPos;
in float isConstructing;
in vec4 shadowCoord;


out vec4 outColor;

uniform sampler2D modelTexture;
uniform sampler2D noiseP;
uniform float tick;
uniform vec2 mousePos;
uniform vec3 color;
uniform bool effects;
uniform float colorMix;
uniform bool isUnit;
uniform bool underConstruction;
uniform vec2 mapSize;
uniform float meshBottom;
uniform float meshTop;
uniform float portionConstructed;
uniform vec3 cameraPos;
uniform sampler2D fogTexture;
uniform sampler2DShadow shadowMap;


SHARED_OJ


void main()
{

	vec3 lightDir = normalize(vec3(0.5, -0.5, 0.0));
	vec3 viewDir = normalize(cameraPos - fragPos);//normalize(vec3(10, 10, 10) - fragPos);
	
	float df = max(0.0, dot(fragNormal, normalize(-lightDir)));
	vec4 tc = texture(modelTexture, fragUV);
    vec3 c = mix(tc.xyz, color, colorMix);
    //vec3 color = vec3(0.7,0.2,0.2);
    float ambient = 0.6;
    float diffuse = max(0.0, dot(fragNormal, normalize(-lightDir)));
	float sp = min(1, specular(fragNormal, lightDir, viewDir, 30));
    outColor = vec4(c*(ambient + diffuse) + 0.5*sp, 1.0);

//	vec4 finalColor = addLight(vec4(c,1), fragNormal, fragPos, lightDir, 1);
	//outColor = vec4(c.xyz + 0.5*sp, tc.w);


}
