
#version 330

layout ( location = 0) in vec3 position;
layout ( location = 1) in vec2 uv;
layout ( location = 2) in vec3 normal;

out vec2 fragUV;
out vec3 fragNormal;
out vec3 fragPos;
out vec4 shadowCoord;
uniform mat4 depthBiasMVP;
uniform mat4 PV;
uniform mat4 M;
//uniform sampler2D displacement;
uniform vec2 mapSize;

void main()
{
	vec3 realPos = (M*vec4(position,1.0)).xyz;
	//realPos.z += 10*(texture(displacement, vec2(realPos.x/mapSize.x, realPos.y/mapSize.y)).x - 0.5);
    gl_Position = PV*vec4(realPos, 1.0);
    fragUV = vec2(uv.x, 1 - uv.y);
    fragNormal = normalize(mat3(M)*normal);
    fragPos = (vec4(realPos, 1.0)).xyz;
    
        
    shadowCoord = depthBiasMVP * vec4(realPos,1.0);
}
