#version 110
#define float4 vec4
#define float3 vec3
#define float2 vec2
#define oUV gl_TexCoord[0]
#define tex3D texture3D
#define tex2D texture2D
#define tex1D texture1D
varying float fog;
varying vec4 Color;
varying vec4 ThePos;
uniform mat4 MV_Proj;
uniform float IsPedestal;
uniform float PedestalHeight;
uniform float ttime;
varying vec4 FromView;
varying vec4 LightPosZ;

varying vec3 Normal;
varying vec4 ShadowPosZ;
uniform float IsShadow;
uniform float PosY;
uniform float IsTV;
varying vec4 ShadowPosZ2;
uniform float HasReflection;
uniform float HasShadows;

uniform sampler2D texture2d_depth;
uniform sampler2D texture2d_depth2;
uniform sampler2D texture2d_reflection;
uniform sampler2D texture2d_stone;
uniform sampler2D texture2d_video;



float hash(vec3 p)
{
    p  = fract( p*0.3183099+.1 ); p *= 17.0;
    return fract( p.x*p.y*p.z*(p.x+p.y+p.z) );
}

float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);
	
    return mix(mix(mix( hash(p+vec3(0,0,0)), 
                        hash(p+vec3(1,0,0)),f.x),
                   mix( hash(p+vec3(0,1,0)), 
                        hash(p+vec3(1,1,0)),f.x),f.y),
               mix(mix( hash(p+vec3(0,0,1)), 
                        hash(p+vec3(1,0,1)),f.x),
                   mix( hash(p+vec3(0,1,1)), 
                        hash(p+vec3(1,1,1)),f.x),f.y),f.z);
}

float map5( in vec3 p )
{
	vec3 q = p - vec3(0.0,0.1,1.0);
	float f;
    f  = 0.50000*noise( q ); q = q*2.02;
    f += 0.25000*noise( q ); q = q*2.03;
    f += 0.12500*noise( q ); q = q*2.01;
    f += 0.06250*noise( q ); q = q*2.02;
    f += 0.03125*noise( q );
	return clamp( f, 0.0, 1.0 );
}

float map4( in vec3 p )
{
	vec3 q = p - vec3(0.0,0.1,1.0)* ttime;
	float f;
    f  = 0.50000*noise( q ); q = q*2.02;
    f += 0.25000*noise( q ); q = q*2.03;
    f += 0.12500*noise( q ); q = q*2.01;
    f += 0.06250*noise( q );
	return clamp( 1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0 );
}

float map3( in vec3 p )
{
	vec3 q = p - vec3(0.0,0.1,1.0) * ttime;
	float f;
    f  = 0.50000*noise( q ); q = q*2.02;
    f += 0.25000*noise( q ); q = q*2.03;
    f += 0.12500*noise( q );
	return clamp( 1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0 );
}

float map2( in vec3 p )
{
	vec3 q = p - vec3(0.0,0.1,1.0)*ttime;
	float f;
    f  = 0.50000*noise( q ); q = q*2.02;
    f += 0.25000*noise( q );;
	return clamp( 1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0 );
}







void main(void)
{
	discard;
	//iscard;
		float cc=1.0*clamp ((ttime-8.9)*0.5,0.0,1.0);
		cc*=1.0-1.0*clamp ((ttime-12.9)*0.15,0.0,1.0);
		if (cc<0.01)
	discard;

	vec4 Color2 = Color;
	float fr1=	0.5+0.5*sin(ThePos.x*10000.0);
	float fup=1.0;


	float mult=0.3;

	float smog;
		smog=map5 (vec3 (ThePos.xy*mult*0.7-vec2 (ttime*0.0,-ttime*0.0) ,-ttime*0.2+ThePos.z*mult*10.5));
		smog*=1.0;
		//smog=1.0;
//	smog*=clamp (1.0-clamp (abs(ThePos.z-2.0)*0.07,0.0,1.0),0.0,1.0);
//	smog*=1.0-clamp (ThePos.y*0.5,0.0,1.0);
//	smog*=fup;

		//smog*=1.0-clamp ((ttime-(5.5))*0.25,0.0,1.0);
		
		
		//smog*=clamp ((ttime-7.0)*0.2,0.0,1.0);
		

		//smog*=0.0;
	
		smog=clamp (smog,0.0,1.0);
		smog*=smog;
		smog*=smog*1.5;
		smog*=clamp (1.0-length (ThePos.xy*vec2 (1.0,0.5))*0.16,0.0,1.0);

		smog=clamp (smog,0.0,1.0);
		Color2.w=smog*0.2;

		
		Color2.xyz=vec3 (smog)*0.2*vec3 (0.6,0.7,1.0)*0.2*cc;
		//Color2.xyz=vec3 (smog)*0.2*vec3 (0.8,0.7,0.7)*0.2*cc;
//*vec3 (0.5,0.7,1.0);
	
	//smog*=5.0;



gl_FragData[0]=Color2;
gl_FragData[1]=Color2;
	//gl_FragData[0]=vec4 (1.0,0.0,0.0,0.2);

	//scard;

}














