
#include<types.hlsl>

Texture2D effectInput;
Texture2D tex1;
Texture2D tex2;
SamplerState SampleType;

cbuffer Params
{
    float2 resolution;

    float fade;
    float xfade;

    float2 v1;
    float2 v2;

    float time;
}

Texture1D texFft;


//#define PI 3.14159

float2 random2(float2 c)
{
    float j = 4906.0 * sin(dot(c, float2(169.7, 5.8)));
    float2 r;
    r.x = frac(512.0 * j);
    j *= .125;
    r.y = frac(512.0 * j);
    return r - 0.5;
}

#define F2 0.3660254
#define G2 -0.2113249

float simplex2d(float2 p)
{
    float2 s = floor(p + (p.x + p.y) * F2), x = p - s - (s.x + s.y) * G2;
    float e = step(0.0, x.x - x.y);
    float2 i1 = float2(e, 1.0 - e), x1 = x - i1 - G2, x2 = x - 1.0 - 2.0 * G2;
    float3 w, d;
    w.x = dot(x, x);
    w.y = dot(x1, x1);
    w.z = dot(x2, x2);
    w = max(0.5 - w, 0.0);
    d.x = dot(random2(s + 0.0), x);
    d.y = dot(random2(s + i1), x1);
    d.z = dot(random2(s + 1.0), x2);
    w *= w;
    w *= w;
    d *= w;
    return dot(d, float3(70.0, 70.0, 70.0));
}

float3 rgb2yiq(float3 color)
{
    float3x3 a = float3x3(0.299, 0.587, 0.114, 0.596, -0.274, -0.321, 0.211, -0.523, 0.311);
    return mul(a, color);
}
float3 yiq2rgb(float3 color)
{
    float3x3 a = float3x3(1., 0.956, 0.621, 1, -0.272, -0.647, 1., -1.107, 1.705);
    return mul(a, color);
}

float3 convertRGB443quant(float3 color)
{
    float3 out0 = fmod(color, 1. / 16.);
    out0.b = fmod(color.b, 1. / 8.);
    return out0;
}
float3 convertRGB443(float3 color)
{
    return color - convertRGB443quant(color);
}

float2 sincos(float x)
{
    return float2(sin(x), cos(x));
}
float2 rotate2d(float2 uv, float phi)
{
    float2 t = sincos(phi);
    return float2(uv.x * t.y - uv.y * t.x, uv.x * t.x + uv.y * t.y);
}
float3 rotate3d(float3 p, float3 v, float phi)
{
    v = normalize(v);
    float2 t = sincos(-phi);
    float s = t.x, c = t.y, x = -v.x, y = -v.y, z = -v.z;
    float4x4 M = float4x4(x * x * (1. - c) + c, x * y * (1. - c) - z * s, x * z * (1. - c) + y * s, 0., y * x * (1. - c) + z * s, y * y * (1. - c) + c, y * z * (1. - c) - x * s, 0., z * x * (1. - c) - y * s, z * y * (1. - c) + x * s, z * z * (1. - c) + c, 0., 0., 0., 0., 1.);
    return /* (float4(p, 1.) * M).xyz;*/
	mul(M, float4(p.x, p.y, p.z, 1));

}

float varazslat(float2 position, float time)
{
    float color = 0.0;
    float t = 2. * time;
    color += sin(position.x * cos(t / 10.0) * 20.0) + cos(position.x * cos(t / 15.) * 10.0);
    color += sin(position.y * sin(t / 5.0) * 15.0) + cos(position.x * sin(t / 25.) * 20.0);
    color += sin(position.x * sin(t / 10.0) * .2) + sin(position.y * sin(t / 35.) * 10.);
    color *= sin(t / 10.) * .5;
	
    return color;
}

float4 main(FXPixelInputType input) : SV_TARGET
{

    float ar = resolution.y / resolution.x;

    float2 uv = input.position / resolution.y;
    float2 uva = input.position / resolution.y;
    uv.x = uv.x - (ar / 4);

    float2 res1;
    tex1.GetDimensions(res1.x, res1.y);
    float ar1 = res1.x / res1.y;

    float2 res2;
    tex2.GetDimensions(res2.x, res2.y);
    float ar2 = res2.x / res2.y;

    float2 uv1 = uv;
    uv1.y = uv1.y - .5 + ar / 2.;
    uv1.y = uv1.y * ar1;

    float2 uv2 = uv;
    uv2.y = uv2.y - .5 + ar / 2.;
    uv2.y = uv2.y * ar2;

    uv2 = uv2 - (v1) * (1. - xfade);
    uv1 = uv1 - (v2) * xfade;

    float fft = texFft.Sample(SampleType, uva.y / 20) * 15 + (sin(time / 4) + 1) * .025;

    int ui = floor(uva.x * 200 + time * 3.434 + sin(3 + time / 1.21783)*2 +      fft     * 10  );
    int vi = floor(uva.y * 200 + time * 2.345 + cos(2 - time / 2.81732) * 3 - sin(fft+5) * 10  );

    float a0 = fmod(ui ^ vi, 128) / 128;
    float a1 = fmod(ui ^ vi, 34) / 128;
    float a2 = fmod(ui ^ vi, 324) / 128;

    float3 vlsd = float3(0, 1, 0);
    vlsd = rotate3d(vlsd, float3(1., 1., 0.), time);
    vlsd = rotate3d(vlsd, float3(1., 1., 0.), time);
    vlsd = rotate3d(vlsd, float3(1., 1., 0.), time);

    float2
        v0 = .75 * sincos(.3457 * time + .3423) - simplex2d(uv * a0),
        v1 = .75 * sincos(.7435 * time + .4565) - simplex2d(uv * a1),
        v2 = .75 * sincos(.5345 * time + .3434) - simplex2d(uv * a2);

    float3 lsd0 = float3(dot(uv - v0, vlsd.xy), dot(uv - v1, vlsd.yz), dot(uv - v2, vlsd.zx));
    float3 lsd1 = .2 + 2.5 * float3(
    	(16. * simplex2d(uv + v0) + 8. * simplex2d((uv + v0) * 2.) + 4. * simplex2d((uv + v0) * 4.) + 2. * simplex2d((uv + v0) * 8.) + simplex2d((v0 + uv) * 16.)) / 32.,
        (16. * simplex2d(uv + v1) + 8. * simplex2d((uv + v1) * 2.) + 4. * simplex2d((uv + v1) * 4.) + 2. * simplex2d((uv + v1) * 8.) + simplex2d((v1 + uv) * 16.)) / 32.,
        (16. * simplex2d(uv + v2) + 8. * simplex2d((uv + v2) * 2.) + 4. * simplex2d((uv + v2) * 4.) + 2. * simplex2d((uv + v2) * 8.) + simplex2d((v2 + uv) * 16.)) / 32.
    );

    float3 bg = lsd0 * lsd1;

    float g = bg.r;

    bg = yiq2rgb(bg);

    bg = lerp(float3(g, g, g) / 2., bg, saturate(time / 25));

    float4 t1 = float4(0, 0, 0, 0);
    float4 t2 = float4(0, 0, 0, 0);

    uv1.x = uv1.x + .0075 * sin(fft * 20);

    if (uv1.x < 1 && uv1.y < 1. && uv1.x > 0 && uv1.y > 0)
        t1 = tex1.Sample(SampleType, uv1);

    uv2.x = uv2.x + .0072 * sin(fft * 56);


    if (uv2.x < 1 && uv2.y < 1. && uv2.x > 0 && uv2.y > 0)
        t2 = tex2.Sample(SampleType, uv2);

    float4 color = lerp(t1, t2, saturate(xfade));
    color = lerp(float4(bg.r, bg.g, bg.b, 1), color, color.a);

    color = lerp(float4(0, 0, 0, 1), color, saturate(fade));
	
    //color = t1;

    //color.rgb = float3(pow(color.r, 0.45), pow(color.g, 0.45), pow(color.b, 0.45));
    color.a = 1.;
    return color;
}

