/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.RangeModel;

final class BoundedRangeModel
extends RangeModel {
    private final int step;
    private final int size;
    private final boolean rightAdaptive;
    private final boolean affectedByStringSlicingBug;

    BoundedRangeModel(int begin2, int end2, boolean inclusiveEnd, boolean rightAdaptive) {
        super(begin2);
        this.step = begin2 <= end2 ? 1 : -1;
        this.size = Math.abs(end2 - begin2) + (inclusiveEnd ? 1 : 0);
        this.rightAdaptive = rightAdaptive;
        this.affectedByStringSlicingBug = inclusiveEnd;
    }

    public int size() {
        return this.size;
    }

    int getStep() {
        return this.step;
    }

    boolean isRightUnbounded() {
        return false;
    }

    boolean isRightAdaptive() {
        return this.rightAdaptive;
    }

    boolean isAffactedByStringSlicingBug() {
        return this.affectedByStringSlicingBug;
    }
}

