/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBTTPackedchar;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbtt_pack_range")
public class STBTTPackRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FONT_SIZE;
    public static final int FIRST_UNICODE_CODEPOINT_IN_RANGE;
    public static final int ARRAY_OF_UNICODE_CODEPOINTS;
    public static final int NUM_CHARS;
    public static final int CHARDATA_FOR_RANGE;
    public static final int H_OVERSAMPLE;
    public static final int V_OVERSAMPLE;

    STBTTPackRange(long address, ByteBuffer container) {
        super(address, container);
    }

    public STBTTPackRange(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), STBTTPackRange.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float font_size() {
        return STBTTPackRange.nfont_size(this.address());
    }

    public int first_unicode_codepoint_in_range() {
        return STBTTPackRange.nfirst_unicode_codepoint_in_range(this.address());
    }

    @NativeType(value="int *")
    public IntBuffer array_of_unicode_codepoints() {
        return STBTTPackRange.narray_of_unicode_codepoints(this.address());
    }

    public int num_chars() {
        return STBTTPackRange.nnum_chars(this.address());
    }

    @NativeType(value="stbtt_packedchar *")
    public STBTTPackedchar.Buffer chardata_for_range() {
        return STBTTPackRange.nchardata_for_range(this.address());
    }

    public STBTTPackRange font_size(float value) {
        STBTTPackRange.nfont_size(this.address(), value);
        return this;
    }

    public STBTTPackRange first_unicode_codepoint_in_range(int value) {
        STBTTPackRange.nfirst_unicode_codepoint_in_range(this.address(), value);
        return this;
    }

    public STBTTPackRange array_of_unicode_codepoints(@NativeType(value="int *") IntBuffer value) {
        STBTTPackRange.narray_of_unicode_codepoints(this.address(), value);
        return this;
    }

    public STBTTPackRange num_chars(int value) {
        STBTTPackRange.nnum_chars(this.address(), value);
        return this;
    }

    public STBTTPackRange chardata_for_range(@NativeType(value="stbtt_packedchar *") STBTTPackedchar.Buffer value) {
        STBTTPackRange.nchardata_for_range(this.address(), value);
        return this;
    }

    public STBTTPackRange set(float font_size, int first_unicode_codepoint_in_range, IntBuffer array_of_unicode_codepoints, int num_chars, STBTTPackedchar.Buffer chardata_for_range) {
        this.font_size(font_size);
        this.first_unicode_codepoint_in_range(first_unicode_codepoint_in_range);
        this.array_of_unicode_codepoints(array_of_unicode_codepoints);
        this.num_chars(num_chars);
        this.chardata_for_range(chardata_for_range);
        return this;
    }

    public STBTTPackRange set(STBTTPackRange src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static STBTTPackRange malloc() {
        return STBTTPackRange.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBTTPackRange calloc() {
        return STBTTPackRange.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBTTPackRange create() {
        return new STBTTPackRange(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static STBTTPackRange create(long address) {
        return address == 0L ? null : new STBTTPackRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return STBTTPackRange.create(STBTTPackRange.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBTTPackRange.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(STBTTPackRange.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static STBTTPackRange mallocStack() {
        return STBTTPackRange.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTPackRange callocStack() {
        return STBTTPackRange.callocStack(MemoryStack.stackGet());
    }

    public static STBTTPackRange mallocStack(MemoryStack stack) {
        return STBTTPackRange.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTPackRange callocStack(MemoryStack stack) {
        return STBTTPackRange.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBTTPackRange.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBTTPackRange.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBTTPackRange.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBTTPackRange.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nfont_size(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)FONT_SIZE);
    }

    public static int nfirst_unicode_codepoint_in_range(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FIRST_UNICODE_CODEPOINT_IN_RANGE);
    }

    public static IntBuffer narray_of_unicode_codepoints(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)ARRAY_OF_UNICODE_CODEPOINTS), STBTTPackRange.nnum_chars(struct));
    }

    public static int nnum_chars(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUM_CHARS);
    }

    public static STBTTPackedchar.Buffer nchardata_for_range(long struct) {
        return STBTTPackedchar.create(MemoryUtil.memGetAddress(struct + (long)CHARDATA_FOR_RANGE), STBTTPackRange.nnum_chars(struct));
    }

    public static byte nh_oversample(long struct) {
        return MemoryUtil.memGetByte(struct + (long)H_OVERSAMPLE);
    }

    public static byte nv_oversample(long struct) {
        return MemoryUtil.memGetByte(struct + (long)V_OVERSAMPLE);
    }

    public static void nfont_size(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)FONT_SIZE, value);
    }

    public static void nfirst_unicode_codepoint_in_range(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FIRST_UNICODE_CODEPOINT_IN_RANGE, value);
    }

    public static void narray_of_unicode_codepoints(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)ARRAY_OF_UNICODE_CODEPOINTS, MemoryUtil.memAddressSafe(value));
    }

    public static void nnum_chars(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NUM_CHARS, value);
    }

    public static void nchardata_for_range(long struct, STBTTPackedchar.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)CHARDATA_FOR_RANGE, value.address());
    }

    public static void nh_oversample(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)H_OVERSAMPLE, value);
    }

    public static void nv_oversample(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)V_OVERSAMPLE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CHARDATA_FOR_RANGE));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            STBTTPackRange.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = STBTTPackRange.__struct(STBTTPackRange.__member(4), STBTTPackRange.__member(4), STBTTPackRange.__member(POINTER_SIZE), STBTTPackRange.__member(4), STBTTPackRange.__member(POINTER_SIZE), STBTTPackRange.__member(1), STBTTPackRange.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FONT_SIZE = layout.offsetof(0);
        FIRST_UNICODE_CODEPOINT_IN_RANGE = layout.offsetof(1);
        ARRAY_OF_UNICODE_CODEPOINTS = layout.offsetof(2);
        NUM_CHARS = layout.offsetof(3);
        CHARDATA_FOR_RANGE = layout.offsetof(4);
        H_OVERSAMPLE = layout.offsetof(5);
        V_OVERSAMPLE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<STBTTPackRange, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected STBTTPackRange newInstance(long address) {
            return new STBTTPackRange(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        public float font_size() {
            return STBTTPackRange.nfont_size(this.address());
        }

        public int first_unicode_codepoint_in_range() {
            return STBTTPackRange.nfirst_unicode_codepoint_in_range(this.address());
        }

        @NativeType(value="int *")
        public IntBuffer array_of_unicode_codepoints() {
            return STBTTPackRange.narray_of_unicode_codepoints(this.address());
        }

        public int num_chars() {
            return STBTTPackRange.nnum_chars(this.address());
        }

        @NativeType(value="stbtt_packedchar *")
        public STBTTPackedchar.Buffer chardata_for_range() {
            return STBTTPackRange.nchardata_for_range(this.address());
        }

        public Buffer font_size(float value) {
            STBTTPackRange.nfont_size(this.address(), value);
            return this;
        }

        public Buffer first_unicode_codepoint_in_range(int value) {
            STBTTPackRange.nfirst_unicode_codepoint_in_range(this.address(), value);
            return this;
        }

        public Buffer array_of_unicode_codepoints(@NativeType(value="int *") IntBuffer value) {
            STBTTPackRange.narray_of_unicode_codepoints(this.address(), value);
            return this;
        }

        public Buffer num_chars(int value) {
            STBTTPackRange.nnum_chars(this.address(), value);
            return this;
        }

        public Buffer chardata_for_range(@NativeType(value="stbtt_packedchar *") STBTTPackedchar.Buffer value) {
            STBTTPackRange.nchardata_for_range(this.address(), value);
            return this;
        }
    }
}

