/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.windows.POINT;
import org.lwjgl.system.windows.RECT;

public class WINDOWPLACEMENT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LENGTH;
    public static final int FLAGS;
    public static final int SHOWCMD;
    public static final int PTMINPOSITION;
    public static final int PTMAXPOSITION;
    public static final int RCNORMALPOSITION;

    WINDOWPLACEMENT(long address, ByteBuffer container) {
        super(address, container);
    }

    public WINDOWPLACEMENT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), WINDOWPLACEMENT.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="UINT")
    public int length() {
        return WINDOWPLACEMENT.nlength(this.address());
    }

    @NativeType(value="UINT")
    public int flags() {
        return WINDOWPLACEMENT.nflags(this.address());
    }

    @NativeType(value="UINT")
    public int showCmd() {
        return WINDOWPLACEMENT.nshowCmd(this.address());
    }

    public POINT ptMinPosition() {
        return WINDOWPLACEMENT.nptMinPosition(this.address());
    }

    public POINT ptMaxPosition() {
        return WINDOWPLACEMENT.nptMaxPosition(this.address());
    }

    public RECT rcNormalPosition() {
        return WINDOWPLACEMENT.nrcNormalPosition(this.address());
    }

    public WINDOWPLACEMENT length(@NativeType(value="UINT") int value) {
        WINDOWPLACEMENT.nlength(this.address(), value);
        return this;
    }

    public WINDOWPLACEMENT flags(@NativeType(value="UINT") int value) {
        WINDOWPLACEMENT.nflags(this.address(), value);
        return this;
    }

    public WINDOWPLACEMENT showCmd(@NativeType(value="UINT") int value) {
        WINDOWPLACEMENT.nshowCmd(this.address(), value);
        return this;
    }

    public WINDOWPLACEMENT ptMinPosition(POINT value) {
        WINDOWPLACEMENT.nptMinPosition(this.address(), value);
        return this;
    }

    public WINDOWPLACEMENT ptMaxPosition(POINT value) {
        WINDOWPLACEMENT.nptMaxPosition(this.address(), value);
        return this;
    }

    public WINDOWPLACEMENT rcNormalPosition(RECT value) {
        WINDOWPLACEMENT.nrcNormalPosition(this.address(), value);
        return this;
    }

    public WINDOWPLACEMENT set(int length, int flags, int showCmd, POINT ptMinPosition, POINT ptMaxPosition, RECT rcNormalPosition) {
        this.length(length);
        this.flags(flags);
        this.showCmd(showCmd);
        this.ptMinPosition(ptMinPosition);
        this.ptMaxPosition(ptMaxPosition);
        this.rcNormalPosition(rcNormalPosition);
        return this;
    }

    public WINDOWPLACEMENT set(WINDOWPLACEMENT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static WINDOWPLACEMENT malloc() {
        return WINDOWPLACEMENT.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static WINDOWPLACEMENT calloc() {
        return WINDOWPLACEMENT.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static WINDOWPLACEMENT create() {
        return new WINDOWPLACEMENT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static WINDOWPLACEMENT create(long address) {
        return address == 0L ? null : new WINDOWPLACEMENT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return WINDOWPLACEMENT.create(WINDOWPLACEMENT.__malloc(capacity, SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return WINDOWPLACEMENT.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(WINDOWPLACEMENT.__create(capacity, SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static WINDOWPLACEMENT mallocStack() {
        return WINDOWPLACEMENT.mallocStack(MemoryStack.stackGet());
    }

    public static WINDOWPLACEMENT callocStack() {
        return WINDOWPLACEMENT.callocStack(MemoryStack.stackGet());
    }

    public static WINDOWPLACEMENT mallocStack(MemoryStack stack) {
        return WINDOWPLACEMENT.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static WINDOWPLACEMENT callocStack(MemoryStack stack) {
        return WINDOWPLACEMENT.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return WINDOWPLACEMENT.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return WINDOWPLACEMENT.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return WINDOWPLACEMENT.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return WINDOWPLACEMENT.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LENGTH);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nshowCmd(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHOWCMD);
    }

    public static POINT nptMinPosition(long struct) {
        return POINT.create(struct + (long)PTMINPOSITION);
    }

    public static POINT nptMaxPosition(long struct) {
        return POINT.create(struct + (long)PTMAXPOSITION);
    }

    public static RECT nrcNormalPosition(long struct) {
        return RECT.create(struct + (long)RCNORMALPOSITION);
    }

    public static void nlength(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LENGTH, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nshowCmd(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHOWCMD, value);
    }

    public static void nptMinPosition(long struct, POINT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PTMINPOSITION, POINT.SIZEOF);
    }

    public static void nptMaxPosition(long struct, POINT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)PTMAXPOSITION, POINT.SIZEOF);
    }

    public static void nrcNormalPosition(long struct, RECT value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RCNORMALPOSITION, RECT.SIZEOF);
    }

    static {
        Struct.Layout layout = WINDOWPLACEMENT.__struct(WINDOWPLACEMENT.__member(4), WINDOWPLACEMENT.__member(4), WINDOWPLACEMENT.__member(4), WINDOWPLACEMENT.__member(POINT.SIZEOF, POINT.ALIGNOF), WINDOWPLACEMENT.__member(POINT.SIZEOF, POINT.ALIGNOF), WINDOWPLACEMENT.__member(RECT.SIZEOF, RECT.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LENGTH = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        SHOWCMD = layout.offsetof(2);
        PTMINPOSITION = layout.offsetof(3);
        PTMAXPOSITION = layout.offsetof(4);
        RCNORMALPOSITION = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<WINDOWPLACEMENT, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected WINDOWPLACEMENT newInstance(long address) {
            return new WINDOWPLACEMENT(address, this.container);
        }

        @Override
        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="UINT")
        public int length() {
            return WINDOWPLACEMENT.nlength(this.address());
        }

        @NativeType(value="UINT")
        public int flags() {
            return WINDOWPLACEMENT.nflags(this.address());
        }

        @NativeType(value="UINT")
        public int showCmd() {
            return WINDOWPLACEMENT.nshowCmd(this.address());
        }

        public POINT ptMinPosition() {
            return WINDOWPLACEMENT.nptMinPosition(this.address());
        }

        public POINT ptMaxPosition() {
            return WINDOWPLACEMENT.nptMaxPosition(this.address());
        }

        public RECT rcNormalPosition() {
            return WINDOWPLACEMENT.nrcNormalPosition(this.address());
        }

        public Buffer length(@NativeType(value="UINT") int value) {
            WINDOWPLACEMENT.nlength(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="UINT") int value) {
            WINDOWPLACEMENT.nflags(this.address(), value);
            return this;
        }

        public Buffer showCmd(@NativeType(value="UINT") int value) {
            WINDOWPLACEMENT.nshowCmd(this.address(), value);
            return this;
        }

        public Buffer ptMinPosition(POINT value) {
            WINDOWPLACEMENT.nptMinPosition(this.address(), value);
            return this;
        }

        public Buffer ptMaxPosition(POINT value) {
            WINDOWPLACEMENT.nptMaxPosition(this.address(), value);
            return this;
        }

        public Buffer rcNormalPosition(RECT value) {
            WINDOWPLACEMENT.nrcNormalPosition(this.address(), value);
            return this;
        }
    }
}

