/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.color;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorLABa;
import org.openrndr.color.ColorLSHABa;
import org.openrndr.color.ColorRGBa;
import org.openrndr.color.ColorXYZa;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 -2\u00020\u0001:\u0001-B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\t\u0010*\u001a\u00020+H\u00d6\u0001J\u0006\u0010,\u001a\u00020\bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006."}, d2={"Lorg/openrndr/color/ColorLCHABa;", "", "l", "", "c", "h", "alpha", "ref", "Lorg/openrndr/color/ColorXYZa;", "(DDDDLorg/openrndr/color/ColorXYZa;)V", "getAlpha", "()D", "getC", "getH", "getL", "getRef", "()Lorg/openrndr/color/ColorXYZa;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "scaleChroma", "scale", "scaleHue", "scaleLuminosity", "shiftChroma", "shift", "shiftHue", "shiftLuminosity", "toLABa", "Lorg/openrndr/color/ColorLABa;", "toLSHABa", "Lorg/openrndr/color/ColorLSHABa;", "toRGBa", "Lorg/openrndr/color/ColorRGBa;", "toString", "", "toXYZa", "Companion", "openrndr-color"})
public final class ColorLCHABa {
    private final double l;
    private final double c;
    private final double h;
    private final double alpha;
    @NotNull
    private final ColorXYZa ref;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ColorLCHABa scaleHue(double scale) {
        return ColorLCHABa.copy$default(this, 0.0, 0.0, this.h * scale, 0.0, null, 27, null);
    }

    @NotNull
    public final ColorLCHABa shiftHue(double shift) {
        return ColorLCHABa.copy$default(this, 0.0, 0.0, this.h + shift, 0.0, null, 27, null);
    }

    @NotNull
    public final ColorLCHABa scaleLuminosity(double scale) {
        return ColorLCHABa.copy$default(this, this.l * scale, 0.0, 0.0, 0.0, null, 30, null);
    }

    @NotNull
    public final ColorLCHABa shiftLuminosity(double shift) {
        return ColorLCHABa.copy$default(this, this.l + shift, 0.0, 0.0, 0.0, null, 30, null);
    }

    @NotNull
    public final ColorLCHABa shiftChroma(double shift) {
        return ColorLCHABa.copy$default(this, 0.0, this.c + shift, 0.0, 0.0, null, 29, null);
    }

    @NotNull
    public final ColorLCHABa scaleChroma(double scale) {
        return ColorLCHABa.copy$default(this, 0.0, this.c * scale, 0.0, 0.0, null, 29, null);
    }

    @NotNull
    public final ColorLABa toLABa() {
        double a = this.c * Math.cos(Math.toRadians(this.h));
        double b = this.c * Math.sin(Math.toRadians(this.h));
        return new ColorLABa(this.l, a, b, this.alpha, this.ref);
    }

    @NotNull
    public final ColorXYZa toXYZa() {
        return this.toLABa().toXYZa();
    }

    @NotNull
    public final ColorRGBa toRGBa() {
        return this.toLABa().toXYZa().toRGBa();
    }

    @NotNull
    public final ColorLSHABa toLSHABa() {
        return ColorLSHABa.Companion.fromLCHABa(this);
    }

    public final double getL() {
        return this.l;
    }

    public final double getC() {
        return this.c;
    }

    public final double getH() {
        return this.h;
    }

    public final double getAlpha() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa getRef() {
        return this.ref;
    }

    public ColorLCHABa(double l, double c, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        this.l = l;
        this.c = c;
        this.h = h;
        this.alpha = alpha;
        this.ref = ref;
    }

    public /* synthetic */ ColorLCHABa(double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d4 = 1.0;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = ColorXYZa.Companion.getNEUTRAL();
        }
        this(d, d2, d3, d4, colorXYZa);
    }

    public final double component1() {
        return this.l;
    }

    public final double component2() {
        return this.c;
    }

    public final double component3() {
        return this.h;
    }

    public final double component4() {
        return this.alpha;
    }

    @NotNull
    public final ColorXYZa component5() {
        return this.ref;
    }

    @NotNull
    public final ColorLCHABa copy(double l, double c, double h, double alpha, @NotNull ColorXYZa ref) {
        Intrinsics.checkParameterIsNotNull(ref, "ref");
        return new ColorLCHABa(l, c, h, alpha, ref);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ColorLCHABa copy$default(ColorLCHABa colorLCHABa, double d, double d2, double d3, double d4, ColorXYZa colorXYZa, int n, Object object) {
        if ((n & 1) != 0) {
            d = colorLCHABa.l;
        }
        if ((n & 2) != 0) {
            d2 = colorLCHABa.c;
        }
        if ((n & 4) != 0) {
            d3 = colorLCHABa.h;
        }
        if ((n & 8) != 0) {
            d4 = colorLCHABa.alpha;
        }
        if ((n & 0x10) != 0) {
            colorXYZa = colorLCHABa.ref;
        }
        return colorLCHABa.copy(d, d2, d3, d4, colorXYZa);
    }

    public String toString() {
        return "ColorLCHABa(l=" + this.l + ", c=" + this.c + ", h=" + this.h + ", alpha=" + this.alpha + ", ref=" + this.ref + ")";
    }

    public int hashCode() {
        ColorXYZa colorXYZa = this.ref;
        return (((Double.hashCode(this.l) * 31 + Double.hashCode(this.c)) * 31 + Double.hashCode(this.h)) * 31 + Double.hashCode(this.alpha)) * 31 + (colorXYZa != null ? ((Object)colorXYZa).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ColorLCHABa)) break block3;
                ColorLCHABa colorLCHABa = (ColorLCHABa)object;
                if (Double.compare(this.l, colorLCHABa.l) != 0 || Double.compare(this.c, colorLCHABa.c) != 0 || Double.compare(this.h, colorLCHABa.h) != 0 || Double.compare(this.alpha, colorLCHABa.alpha) != 0 || !Intrinsics.areEqual(this.ref, colorLCHABa.ref)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/openrndr/color/ColorLCHABa$Companion;", "", "()V", "findMaxChroma", "", "l", "h", "ref", "Lorg/openrndr/color/ColorXYZa;", "fromLABa", "Lorg/openrndr/color/ColorLCHABa;", "laba", "Lorg/openrndr/color/ColorLABa;", "openrndr-color"})
    public static final class Companion {
        public final double findMaxChroma(double l, double h, @NotNull ColorXYZa ref) {
            boolean rightValid;
            boolean middleValid;
            boolean leftValid;
            Intrinsics.checkParameterIsNotNull(ref, "ref");
            double left = 0.0;
            double right = 2000.0;
            double bestGuess = left;
            do {
                double newRight;
                if (right - left < 1.0E-4) {
                    return bestGuess;
                }
                ColorLCHABa leftTry = new ColorLCHABa(l, left, h, 1.0, ref);
                ColorLCHABa rightTry = new ColorLCHABa(l, right, h, 1.0, ref);
                double middle = (left + right) / (double)2;
                ColorLCHABa middleTry = new ColorLCHABa(l, middle, h, 1.0, ref);
                ColorRGBa colorRGBa = leftTry.toRGBa();
                ColorRGBa it = colorRGBa;
                leftValid = it.getMinValue() >= 0.0 && it.getMaxValue() <= 1.0;
                ColorRGBa it2 = it = rightTry.toRGBa();
                rightValid = it2.getMinValue() >= 0.0 && it2.getMaxValue() <= 1.0;
                ColorRGBa it3 = it2 = middleTry.toRGBa();
                boolean bl = middleValid = it3.getMinValue() >= 0.0 && it3.getMaxValue() <= 1.0;
                if (leftValid && middleValid && !rightValid) {
                    double newLeft = middle;
                    newRight = right;
                    bestGuess = middle;
                    left = newLeft;
                    right = newRight;
                }
                if (!leftValid || middleValid || rightValid) continue;
                double newLeft = left;
                newRight = middle;
                left = newLeft;
                right = newRight;
            } while (leftValid != middleValid || middleValid != rightValid);
            return bestGuess;
        }

        @NotNull
        public final ColorLCHABa fromLABa(@NotNull ColorLABa laba) {
            Intrinsics.checkParameterIsNotNull(laba, "laba");
            double l = laba.getL();
            double c = Math.sqrt(laba.getA() * laba.getA() + laba.getB() * laba.getB());
            double h = Math.atan2(laba.getB(), laba.getA());
            if (h < 0.0) {
                h += Math.PI * 2;
            }
            h = Math.toDegrees(h);
            return new ColorLCHABa(l, c, h, laba.getAlpha(), laba.getRef());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

