/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.FontMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u0016\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J0\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J0\u0010 \u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\"\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lorg/openrndr/internal/FontImageMapDrawer;", "", "()V", "quads", "", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "getShaderManager", "()Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "Lorg/openrndr/draw/VertexBuffer;", "getVertices", "()Lorg/openrndr/draw/VertexBuffer;", "drawText", "", "context", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "text", "", "x", "", "y", "flush", "insertCharacterQuad", "fontMap", "Lorg/openrndr/draw/FontImageMap;", "bw", "Lorg/openrndr/draw/BufferWriter;", "character", "", "queueText", "Lorg/openrndr/draw/FontMap;", "tracking", "openrndr-core"})
public final class FontImageMapDrawer {
    @NotNull
    private final ShadeStyleManager shaderManager;
    @NotNull
    private final VertexBuffer vertices;
    private int quads;

    @NotNull
    public final ShadeStyleManager getShaderManager() {
        return this.shaderManager;
    }

    @NotNull
    public final VertexBuffer getVertices() {
        return this.vertices;
    }

    public final void drawText(@NotNull DrawContext context, @NotNull DrawStyle drawStyle, @NotNull String text2, double x, double y) {
        block3: {
            CharSequence $receiver$iv;
            FontImageMap fontImageMap;
            Intrinsics.checkParameterIsNotNull(context, "context");
            Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
            Intrinsics.checkParameterIsNotNull(text2, "text");
            FontMap fontMap = drawStyle.getFontMap();
            if (!(fontMap instanceof FontImageMap)) {
                fontMap = null;
            }
            FontImageMap fontImageMap2 = (FontImageMap)fontMap;
            if (fontImageMap2 == null) break block3;
            FontImageMap fontMap2 = fontImageMap = fontImageMap2;
            double cursorX = 0.0;
            double cursorY = 0.0;
            BufferWriter bw = this.vertices.getShadow().writer();
            bw.setPosition(this.vertices.getVertexFormat().getSize() * this.quads * 6);
            CharSequence charSequence = $receiver$iv = (CharSequence)text2;
            for (int i = 0; i < charSequence.length(); ++i) {
                GlyphMetrics metrics;
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                if (fontMap2.getGlyphMetrics().get(Character.valueOf(it)) == null) {
                    Intrinsics.throwNpe();
                }
                this.insertCharacterQuad(fontMap2, bw, it, x + cursorX + metrics.getLeftSideBearing(), y + cursorY + metrics.getYBitmapShift());
                cursorX += metrics.getAdvanceWidth();
            }
            this.flush(context, drawStyle);
        }
    }

    public final void queueText(@NotNull FontMap fontMap, @NotNull String text2, double x, double y, double tracking) {
        CharSequence $receiver$iv;
        Intrinsics.checkParameterIsNotNull(fontMap, "fontMap");
        Intrinsics.checkParameterIsNotNull(text2, "text");
        BufferWriter bw = this.vertices.getShadow().writer();
        bw.setPosition(this.vertices.getVertexFormat().getSize() * this.quads * 6);
        FontImageMap cfr_ignored_0 = (FontImageMap)fontMap;
        double cursorX = 0.0;
        double cursorY = 0.0;
        CharSequence charSequence = $receiver$iv = (CharSequence)text2;
        for (int i = 0; i < charSequence.length(); ++i) {
            GlyphMetrics glyphMetrics;
            char element$iv;
            char it = element$iv = charSequence.charAt(i);
            GlyphMetrics metrics = ((FontImageMap)fontMap).getGlyphMetrics().get(Character.valueOf(it));
            if (metrics == null) continue;
            GlyphMetrics metrics2 = glyphMetrics;
            this.insertCharacterQuad((FontImageMap)fontMap, bw, it, x + cursorX + metrics2.getLeftSideBearing(), y + cursorY + metrics2.getYBitmapShift());
            cursorX += metrics2.getAdvanceWidth() + tracking;
        }
    }

    public static /* bridge */ /* synthetic */ void queueText$default(FontImageMapDrawer fontImageMapDrawer, FontMap fontMap, String string, double d, double d2, double d3, int n, Object object) {
        if ((n & 0x10) != 0) {
            d3 = 0.0;
        }
        fontImageMapDrawer.queueText(fontMap, string, d, d2, d3);
    }

    public final void flush(@NotNull DrawContext context, @NotNull DrawStyle drawStyle) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        if (this.quads > 0) {
            this.vertices.getShadow().uploadElements(0, this.quads * 6);
            Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
            shader2.begin();
            context.applyToShader(shader2);
            Driver.Companion.getInstance().setState(drawStyle);
            drawStyle.applyToShader(shader2);
            FontMap fontMap = drawStyle.getFontMap();
            if (fontMap == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrndr.draw.FontImageMap");
            }
            ((FontImageMap)fontMap).getTexture().bind(0);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.vertices), DrawPrimitive.TRIANGLES, 0, this.quads * 6);
            shader2.end();
            this.quads = 0;
        }
    }

    private final void insertCharacterQuad(FontImageMap fontMap, BufferWriter bw, char character, double x, double y) {
        BufferWriter bufferWriter;
        IntRectangle intRectangle = fontMap.getMap().get(Character.valueOf(character));
        if (intRectangle == null) {
            Intrinsics.throwNpe();
        }
        IntRectangle rectangle = intRectangle;
        float pad = 1.0f;
        float u0 = ((float)rectangle.getX() - pad) / (float)fontMap.getTexture().getWidth();
        float u1 = u0 + (1.0f + pad * (float)2 + (float)rectangle.getWidth()) / (float)fontMap.getTexture().getWidth();
        float v0 = ((float)rectangle.getY() - pad) / (float)fontMap.getTexture().getHeight();
        float v1 = v0 + (1.0f + pad * (float)2 + (float)rectangle.getHeight()) / (float)fontMap.getTexture().getHeight();
        float x0 = (float)x - pad;
        float x1 = x0 + (float)rectangle.getWidth() / (float)fontMap.getContentScale() + pad * (float)2;
        float y0 = (float)y - pad;
        float y1 = y0 + (float)rectangle.getHeight() / (float)fontMap.getContentScale() + pad * (float)2;
        float s0 = 0.0f;
        float t0 = 0.0f;
        float s1 = 1.0f;
        float t1 = 1.0f;
        float w = x1 - x0;
        float h = y1 - y0;
        float z = this.quads;
        BufferWriter $receiver = bufferWriter = bw;
        $receiver.write(u0, v0);
        $receiver.write(s0, t0, w, h);
        $receiver.write(x0, y0, z);
        $receiver.write(u1, v0);
        $receiver.write(s1, t0, w, h);
        $receiver.write(x1, y0, z);
        $receiver.write(u1, v1);
        $receiver.write(s1, t1, w, h);
        $receiver.write(x1, y1, z);
        $receiver.write(u0, v0);
        $receiver.write(s0, t0, w, h);
        $receiver.write(x0, y0, z);
        $receiver.write(u0, v1);
        $receiver.write(s0, t1, w, h);
        $receiver.write(x0, y1, z);
        $receiver.write(u1, v1);
        $receiver.write(s1, t1, w, h);
        $receiver.write(x1, y1, z);
        int n = this.quads;
        this.quads = n + 1;
    }

    public FontImageMapDrawer() {
        String string = this.getClass().getResource("shaders/font-image-map.vert").toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull(string, "this.javaClass.getResour\u2026p.vert\").toExternalForm()");
        String string2 = this.getClass().getResource("shaders/font-image-map.frag").toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull(string2, "this.javaClass.getResour\u2026p.frag\").toExternalForm()");
        this.shaderManager = ShadeStyleManager.Companion.fromUrls(string, string2);
        VertexFormat vertexFormat = new VertexFormat();
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        FontImageMapDrawer fontImageMapDrawer = this;
        VertexFormat $receiver = vertexFormat;
        $receiver.textureCoordinate(2);
        $receiver.attribute("bounds", 4, VertexElementType.FLOAT32);
        $receiver.position(3);
        VertexFormat vertexFormat2 = vertexFormat;
        fontImageMapDrawer.vertices = companion.createDynamic(vertexFormat2, 48000);
    }
}

