/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.openrndr.binpack.IntPacker;
import org.openrndr.binpack.PackNode;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.FontImageMap;
import org.openrndr.draw.GlyphMetrics;
import org.openrndr.internal.FontMapManager;
import org.openrndr.internal.gl3.ColorBufferGL3;
import org.openrndr.internal.gl3.FontImageMapManagerGL3;
import org.openrndr.internal.gl3.FontImageMapManagerGL3Kt;
import org.openrndr.math.IntVector2;
import org.openrndr.shape.IntRectangle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/openrndr/internal/gl3/FontImageMapManagerGL3;", "Lorg/openrndr/internal/FontMapManager;", "()V", "alphabet", "", "getAlphabet", "()[C", "fontMaps", "", "", "Lorg/openrndr/draw/FontImageMap;", "getFontMaps$openrndr_gl3", "()Ljava/util/Map;", "fontMapFromUrl", "fontUrl", "size", "", "contentScale", "openrndr-gl3"})
public final class FontImageMapManagerGL3
extends FontMapManager {
    @NotNull
    private final Map<String, FontImageMap> fontMaps;
    @NotNull
    private final char[] alphabet;

    @NotNull
    public final Map<String, FontImageMap> getFontMaps$openrndr_gl3() {
        return this.fontMaps;
    }

    @NotNull
    public final char[] getAlphabet() {
        return this.alphabet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FontImageMap fontMapFromUrl(@NotNull String fontUrl, double size, double contentScale) {
        IntPacker packer;
        void packSize;
        PackNode root;
        IntBuffer py1;
        Object px1;
        void $receiver$iv$iv;
        Object object;
        void $receiver$iv$iv2;
        MemoryStack memoryStack;
        Intrinsics.checkParameterIsNotNull(fontUrl, "fontUrl");
        FontImageMapManagerGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>(contentScale){
            final /* synthetic */ double $contentScale;

            @NotNull
            public final String invoke() {
                return "content scale " + this.$contentScale;
            }
            {
                this.$contentScale = d;
                super(0);
            }
        });
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 256;
        URL url = new URL(fontUrl);
        byte[] byteArray = new byte[0xA00000];
        int fileSize = 0;
        Closeable closeable = url.openStream();
        Throwable throwable = null;
        try {
            Object it = (InputStream)closeable;
            while (((InputStream)it).available() > 0) {
                int a = ((InputStream)it).available();
                ((InputStream)it).read(byteArray, fileSize, a);
                fileSize += a;
            }
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        ByteBuffer bb = BufferUtils.createByteBuffer(fileSize);
        bb.order(ByteOrder.nativeOrder());
        bb.rewind();
        bb.put(byteArray, 0, fileSize);
        bb.rewind();
        STBTTFontinfo info = STBTTFontinfo.create();
        boolean status = STBTruetype.stbtt_InitFont(info, bb);
        if (!status) {
            throw (Throwable)new RuntimeException("font error");
        }
        float scale = STBTruetype.stbtt_ScaleForPixelHeight(info, (float)(size * contentScale));
        double ascent = 0.0;
        double descent = 0.0;
        double lineGap = 0.0;
        MemoryStack it = memoryStack = MemoryStack.stackPush();
        IntBuffer pAscent = it.mallocInt(1);
        Object pDescent = it.mallocInt(1);
        IntBuffer pLineGap = it.mallocInt(1);
        STBTruetype.stbtt_GetFontVMetrics(info, pAscent, (IntBuffer)pDescent, pLineGap);
        ascent = (double)((float)pAscent.get(0) * scale) * 1.0;
        descent = (double)((float)((IntBuffer)pDescent).get(0) * scale) * 1.0;
        lineGap = (double)((float)pLineGap.get(0) * scale) * 1.0;
        char[] $receiver$iv = this.alphabet;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($receiver$iv.length), 16);
        pDescent = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (int element$iv$iv : $receiver$iv$iv2) {
            Map map = destination$iv$iv;
            void it2 = element$iv$iv;
            object = new Pair<Character, Integer>(Character.valueOf((char)it2), STBTruetype.stbtt_FindGlyphIndex(info, (int)it2));
            map.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
        }
        Map glyphIndices = destination$iv$iv;
        char[] $receiver$iv2 = this.alphabet;
        int capacity$iv2 = RangesKt.coerceAtLeast(MapsKt.mapCapacity($receiver$iv2.length), 16);
        destination$iv$iv = $receiver$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        for (void element$iv$iv : $receiver$iv$iv) {
            Map it2 = destination$iv$iv2;
            void c = element$iv$iv;
            object = MemoryStack.stackPush();
            Throwable $i$f$associateTo = null;
            try {
                Object it3 = (MemoryStack)object;
                IntBuffer px0 = ((MemoryStack)it3).mallocInt(1);
                IntBuffer py0 = ((MemoryStack)it3).mallocInt(1);
                px1 = ((MemoryStack)it3).mallocInt(1);
                py1 = ((MemoryStack)it3).mallocInt(1);
                Object v = glyphIndices.get(Character.valueOf((char)c));
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel(info, ((Number)v).intValue(), scale, scale, 0.0f, 0.0f, px0, py0, (IntBuffer)px1, py1);
                it3 = new Pair<Character, IntVector2>(Character.valueOf((char)c), new IntVector2(((IntBuffer)px1).get() - px0.get(), py1.get() - py0.get()));
            }
            catch (Throwable it3) {
                $i$f$associateTo = it3;
                throw it3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, $i$f$associateTo);
            }
            Object object2 = it3;
            it2.put(((Pair)object2).getFirst(), ((Pair)object2).getSecond());
        }
        Map glyphDimensions = destination$iv$iv2;
        int sanding = 3;
        while (!FontImageMapManagerGL3Kt.attemptPack(root = new PackNode(new IntRectangle(0, 0, packSize.element, packSize.element), null, 2, null), packer = new IntPacker(null, null, null, 7, null), glyphDimensions, sanding)) {
            packSize.element *= 2;
        }
        FontImageMapManagerGL3Kt.access$getLogger$p().debug((Function0<? extends Object>)new Function0<String>((Ref.IntRef)packSize){
            final /* synthetic */ Ref.IntRef $packSize;

            @NotNull
            public final String invoke() {
                return "final map size " + this.$packSize.element + 'x' + this.$packSize.element;
            }
            {
                this.$packSize = intRef;
                super(0);
            }
        });
        ColorBuffer image = ColorBuffer.Companion.create$default(ColorBuffer.Companion, packSize.element, packSize.element, ColorFormat.R, null, 8, null);
        Map map = new LinkedHashMap();
        PackNode root2 = new PackNode(new IntRectangle(0, 0, packSize.element, packSize.element), null, 2, null);
        IntPacker packer2 = new IntPacker(null, null, null, 7, null);
        Map glyphMetrics = new LinkedHashMap();
        ByteBuffer bitmap = BufferUtils.createByteBuffer(packSize.element * packSize.element);
        FontImageMapManagerGL3Kt.access$getLogger$p().debug(fontMapFromUrl.5.INSTANCE);
        Iterable $receiver$iv3 = glyphDimensions.entrySet();
        Iterable iterable = $receiver$iv3;
        object = new Comparator<T>(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                Comparable comparable = Integer.valueOf(((IntVector2)it.getValue()).getSquaredLength());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                Integer n = ((IntVector2)it.getValue()).getSquaredLength();
                return ComparisonsKt.compareValues(comparable2, (Comparable)n);
            }
        };
        $receiver$iv3 = CollectionsKt.sortedWith(iterable, object);
        for (Object element$iv : $receiver$iv3) {
            Unit unit;
            Map.Entry it4 = (Map.Entry)element$iv;
            PackNode target = IntPacker.insert$default(packer2, root2, new IntRectangle(0, 0, ((IntVector2)it4.getValue()).getX() + 2 * sanding, ((IntVector2)it4.getValue()).getY() + 2 * sanding), null, 4, null);
            if (target != null) {
                Object object3;
                PackNode packNode;
                PackNode t = packNode;
                px1 = map;
                py1 = it4.getKey();
                IntRectangle $i$a$1$use = new IntRectangle(t.getArea().getX() + sanding - 1, t.getArea().getY() + sanding - 1, t.getArea().getWidth() - 2 * sanding + 2, t.getArea().getHeight() - 2 * sanding + 2);
                px1.put(py1, $i$a$1$use);
                Object v = glyphIndices.get(it4.getKey());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                int glyphIndex = ((Number)v).intValue();
                int advanceWidth = 0;
                int leftBearing = 0;
                AutoCloseable $i$a$1$associate = MemoryStack.stackPush();
                Throwable throwable2 = null;
                try {
                    Object stack = (MemoryStack)$i$a$1$associate;
                    IntBuffer pAdvanceWidth = ((MemoryStack)stack).mallocInt(1);
                    IntBuffer pLeftBearing = ((MemoryStack)stack).mallocInt(1);
                    STBTruetype.stbtt_GetGlyphHMetrics(info, glyphIndex, pAdvanceWidth, pLeftBearing);
                    advanceWidth = pAdvanceWidth.get(0);
                    leftBearing = pLeftBearing.get(0);
                    stack = Unit.INSTANCE;
                }
                catch (Throwable stack) {
                    throwable2 = stack;
                    throw stack;
                }
                finally {
                    AutoCloseableKt.closeFinally($i$a$1$associate, throwable2);
                }
                int x0 = 0;
                int y0 = 0;
                int x1 = 0;
                int y1 = 0;
                AutoCloseable autoCloseable = MemoryStack.stackPush();
                Throwable throwable3 = null;
                try {
                    MemoryStack stack = (MemoryStack)autoCloseable;
                    IntBuffer px0 = stack.mallocInt(1);
                    IntBuffer py0 = stack.mallocInt(1);
                    IntBuffer px12 = stack.mallocInt(1);
                    IntBuffer py12 = stack.mallocInt(1);
                    STBTruetype.stbtt_GetGlyphBitmapBoxSubpixel(info, glyphIndex, scale, scale, 0.0f, 0.0f, px0, py0, px12, py12);
                    x0 = px0.get(0);
                    y0 = py0.get(0);
                    x1 = px12.get(0);
                    y1 = py12.get(0);
                    object3 = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable3);
                }
                double ascale = (double)scale / contentScale;
                object3 = glyphMetrics;
                Object k = it4.getKey();
                GlyphMetrics glyphMetrics2 = new GlyphMetrics((double)advanceWidth * ascale, (double)leftBearing * ascale, x0, y0);
                object3.put(k, glyphMetrics2);
                bitmap.rewind();
                bitmap.position((sanding + t.getArea().getY()) * packSize.element + sanding + t.getArea().getX());
                STBTruetype.stbtt_MakeGlyphBitmapSubpixel(info, bitmap, x1 - x0, y1 - y0, packSize.element, scale, scale, 0.0f, 0.0f, glyphIndex);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        FontImageMapManagerGL3Kt.access$getLogger$p().debug(fontMapFromUrl.8.INSTANCE);
        ColorBuffer colorBuffer = image;
        if (colorBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.openrndr.internal.gl3.ColorBufferGL3");
        }
        ColorBufferGL3 cfr_ignored_0 = (ColorBufferGL3)colorBuffer;
        bitmap.rewind();
        ColorBufferGL3 colorBufferGL3 = (ColorBufferGL3)image;
        ByteBuffer byteBuffer = bitmap;
        Intrinsics.checkExpressionValueIsNotNull(byteBuffer, "bitmap");
        colorBufferGL3.write(byteBuffer);
        double leading = ascent - descent + lineGap;
        return new FontImageMap(image, map, glyphMetrics, size, contentScale, ascent / contentScale, descent / contentScale, (ascent + descent) / contentScale, leading / contentScale, "test");
    }

    public FontImageMapManagerGL3() {
        Map map;
        FontImageMapManagerGL3 fontImageMapManagerGL3 = this;
        fontImageMapManagerGL3.fontMaps = map = (Map)new LinkedHashMap();
        this.alphabet = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00eb', '\u00e4', '\u00f6', '\u00fc', '\u00ef', '\u00ff', '\u00cb', '\u00c4', '\u00d6', '\u00dc', '\u00cf', '\u0178', '\u00f1', '\u00d1', '\u00e7', '\u00c7', '\u00f8', '\u00d8', '\u00e9', '\u00e1', '\u00f3', '\u00ed', '\u00fa', '\u00c9', '\u00c1', '\u00d3', '\u00cd', '\u00da', '\u00e8', '\u00e0', '\u00f2', '\u00ec', '\u00f9', '\u00c8', '\u00c0', '\u00d2', '\u00cc', '\u00d9', '\u00e2', '\u00ea', '\u00ee', '\u00fb', '\u00f4', '\u00c2', '\u00ca', '\u00ce', '\u00db', '\u00d4', '\u0153', '\u0152', '\u00e6', '\u00c6', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '!', '?', '\u00bf', '\u00a1', '\u2026', '.', ',', ' ', ':', ';', '&', '#', '\u2116', '\u201c', '\u201d', '\u2018', '\u2019', '`', '\u00a4', '\u20ac', '$', '\u00a3', '\u2012', '-', '\u2014', '\u2013', '_', '\u00b7', '\u2022', '\u00b0', '@', '^', '*', '\u00ab', '\u00bb', '/', '\\', '\"', '\'', '+', '=', '\u00f7', '~', '%', '(', ')', '[', ']', '{', '}', '<', '>', '|'};
    }
}

