/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.openrndr.internal.gl3.ShaderGL3Kt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"logger", "Lmu/KLogger;", "checkProgramInfoLog", "", "object", "", "sourceFile", "", "checkShaderInfoLog", "code", "openrndr-gl3"})
public final class ShaderGL3Kt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void checkShaderInfoLog(int object, @NotNull String code, @NotNull String sourceFile) {
        Intrinsics.checkParameterIsNotNull(code, "code");
        Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
        logger.debug(checkShaderInfoLog.1.INSTANCE);
        int[] logLength = new int[1];
        GL20.glGetShaderiv(object, 35716, logLength);
        logger.debug((Function0<? extends Object>)new Function0<String>(logLength){
            final /* synthetic */ int[] $logLength;

            @NotNull
            public final String invoke() {
                return "log length: " + this.$logLength[0];
            }
            {
                this.$logLength = nArray;
                super(0);
            }
        });
        if (logLength[0] > 0) {
            logger.debug(checkShaderInfoLog.3.INSTANCE);
            ByteBuffer infoLog = BufferUtils.createByteBuffer(logLength[0]);
            infoLog.rewind();
            GL20.glGetShaderInfoLog(object, logLength, infoLog);
            byte[] infoBytes = new byte[logLength[0]];
            infoLog.get(infoBytes);
            StringBuilder stringBuilder = new StringBuilder().append("GLSL compilation problems in\n ");
            String string = new String(infoBytes, Charsets.UTF_8);
            String string2 = stringBuilder.append(string).toString();
            System.out.println((Object)string2);
            File temp = File.createTempFile("rndr", ".fs");
            Closeable closeable = new FileWriter(temp);
            Throwable throwable = null;
            try {
                FileWriter it = (FileWriter)closeable;
                it.write(code);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            StringBuilder stringBuilder2 = new StringBuilder().append("at unknown.shader(");
            File file = temp;
            Intrinsics.checkExpressionValueIsNotNull(file, "temp");
            System.err.println(stringBuilder2.append(file.getAbsolutePath()).append(":1)").toString());
            logger.error((Function0<? extends Object>)new Function0<String>(sourceFile){
                final /* synthetic */ String $sourceFile;

                @NotNull
                public final String invoke() {
                    return "GLSL shader compilation failed for " + this.$sourceFile;
                }
                {
                    this.$sourceFile = string;
                    super(0);
                }
            });
            throw (Throwable)new Exception("Shader error: " + sourceFile);
        }
    }

    public static final void checkProgramInfoLog(int object, @NotNull String sourceFile) {
        Intrinsics.checkParameterIsNotNull(sourceFile, "sourceFile");
        int[] logLength = new int[1];
        GL20.glGetProgramiv(object, 35716, logLength);
        if (logLength[0] > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer(logLength[0]);
            GL20.glGetProgramInfoLog(object, logLength, infoLog);
            byte[] infoBytes = new byte[logLength[0]];
            infoLog.get(infoBytes);
            StringBuilder stringBuilder = new StringBuilder().append("GLSL link problems in\n ");
            String string = new String(infoBytes, Charsets.UTF_8);
            String string2 = stringBuilder.append(string).toString();
            System.out.println((Object)string2);
            logger.warn((Function0<? extends Object>)new Function0<String>(logLength, infoLog){
                final /* synthetic */ int[] $logLength;
                final /* synthetic */ ByteBuffer $infoLog;

                @NotNull
                public final String invoke() {
                    byte[] infoBytes = new byte[this.$logLength[0]];
                    this.$infoLog.get(infoBytes);
                    StringBuilder stringBuilder = new StringBuilder().append("GLSL link problems in\n ");
                    String string = new String(infoBytes, Charsets.UTF_8);
                    return stringBuilder.append(string).toString();
                }
                {
                    this.$logLength = nArray;
                    this.$infoLog = byteBuffer;
                    super(0);
                }
            });
            throw (Throwable)new Exception("Shader error: " + sourceFile);
        }
    }

    @NotNull
    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }
}

