/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.Shader;
import org.openrndr.internal.Driver;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u001e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0005J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J\u0016\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/internal/gl3/ShaderPreprocessorGL3;", "", "()V", "registry", "", "", "getRegistry$openrndr_gl3", "()Ljava/util/Map;", "setRegistry$openrndr_gl3", "(Ljava/util/Map;)V", "fromUrls", "Lorg/openrndr/draw/Shader;", "model", "urls", "", "(Ljava/lang/Object;[Ljava/lang/String;)Lorg/openrndr/draw/Shader;", "vsUrl", "fsUrl", "process", "stream", "Ljava/io/InputStream;", "name", "code", "processUrl", "url", "Ljava/net/URL;", "register", "", "data", "registerUrl", "openrndr-gl3"})
public final class ShaderPreprocessorGL3 {
    @NotNull
    private Map<String, String> registry = new HashMap();

    @NotNull
    public final Map<String, String> getRegistry$openrndr_gl3() {
        return this.registry;
    }

    public final void setRegistry$openrndr_gl3(@NotNull Map<String, String> map) {
        Intrinsics.checkParameterIsNotNull(map, "<set-?>");
        this.registry = map;
    }

    public final void registerUrl(@NotNull String name, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(url, "url");
        try {
            this.registerUrl(name, new URL(url));
            return;
        }
        catch (MalformedURLException e) {
            throw (Throwable)new RuntimeException("malformed url: " + url);
        }
    }

    public final void registerUrl(@NotNull String name, @NotNull URL url) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(url, "url");
        try {
            InputStream inputStream = url.openStream();
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "url.openStream()");
            this.register(name, inputStream);
            return;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("cannot open url: " + url);
        }
    }

    public final void register(@NotNull String name, @NotNull String data) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(data, "data");
        this.registry.put(name, data);
    }

    /*
     * WARNING - void declaration
     */
    public final void register(@NotNull String name, @NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(stream, "stream");
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuffer sb = new StringBuffer();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 1;
        try {
            void lineIdx;
            TextStreamsKt.forEachLine(br, (Function1<? super String, Unit>)new Function1<String, Unit>(name, (Ref.IntRef)lineIdx, sb){
                final /* synthetic */ String $name;
                final /* synthetic */ Ref.IntRef $lineIdx;
                final /* synthetic */ StringBuffer $sb;

                public final void invoke(@NotNull String line) {
                    Intrinsics.checkParameterIsNotNull(line, "line");
                    String prefix = "/*" + this.$name + ':' + this.$lineIdx.element + "*/ ";
                    this.$sb.append(prefix + line + "\n");
                    int n = this.$lineIdx.element;
                    this.$lineIdx.element = n + 1;
                }
                {
                    this.$name = string;
                    this.$lineIdx = intRef;
                    this.$sb = stringBuffer;
                    super(1);
                }
            });
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("failed to read from stream");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        this.register(name, string);
    }

    @NotNull
    public final String processUrl(@NotNull Object model, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(url, "url");
        try {
            return this.processUrl(model, new URL(url));
        }
        catch (MalformedURLException e) {
            throw (Throwable)new RuntimeException("malformed url");
        }
    }

    @NotNull
    public final String processUrl(@NotNull Object model, @NotNull URL url) {
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(url, "url");
        try {
            InputStream inputStream = url.openStream();
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "url.openStream()");
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull(string, "url.toString()");
            return this.process(model, inputStream, string);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("could not open url: " + url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String process(@NotNull Object model, @NotNull InputStream stream, @NotNull String name) {
        Reader $receiver$iv;
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(stream, "stream");
        Intrinsics.checkParameterIsNotNull(name, "name");
        StringBuffer sb = new StringBuffer();
        Closeable closeable = $receiver$iv = (Reader)new BufferedReader(new InputStreamReader(stream));
        int n = 8192;
        closeable = (BufferedReader)closeable;
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            Sequence<String> lines = TextStreamsKt.lineSequence(it$iv);
            int lineIdx = 1;
            Sequence<String> $receiver$iv2 = lines;
            Iterator<String> iterator2 = $receiver$iv2.iterator();
            while (iterator2.hasNext()) {
                String element$iv;
                String line = element$iv = iterator2.next();
                String prefix = "/*" + name + ':' + lineIdx + "*/ ";
                sb.append(prefix + line + "\n");
                int n2 = lineIdx;
                lineIdx = n2 + 1;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return this.process(model, string);
    }

    @NotNull
    public final String process(@NotNull Object model, @NotNull String code) {
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(code, "code");
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);
        StringTemplateLoader stl = new StringTemplateLoader();
        Map<String, String> map = this.registry;
        Iterator<Map.Entry<String, String>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator2.next();
            String key = entry2.getKey();
            entry2 = entry;
            String value = entry2.getValue();
            stl.putTemplate(key, value);
        }
        stl.putTemplate("input", code);
        DefaultObjectWrapper dow = new DefaultObjectWrapper(Configuration.VERSION_2_3_21);
        dow.setExposeFields(true);
        cfg.setObjectWrapper(dow);
        cfg.setTemplateLoader(stl);
        cfg.clearTemplateCache();
        StringWriter sw = new StringWriter();
        try {
            Template template = cfg.getTemplate("input");
            template.process(model, sw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            throw (Throwable)new RuntimeException("error in template", e);
        }
        String string = sw.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sw.toString()");
        return string;
    }

    @NotNull
    public final Shader fromUrls(@NotNull Object model, @NotNull String[] urls) {
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(urls, "urls");
        return this.fromUrls(model, urls[0], urls[1]);
    }

    @NotNull
    public final Shader fromUrls(@NotNull Object model, @NotNull String vsUrl, @NotNull String fsUrl) {
        Intrinsics.checkParameterIsNotNull(model, "model");
        Intrinsics.checkParameterIsNotNull(vsUrl, "vsUrl");
        Intrinsics.checkParameterIsNotNull(fsUrl, "fsUrl");
        return Driver.Companion.getInstance().createShader(this.processUrl(model, vsUrl), this.processUrl(model, fsUrl));
    }
}

