/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.math.transforms;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u000f\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b\u001a)\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a6\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a6\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u001a6\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u001a.\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e\u001a\u0016\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0003\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0003\u001a\u000e\u0010$\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0003\u001a\u000e\u0010%\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0003\u001a \u0010&\u001a\u00020\u00012\b\b\u0002\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003\u001a\u000e\u0010*\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u000b\u001a.\u0010,\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e\u00a8\u0006-"}, d2={"frustum", "Lorg/openrndr/math/Matrix44;", "left", "", "right", "bottom", "top", "near", "far", "lookAt", "eye", "Lorg/openrndr/math/Vector3;", "center", "up", "lookAtParts", "", "(Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;Lorg/openrndr/math/Vector3;)[Lorg/openrndr/math/Matrix44;", "normalMatrix", "view", "ortho", "perspectiveDegrees", "fovy", "aspect", "xoff", "yoff", "perspectiveHorizontalDegrees", "project", "point", "projection", "width", "", "height", "rotate", "axis", "d", "rotateX", "rotateY", "rotateZ", "scale", "x", "y", "z", "translate", "translation", "unproject", "openrndr-math"})
public final class TransformsKt {
    @NotNull
    public static final Matrix44 ortho(double left, double right, double bottom, double top, double near, double far) {
        double tx = -(right + left) / (right - left);
        double ty = -(top + bottom) / (top - bottom);
        double tz = -(far + near) / (far - near);
        return new Matrix44(2.0 / (right - left), 0.0, 0.0, tx, 0.0, 2.0 / (top - bottom), 0.0, ty, 0.0, 0.0, (double)-2 / (far - near), tz, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 perspectiveDegrees(double fovy, double aspect, double near, double far, double xoff, double yoff) {
        double fH = Math.tan(fovy / (double)360 * Math.PI) * near;
        double fW = fH * aspect;
        return TransformsKt.frustum(-fW + xoff, fW + xoff, -fH + yoff, fH + yoff, near, far);
    }

    @NotNull
    public static final Matrix44 perspectiveHorizontalDegrees(double fovy, double aspect, double near, double far, double xoff, double yoff) {
        double fW = Math.tan(fovy / (double)360 * Math.PI) * near;
        double fH = fW / aspect;
        return TransformsKt.frustum(-fW + xoff, fW + xoff, -fH + yoff, fH + yoff, near, far);
    }

    @NotNull
    public static final Matrix44 lookAt(@NotNull Vector3 eye, @NotNull Vector3 center, @NotNull Vector3 up) {
        Intrinsics.checkParameterIsNotNull(eye, "eye");
        Intrinsics.checkParameterIsNotNull(center, "center");
        Intrinsics.checkParameterIsNotNull(up, "up");
        Matrix44[] parts = TransformsKt.lookAtParts(eye, center, up);
        return parts[0].times(parts[1]);
    }

    @NotNull
    public static final Matrix44[] lookAtParts(@NotNull Vector3 eye, @NotNull Vector3 center, @NotNull Vector3 up) {
        Intrinsics.checkParameterIsNotNull(eye, "eye");
        Intrinsics.checkParameterIsNotNull(center, "center");
        Intrinsics.checkParameterIsNotNull(up, "up");
        Vector3 up2 = up.getNormalized();
        if (Math.abs(up2.dot(eye.getNormalized())) > 0.9999) {
            up2 = new Vector3(up2.getX(), up2.getZ(), up2.getY());
        }
        Vector3 za = center.minus(eye).getNormalized();
        Vector3 xa = up2.cross(za).getNormalized();
        Vector3 ya = za.cross(xa).getNormalized();
        Vector3 re = eye.times(-1.0);
        Matrix44 t = new Matrix44(1.0, 0.0, 0.0, re.getX(), 0.0, 1.0, 0.0, re.getY(), 0.0, 0.0, 1.0, re.getZ(), 0.0, 0.0, 0.0, 1.0);
        Matrix44 m = new Matrix44(xa.getX(), ya.getX(), -za.getX(), 0.0, xa.getY(), ya.getY(), -za.getY(), 0.0, xa.getZ(), ya.getZ(), -za.getZ(), 0.0, 0.0, 0.0, 0.0, 1.0).getTransposed();
        return new Matrix44[]{m, t};
    }

    @NotNull
    public static final Matrix44 frustum(double left, double right, double bottom, double top, double near, double far) {
        double a = (right + left) / (right - left);
        double b = (top + bottom) / (top - bottom);
        double c = -(far + near) / (far - near);
        double d = -(2.0 * far * near) / (far - near);
        return new Matrix44((double)2 * near / (right - left), 0.0, a, 0.0, 0.0, (double)2 * near / (top - bottom), b, 0.0, 0.0, 0.0, c, d, 0.0, 0.0, -1.0, 0.0);
    }

    @NotNull
    public static final Matrix44 translate(@NotNull Vector3 translation) {
        Intrinsics.checkParameterIsNotNull(translation, "translation");
        return Matrix44.Companion.fromColumnVectors(Vector4.Companion.getUNIT_X(), Vector4.Companion.getUNIT_Y(), Vector4.Companion.getUNIT_Z(), new Vector4(translation.getX(), translation.getY(), translation.getZ(), 1.0));
    }

    @NotNull
    public static final Matrix44 rotate(@NotNull Vector3 axis, double d) {
        Intrinsics.checkParameterIsNotNull(axis, "axis");
        double r = Math.toRadians(d);
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        double ux = axis.getX();
        double uy = axis.getY();
        double uz = axis.getZ();
        Vector4 c0 = new Vector4(cr + axis.getX() * axis.getX() * (1.0 - cr), axis.getY() * axis.getX() * (1.0 - cr) + axis.getZ() * sr, axis.getZ() * axis.getX() * (1.0 - cr) - axis.getY() * sr, 0.0);
        Vector4 c1 = new Vector4(ux * uy * (1.0 - cr) - uz * sr, cr + uy * uy * (1.0 - cr), uz * uy * (1.0 - cr) + ux * sr, 0.0);
        Vector4 c2 = new Vector4(ux * uz * (1.0 - cr) + uy * sr, uy * uz * (1.0 - cr) - ux * sr, cr + uz * uz * (1.0 - cr), 0.0);
        return Matrix44.Companion.fromColumnVectors(c0, c1, c2, Vector4.Companion.getUNIT_W());
    }

    @NotNull
    public static final Matrix44 rotateX(double d) {
        double r = Math.toRadians(d);
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(1.0, 0.0, 0.0, 0.0, 0.0, cr, -sr, 0.0, 0.0, sr, cr, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 rotateY(double d) {
        double r = Math.toRadians(d);
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(cr, 0.0, sr, 0.0, 0.0, 1.0, 0.0, 0.0, -sr, 0.0, cr, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 rotateZ(double d) {
        double r = Math.toRadians(d);
        double cr = Math.cos(r);
        double sr = Math.sin(r);
        return new Matrix44(cr, -sr, 0.0, 0.0, sr, cr, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static final Matrix44 scale(double x, double y, double z) {
        return new Matrix44(x, 0.0, 0.0, 0.0, 0.0, y, 0.0, 0.0, 0.0, 0.0, z, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Matrix44 scale$default(double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = 1.0;
        }
        return TransformsKt.scale(d, d2, d3);
    }

    @NotNull
    public static final Vector3 unproject(@NotNull Vector3 point, @NotNull Matrix44 projection, @NotNull Matrix44 view, int width, int height) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        Intrinsics.checkParameterIsNotNull(view, "view");
        Matrix44 ipm = projection.times(view).getInversed();
        Vector3 v = new Vector3((double)2 * point.getX() / (double)width - 1.0, (double)2 * point.getY() / (double)height - 1.0, (double)2 * point.getZ() - 1.0);
        return ipm.times(v);
    }

    @NotNull
    public static final Vector3 project(@NotNull Vector3 point, @NotNull Matrix44 projection, @NotNull Matrix44 view, int width, int height) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        Intrinsics.checkParameterIsNotNull(projection, "projection");
        Intrinsics.checkParameterIsNotNull(view, "view");
        Vector4 homo = new Vector4(point.getX(), point.getY(), point.getZ(), 1.0);
        Vector4 projectedHomo = projection.times(view).times(homo);
        double rhw = 1.0 / projectedHomo.getW();
        return new Vector3((projectedHomo.getX() * rhw + 1.0) * (double)width / (double)2, (1.0 - projectedHomo.getY() * rhw) * (double)height / (double)2, rhw);
    }

    @NotNull
    public static final Matrix44 normalMatrix(@NotNull Matrix44 view) {
        Intrinsics.checkParameterIsNotNull(view, "view");
        Matrix44 subView = new Matrix44(view.getC0r0(), view.getC1r0(), view.getC2r0(), 0.0, view.getC0r1(), view.getC1r1(), view.getC2r1(), 0.0, view.getC0r2(), view.getC1r2(), view.getC2r2(), 0.0, 0.0, 0.0, 0.0, 1.0);
        return Matrix44.copy$default(subView.getInversed().getTransposed(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Short.MAX_VALUE, null);
    }
}

