/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.math.BezierKt;
import org.openrndr.math.MappingKt;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector4;
import org.openrndr.shape.SegmentProjection;
import org.openrndr.shape.ShapeKt;
import org.openrndr.shape.internal.BezierCubicRenderer;
import org.openrndr.shape.internal.BezierQuadraticSampler;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ*\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00030!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010$\u001a\u00020\u0003H\u0002J\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0013J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0000J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\b\b\u0002\u0010*\u001a\u00020\"J\u000e\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0013J\u001f\u0010-\u001a\u0004\u0018\u00010\u00132\u0006\u0010.\u001a\u00020\u00032\b\b\u0002\u0010/\u001a\u00020\u0013\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0013J\u000e\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020\u0003J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\b\b\u0002\u00105\u001a\u00020\u0013J\u0019\u00106\u001a\b\u0012\u0004\u0012\u00020\u00000\u000b2\u0006\u0010&\u001a\u00020\u0013\u00a2\u0006\u0002\u00107J\u0016\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u0013J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<R\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011\u00a8\u0006="}, d2={"Lorg/openrndr/shape/Segment;", "", "start", "Lorg/openrndr/math/Vector2;", "end", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "c0", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "c1", "(Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "control", "", "(Lorg/openrndr/math/Vector2;[Lorg/openrndr/math/Vector2;Lorg/openrndr/math/Vector2;)V", "getControl", "()[Lorg/openrndr/math/Vector2;", "[Lorg/openrndr/math/Vector2;", "getEnd", "()Lorg/openrndr/math/Vector2;", "length", "", "getLength", "()D", "linear", "", "getLinear", "()Z", "lut", "", "reverse", "getReverse", "()Lorg/openrndr/shape/Segment;", "getStart", "closest", "Lkotlin/Pair;", "", "points", "query", "direction", "t", "intersect", "", "other", "size", "normal", "ut", "on", "point", "error", "(Lorg/openrndr/math/Vector2;D)Ljava/lang/Double;", "position", "project", "Lorg/openrndr/shape/SegmentProjection;", "sampleAdaptive", "distanceTolerance", "split", "(D)[Lorg/openrndr/shape/Segment;", "sub", "t0", "t1", "transform", "Lorg/openrndr/math/Matrix44;", "openrndr-shape"})
public final class Segment {
    @NotNull
    private final Vector2 start;
    @NotNull
    private final Vector2 end;
    @NotNull
    private final Vector2[] control;
    private List<Vector2> lut;

    @NotNull
    public final Vector2 getStart() {
        return this.start;
    }

    @NotNull
    public final Vector2 getEnd() {
        return this.end;
    }

    @NotNull
    public final Vector2[] getControl() {
        return this.control;
    }

    public final boolean getLinear() {
        Object[] objectArray = this.control;
        return objectArray.length == 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vector2> lut(int size) {
        block7: {
            Collection<Vector2> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            block6: {
                if (this.lut == null) break block6;
                List<Vector2> list = this.lut;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (list.size() == size) break block7;
            }
            int n = 0;
            Iterable iterable = new IntRange(n, size);
            Segment segment = this;
            void var3_5 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv;
                Vector2 vector2 = this.position((double)it / (double)size);
                collection.add(vector2);
            }
            collection = (List)destination$iv$iv;
            segment.lut = collection;
        }
        List<Vector2> list = this.lut;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List lut$default(Segment segment, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        return segment.lut(n);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Double on(@NotNull Vector2 point, double error) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        List lut = Segment.lut$default(this, 0, 1, null);
        int hits = 0;
        double t = 0.0;
        int n = 0;
        int n2 = lut.size();
        while (n < n2) {
            void i;
            if (((Vector2)lut.get((int)i)).minus(point).getSquaredLength() < error * error) {
                ++hits;
                t += (double)i / (double)lut.size();
            }
            ++i;
        }
        return hits > 0 ? Double.valueOf(t / (double)hits) : null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Double on$default(Segment segment, Vector2 vector2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 5.0;
        }
        return segment.on(vector2, d);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, Vector2> closest(List<Vector2> points, Vector2 query) {
        int closestIndex = 0;
        Vector2 closestValue = points.get(0);
        double closestDistance = DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        int n = 0;
        int n2 = points.size();
        while (n < n2) {
            void i;
            double distance = points.get((int)i).minus(query).getSquaredLength();
            if (distance < closestDistance) {
                closestIndex = i;
                closestValue = points.get((int)i);
                closestDistance = distance;
            }
            ++i;
        }
        return new Pair<Integer, Vector2>(closestIndex, closestValue);
    }

    @NotNull
    public final SegmentProjection project(@NotNull Vector2 point) {
        Vector2 p;
        Intrinsics.checkParameterIsNotNull(point, "point");
        List lut = Segment.lut$default(this, 0, 1, null);
        double l = lut.size() - 1;
        Pair<Integer, Vector2> closest = this.closest(lut, point);
        double closestDistance = point.minus(closest.getSecond()).getSquaredLength();
        if (((Number)closest.getFirst()).intValue() == 0 || ((Number)closest.getFirst()).intValue() == lut.size() - 1) {
            double t = (double)((Number)closest.getFirst()).intValue() / l;
            return new SegmentProjection(this, t, closestDistance, closest.getSecond());
        }
        double t1 = (double)(((Number)closest.getFirst()).intValue() - 1) / l;
        double t2 = (double)(((Number)closest.getFirst()).intValue() + 1) / l;
        double step = 0.1 / l;
        double ft = t1;
        for (double t = t1; t < t2 + step; t += step) {
            p = this.position(t);
            double d = p.minus(point).getSquaredLength();
            if (!(d < closestDistance)) continue;
            closestDistance = d;
            ft = t;
        }
        p = this.position(ft);
        return new SegmentProjection(this, ft, closestDistance, p);
    }

    @NotNull
    public final Segment transform(@NotNull Matrix44 transform) {
        Vector2[] vector2Array;
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        Vector2 tstart = transform.times(this.start.getXy01()).getDiv().getXy();
        Vector2 tend = transform.times(this.end.getXy01()).getDiv().getXy();
        switch (((Object[])this.control).length) {
            case 2: {
                Vector2[] vector2Array2 = new Vector2[2];
                vector2Array2[0] = transform.times(this.control[0].getXy01()).getDiv().getXy();
                vector2Array = vector2Array2;
                vector2Array2[1] = transform.times(this.control[1].getXy01()).getDiv().getXy();
                break;
            }
            case 1: {
                Vector2[] vector2Array3 = new Vector2[1];
                vector2Array = vector2Array3;
                vector2Array3[0] = transform.times(this.control[0].getXy01()).getDiv().getXy();
                break;
            }
            default: {
                vector2Array = new Vector2[]{};
            }
        }
        Vector2[] tcontrol = vector2Array;
        return new Segment(tstart, tcontrol, tend);
    }

    @NotNull
    public final List<Vector2> sampleAdaptive(double distanceTolerance) {
        List<Object> list;
        switch (((Object[])this.control).length) {
            case 0: {
                list = CollectionsKt.listOf(new Vector2[]{this.start, this.end});
                break;
            }
            case 1: {
                BezierQuadraticSampler bezierQuadraticSampler;
                BezierQuadraticSampler $receiver = bezierQuadraticSampler = new BezierQuadraticSampler();
                $receiver.setDistanceTolerance(distanceTolerance);
                list = bezierQuadraticSampler.sample(this.start, this.control[0], this.end);
                break;
            }
            case 2: {
                BezierCubicRenderer bezierCubicRenderer;
                BezierCubicRenderer $receiver = bezierCubicRenderer = new BezierCubicRenderer();
                $receiver.setDistanceTolerance(distanceTolerance);
                list = bezierCubicRenderer.sample(this.start, this.control[0], this.control[1], this.end);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return list;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List sampleAdaptive$default(Segment segment, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.5;
        }
        return segment.sampleAdaptive(d);
    }

    public final double getLength() {
        double d;
        switch (((Object[])this.control).length) {
            case 0: {
                d = this.end.minus(this.start).getLength();
                break;
            }
            case 1: 
            case 2: {
                d = ShapeKt.access$sumDifferences(Segment.sampleAdaptive$default(this, 0.0, 1, null));
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return d;
    }

    @NotNull
    public final Vector2 position(double ut) {
        Vector2 vector2;
        double t = RangesKt.coerceIn(ut, 0.0, 1.0);
        switch (((Object[])this.control).length) {
            case 0: {
                vector2 = new Vector2(this.start.getX() * (1.0 - t) + this.end.getX() * t, this.start.getY() * (1.0 - t) + this.end.getY() * t);
                break;
            }
            case 1: {
                vector2 = BezierKt.bezier(this.start, this.control[0], this.end, t);
                break;
            }
            case 2: {
                vector2 = BezierKt.bezier(this.start, this.control[0], this.control[1], this.end, t);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return vector2;
    }

    @NotNull
    public final Vector2 direction() {
        return this.start.minus(this.end).getNormalized();
    }

    @NotNull
    public final Vector2 direction(double t) {
        Vector2 vector2;
        if (this.getLinear()) {
            vector2 = this.direction();
        } else if (((Object[])this.control).length == 1) {
            vector2 = BezierKt.derivative(this.start, this.control[0], this.end, t).getNormalized();
        } else if (((Object[])this.control).length == 2) {
            vector2 = BezierKt.derivative(this.start, this.control[0], this.control[1], this.end, t).getNormalized();
        } else {
            throw (Throwable)new RuntimeException("not implemented");
        }
        return vector2;
    }

    @NotNull
    public final Vector2 normal(double ut) {
        Vector2 vector2;
        Vector2 it = vector2 = this.direction(ut);
        return it.copy(it.getY() * -1.0, it.getX());
    }

    @NotNull
    public final Segment getReverse() {
        Segment segment;
        switch (((Object[])this.control).length) {
            case 0: {
                segment = new Segment(this.end, this.start);
                break;
            }
            case 1: {
                segment = new Segment(this.end, this.control[0], this.start);
                break;
            }
            case 2: {
                segment = new Segment(this.end, this.control[1], this.control[0], this.start);
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("unsupported number of control points");
            }
        }
        return segment;
    }

    @NotNull
    public final Segment sub(double t0, double t1) {
        double z0 = t0;
        double z1 = t1;
        if (t0 > t1) {
            z1 = t0;
            z0 = t1;
        }
        return z0 == 0.0 ? this.split(z1)[0] : (z1 == 1.0 ? this.split(z0)[1] : this.split(z0)[1].split(MappingKt.map(z0, 1.0, 0.0, 1.0, z1))[0]);
    }

    @NotNull
    public final Segment[] split(double t) {
        double t2 = RangesKt.coerceIn(t, 0.0, 1.0);
        if (this.getLinear()) {
            Vector2 cut = this.start.plus(this.end.minus(this.start).times(t2));
            return new Segment[]{new Segment(this.start, cut), new Segment(cut, this.end)};
        }
        if (((Object[])this.control).length == 2) {
            double z = t2;
            double z2 = z * z;
            double z3 = z * z * z;
            double iz = 1.0 - z;
            double iz2 = iz * iz;
            double iz3 = iz * iz * iz;
            Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3);
            Vector4 px = new Vector4(this.start.getX(), this.control[0].getX(), this.control[1].getX(), this.end.getX());
            Vector4 py = new Vector4(this.start.getY(), this.control[0].getY(), this.control[1].getY(), this.end.getY());
            Vector4 plx = lsm.times(px);
            Vector4 ply = lsm.times(py);
            Vector2 pl0 = new Vector2(plx.getX(), ply.getX());
            Vector2 pl1 = new Vector2(plx.getY(), ply.getY());
            Vector2 pl2 = new Vector2(plx.getZ(), ply.getZ());
            Vector2 pl3 = new Vector2(plx.getW(), ply.getW());
            Segment left = new Segment(pl0, pl1, pl2, pl3);
            Matrix44 rsm = new Matrix44(iz3, 3.0 * iz2 * z, 3.0 * iz * z2, z3, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0);
            Vector4 prx = rsm.times(px);
            Vector4 pry = rsm.times(py);
            Vector2 pr0 = new Vector2(prx.getX(), pry.getX());
            Vector2 pr1 = new Vector2(prx.getY(), pry.getY());
            Vector2 pr2 = new Vector2(prx.getZ(), pry.getZ());
            Vector2 pr3 = new Vector2(prx.getW(), pry.getW());
            Segment right = new Segment(pr0, pr1, pr2, pr3);
            return new Segment[]{left, right};
        }
        if (((Object[])this.control).length == 1) {
            double z = t2;
            double iz = 1.0 - z;
            double iz2 = iz * iz;
            double z2 = z * z;
            Matrix44 lsm = new Matrix44(1.0, 0.0, 0.0, 0.0, iz, z, 0.0, 0.0, iz2, 2.0 * iz * z, z2, 0.0, 0.0, 0.0, 0.0, 0.0);
            Vector4 px = new Vector4(this.start.getX(), this.control[0].getX(), this.end.getX(), 0.0);
            Vector4 py = new Vector4(this.start.getY(), this.control[0].getY(), this.end.getY(), 0.0);
            Vector4 plx = lsm.times(px);
            Vector4 ply = lsm.times(py);
            Segment left = new Segment(new Vector2(plx.getX(), ply.getX()), new Vector2(plx.getY(), ply.getY()), new Vector2(plx.getZ(), ply.getZ()));
            Matrix44 rsm = new Matrix44(iz2, 2.0 * iz * z, z2, 0.0, 0.0, iz, z, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            Vector4 prx = rsm.times(px);
            Vector4 pry = rsm.times(py);
            Segment right = new Segment(new Vector2(prx.getX(), pry.getX()), new Vector2(prx.getY(), pry.getY()), new Vector2(prx.getZ(), pry.getZ()));
            return new Segment[]{left, right};
        }
        throw (Throwable)new RuntimeException("not implemented");
    }

    public final void intersect(@NotNull Segment other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        if (((Object[])this.control).length != 0 || ((Object[])other.control).length != 0) {
            // empty if block
        }
    }

    public Segment(@NotNull Vector2 start, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.start = start;
        this.end = end2;
        Segment segment = this;
        Vector2[] vector2Array = new Vector2[]{};
        segment.control = vector2Array;
    }

    public Segment(@NotNull Vector2 start, @NotNull Vector2 c0, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(c0, "c0");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.start = start;
        this.control = new Vector2[]{c0};
        this.end = end2;
    }

    public Segment(@NotNull Vector2 start, @NotNull Vector2 c0, @NotNull Vector2 c1, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(c0, "c0");
        Intrinsics.checkParameterIsNotNull(c1, "c1");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.start = start;
        this.control = new Vector2[]{c0, c1};
        this.end = end2;
    }

    public Segment(@NotNull Vector2 start, @NotNull Vector2[] control, @NotNull Vector2 end2) {
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(control, "control");
        Intrinsics.checkParameterIsNotNull(end2, "end");
        this.start = start;
        this.control = control;
        this.end = end2;
    }
}

