/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.screens;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ShapeContour;
import studio.rndr.io.LZMAKt;
import studio.rndr.screens.TrafficStyle;
import studio.rndr.sketches.RouteList;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lstudio/rndr/screens/Traffic;", "", "()V", "box", "Lorg/openrndr/draw/VertexBuffer;", "getBox", "()Lorg/openrndr/draw/VertexBuffer;", "boxVertexCount", "", "getBoxVertexCount", "()I", "routeTable", "Lorg/openrndr/draw/BufferTexture;", "getRouteTable", "()Lorg/openrndr/draw/BufferTexture;", "style", "Lstudio/rndr/screens/TrafficStyle;", "getStyle", "()Lstudio/rndr/screens/TrafficStyle;", "setStyle", "(Lstudio/rndr/screens/TrafficStyle;)V", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "gbuffer", "Lorg/openrndr/draw/RenderTarget;", "time", "", "previousViewMatrix", "Lorg/openrndr/math/Matrix44;", "demo-paddock"})
public final class Traffic {
    @NotNull
    private final BufferTexture routeTable;
    @NotNull
    private final VertexBuffer box;
    private final int boxVertexCount;
    @NotNull
    private TrafficStyle style = new TrafficStyle(0, 1, null);

    @NotNull
    public final BufferTexture getRouteTable() {
        return this.routeTable;
    }

    @NotNull
    public final VertexBuffer getBox() {
        return this.box;
    }

    public final int getBoxVertexCount() {
        return this.boxVertexCount;
    }

    @NotNull
    public final TrafficStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@NotNull TrafficStyle trafficStyle) {
        Intrinsics.checkParameterIsNotNull(trafficStyle, "<set-?>");
        this.style = trafficStyle;
    }

    public final void draw(@NotNull Drawer drawer, @NotNull RenderTarget gbuffer2, double time, @NotNull Matrix44 previousViewMatrix) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(gbuffer2, "gbuffer");
        Intrinsics.checkParameterIsNotNull(previousViewMatrix, "previousViewMatrix");
        drawer.pushStyle();
        drawer.setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(this, time, gbuffer2, previousViewMatrix){
            final /* synthetic */ Traffic this$0;
            final /* synthetic */ double $time;
            final /* synthetic */ RenderTarget $gbuffer;
            final /* synthetic */ Matrix44 $previousViewMatrix;

            public final void invoke(@NotNull ShadeStyle $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.parameter("time", this.$time);
                $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                    out vec3 objPos;\n                ");
                $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n                    in vec3 objPos;\n                ");
                $receiver.setVertexTransform("\n\n\n\n                    int path = (instance%3000);\n                    float fi = p_time*10.0;\n                    float pfi = fi - 10.0/30.0;\n\n                    int index0 = int(instance+int(fi)  )%256;\n                    int index1 = min(255, index0 + 1);\n                    int index2 = min(255, index0 + 2);\n                    float f = fi - int(fi);\n\n                    int pindex0 = int(instance+int(pfi)  )%256;\n                    int pindex1 = min(255, index0 + 1);\n                    int pindex2 = min(255, index0 + 2);\n                    float pf = pfi - int(pfi);\n\n\n                    vec3 ipos0 = texelFetch(p_positions, path*256+index0 ).xyz;// + vec3(0.0, 0.0, 10.0);\n                    vec3 ipos1 = texelFetch(p_positions, path*256+index1 ).xyz;// + vec3(0.0, 0.0, 10.0);\n                    vec3 ipos2 = texelFetch(p_positions, path*256+index2 ).xyz;// + vec3(0.0, 0.0, 10.0);\n\n                    vec3 pipos0 = texelFetch(p_positions, path*256+pindex0 ).xyz;// + vec3(0.0, 0.0, 10.0);\n                    vec3 pipos1 = texelFetch(p_positions, path*256+pindex1 ).xyz;// + vec3(0.0, 0.0, 10.0);\n                    vec3 pipos2 = texelFetch(p_positions, path*256+pindex2 ).xyz;// + vec3(0.0, 0.0, 10.0);\n\n\n                    vec2 d0 = ipos1.xy - ipos0.xy;\n                    vec2 n0 = vec2(-d0.y, d0.x);\n\n                    vec2 d1 = ipos2.xy - ipos1.xy;\n                    vec2 n1 = vec2(-d1.y, d1.x);\n\n                    vec2 pd0 = pipos1.xy - pipos0.xy;\n                    vec2 pn0 = vec2(-pd0.y, pd0.x);\n\n                    vec2 pd1 = pipos2.xy - pipos1.xy;\n                    vec2 pn1 = vec2(-pd1.y, pd1.x);\n\n\n                    float sf = smoothstep(0.0, 1.0, f);\n                    vec2 d = (1.0-sf) * d0 + sf * d1;\n                    vec2 n = (1.0-sf) * n0 + sf * n1;\n\n                    float psf = smoothstep(0.0, 1.0, pf);\n                    vec2 pd = (1.0-psf) * pd0 + psf * pd1;\n                    vec2 pn = (1.0-psf) * pn0 + psf * pn1;\n\n\n\n                    mat3 tbn = mat3( vec3(normalize(n), 0.0), vec3(normalize(d), 0.0), vec3(0.0, 0.0, 1.0));\n                    mat3 ptbn = mat3( vec3(normalize(pn), 0.0), vec3(normalize(pd), 0.0), vec3(0.0, 0.0, 1.0));\n\n\n                    float ifi = mod(instance + fi,256.0);\n                    x_position.z+=0.75/4.0;\n                    x_position.y *= smoothstep(0.0, 2.0, ifi) * smoothstep(255,253, ifi);\n                    objPos = x_position;\n                    x_position = tbn * x_position;\n                    vec3 pposition = ptbn * x_position;\n\n\n                    x_position += ipos0 * (1.0-f) + ipos1 * f;\n                    x_position.xy += cos(instance)*n*2.0;\n                    x_position.z += cos(instance)*10.0 + 20.0;\n\n                    pposition += pipos0 * (1.0-pf) + pipos1 * pf;\n                    pposition.xy += cos(instance)*pn*2.0;\n                    pposition.z += cos(instance)*10.0 + 20.0;\n\n\n                    currentClip = projectionMatrix * x_viewMatrix *   vec4(x_position, 1.0);\n\n\n                    previousView = (p_previousViewMatrix * vec4( pposition, 1.0));\n                    vec4 pclip = projectionMatrix * previousView;\n                    previousClip = pclip;\n\n\n\n                ");
                $receiver.setFragmentTransform("\n                    o_position.xyz = view.position;\n                    o_position.w = 1.0;\n                    o_normal.xyz = view.normal;\n                    o_normal.w = 0.0;\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720)*0.05;\n                    //x_fill.rgb += vec3(4.0) * max(0.0, objPos.y);\n                    //x_fill.rgb += (object.normal.z) * vec3(1.0, 1.05, 1.1) * (0.5+0.5*cos(object.position.x*0.01+0.01*object.position.y));\n                    //x_fill.rgb *= (sin(object.position.z*4.0)*0.5+0.5);\n                    //x_fill.rgb *= cos(v_objectId+object.position.z*4.0)*0.5+0.5;\n                    x_fill.rgb *= cos(v_instance)*0.5+0.5;;\n                    x_fill.rgb /= max(1.0, -(view.position.z/10.0)-20.0);\n\n                    ");
                $receiver.output("position", this.$gbuffer.colorBufferIndex("position"));
                $receiver.output("normal", this.$gbuffer.colorBufferIndex("normal"));
                $receiver.output("velocity", this.$gbuffer.colorBufferIndex("velocity"));
                $receiver.parameter("previousViewMatrix", this.$previousViewMatrix);
                $receiver.parameter("positions", this.this$0.getRouteTable());
            }
            {
                this.this$0 = traffic;
                this.$time = d;
                this.$gbuffer = renderTarget;
                this.$previousViewMatrix = matrix44;
                super(1);
            }
        }));
        drawer.setFill(ColorRGBa.Companion.getPINK().toLinear().shade(8.0));
        ColorRGBa colorRGBa = drawer.getFill();
        if (colorRGBa == null) {
            Intrinsics.throwNpe();
        }
        ColorRGBa f = colorRGBa;
        drawer.setFill(new ColorRGBa(f.getR() + 1.0, f.getG() + 1.0, f.getB() + 1.0, 0.0, null, 24, null));
        drawer.vertexBufferInstances(CollectionsKt.listOf(this.box), CollectionsKt.emptyList(), DrawPrimitive.TRIANGLES, this.style.getTrafficCount(), 0, this.boxVertexCount);
        drawer.popStyle();
    }

    /*
     * WARNING - void declaration
     */
    public Traffic() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        RouteList routePoints = LZMAKt.jsonFromLZMA(new File("data/routes.json.lzma"), RouteList.class);
        Iterable iterable = $receiver$iv = (Iterable)routePoints.getValues();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            ShapeContour shapeContour = ShapeContour.Companion.fromPoints((List<Vector2>)it, false);
            collection.add(shapeContour);
        }
        final List routes = (List)destination$iv$iv;
        this.routeTable = BufferTexture.Companion.create(routes.size() * 256, ColorFormat.RGBa, ColorType.FLOAT32);
        this.routeTable.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void invoke(@NotNull BufferWriter $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Iterable $receiver$iv = routes;
                for (Object element$iv : $receiver$iv) {
                    ShapeContour it = (ShapeContour)element$iv;
                    int n = 0;
                    int n2 = 256;
                    while (n < n2) {
                        void i;
                        $receiver.write(it.position((double)i / 255.0));
                        $receiver.write(0.0f, 0.0f);
                        ++i;
                    }
                }
            }
        });
        this.box = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(2.INSTANCE), 80);
        this.boxVertexCount = this.box.put(3.INSTANCE);
    }
}

