/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.typography;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.FontMap;
import org.openrndr.math.FunctionsKt;
import org.openrndr.text.Writer;
import studio.rndr.typography.CellContext;
import studio.rndr.typography.LineGridsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\u001a$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a$\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a$\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a&\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\u001a.\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0002\u001a\u000e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"randoms", "", "", "getRandoms", "()Ljava/util/List;", "centerBorderTexts", "", "drawer", "Lorg/openrndr/draw/Drawer;", "texts", "", "margin", "cornerDiagonalTexts", "cornerTexts", "gridText", "text", "rows", "", "columns", "gridTextBars", "time", "smoothRandom", "t", "demo-paddock"})
public final class TypeBordersKt {
    @NotNull
    private static final List<Double> randoms;

    /*
     * WARNING - void declaration
     */
    public static final void gridText(@NotNull Drawer drawer, @NotNull String text2, int rows, int columns) {
        void idx;
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(text2, "text");
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        drawer.pushView();
        drawer.translate(((double)drawer.getWidth() - ((double)drawer.getHeight() - 40.0)) / 2.0, 20.0);
        Writer w = new Writer(drawer);
        LineGridsKt.drawGrid(drawer, (double)drawer.getHeight() - 40.0, (double)drawer.getHeight() - 40.0, rows, columns, 20.0, (Function1<? super CellContext, Unit>)new Function1<CellContext, Unit>((Ref.IntRef)idx, text2, w, drawer){
            final /* synthetic */ Ref.IntRef $idx;
            final /* synthetic */ String $text;
            final /* synthetic */ Writer $w;
            final /* synthetic */ Drawer $drawer;

            public final void invoke(@NotNull CellContext it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                String cellText = "" + (this.$idx.element < this.$text.length() ? this.$text.charAt(this.$idx.element) : (char)'X');
                double textWidth = this.$w.textWidth(cellText);
                FontMap fontMap = this.$drawer.getFontMap();
                double textHeight = fontMap != null ? fontMap.getHeight() : 0.0;
                this.$drawer.text(cellText, it.getWidth() / 2.0 - textWidth / 2.0, it.getHeight() / 2.0 - textHeight / 2.0);
                int n = this.$idx.element;
                this.$idx.element = n + 1;
            }
            {
                this.$idx = intRef;
                this.$text = string;
                this.$w = writer;
                this.$drawer = drawer;
                super(1);
            }
        });
        drawer.popView();
    }

    @NotNull
    public static final List<Double> getRandoms() {
        return randoms;
    }

    public static final double smoothRandom(double t) {
        double st = FunctionsKt.mod(t, 1.0);
        double v0 = ((Number)randoms.get((int)(st * (double)randoms.size()))).doubleValue();
        double v1 = ((Number)randoms.get(((int)(st * (double)randoms.size()) + 1) % randoms.size())).doubleValue();
        double f = st * (double)randoms.size() % 1.0;
        return v0 * (1.0 - f) + v1 * f;
    }

    /*
     * WARNING - void declaration
     */
    public static final void gridTextBars(@NotNull Drawer drawer, @NotNull String text2, int rows, int columns, double time) {
        void idx;
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(text2, "text");
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        drawer.pushView();
        drawer.translate(((double)drawer.getWidth() - ((double)drawer.getHeight() - 40.0)) / 2.0, 20.0);
        Writer w = new Writer(drawer);
        LineGridsKt.drawGrid(drawer, (double)drawer.getHeight() - 40.0, (double)drawer.getHeight() - 40.0, rows, columns, 20.0, (Function1<? super CellContext, Unit>)new Function1<CellContext, Unit>((Ref.IntRef)idx, text2, w, drawer, time){
            final /* synthetic */ Ref.IntRef $idx;
            final /* synthetic */ String $text;
            final /* synthetic */ Writer $w;
            final /* synthetic */ Drawer $drawer;
            final /* synthetic */ double $time;

            public final void invoke(@NotNull CellContext it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                String cellText = "" + (this.$idx.element < this.$text.length() ? this.$text.charAt(this.$idx.element) : (char)' ');
                double textWidth = this.$w.textWidth(cellText);
                FontMap fontMap = this.$drawer.getFontMap();
                double textHeight = fontMap != null ? fontMap.getHeight() : 0.0;
                this.$drawer.text(cellText, it.getWidth() / 2.0 - textWidth / 2.0, it.getHeight() / 2.0 - textHeight / 2.0 + textHeight);
                if (Intrinsics.areEqual(cellText, " ") ^ true) {
                    double barWidth = textWidth * 0.25 + TypeBordersKt.smoothRandom(this.$time * 0.01 + (double)it.getI() * 0.1 + (double)it.getJ() * 0.1) * textWidth * (double)2;
                    this.$drawer.rectangle(it.getWidth() / 2.0 - textWidth / 2.0, it.getHeight() / 2.0 - textHeight / 2.0 + textHeight * 1.2, barWidth, textHeight / 5.0);
                }
                int n = this.$idx.element;
                this.$idx.element = n + 1;
            }
            {
                this.$idx = intRef;
                this.$text = string;
                this.$w = writer;
                this.$drawer = drawer;
                this.$time = d;
                super(1);
            }
        });
        drawer.popView();
    }

    public static final void cornerTexts(@NotNull Drawer drawer, @NotNull List<String> texts, double margin) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(texts, "texts");
        drawer.pushTransforms();
        drawer.translate(margin, margin);
        drawer.text(texts.get(0), 0.0, 0.0);
        drawer.popTransforms();
        drawer.pushTransforms();
        drawer.translate((double)drawer.getWidth() - margin, margin);
        drawer.rotate(90.0);
        drawer.text(texts.get(1), 0.0, 0.0);
        drawer.popTransforms();
        drawer.pushTransforms();
        double textWidth2 = new Writer(drawer).textWidth(texts.get(2));
        drawer.translate((double)drawer.getWidth() - margin - textWidth2, (double)drawer.getHeight() - margin);
        drawer.text(texts.get(2), 0.0, 0.0);
        drawer.popTransforms();
        drawer.pushTransforms();
        drawer.translate(margin, (double)drawer.getHeight() - margin);
        drawer.rotate(270.0);
        drawer.text(texts.get(3), 0.0, 0.0);
        drawer.popTransforms();
    }

    /*
     * WARNING - void declaration
     */
    public static final void centerBorderTexts(@NotNull Drawer drawer, @NotNull List<String> texts, double margin) {
        Drawer drawer2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(texts, "texts");
        Iterable iterable = $receiver$iv = (Iterable)texts;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            Double d = new Writer(drawer).textWidth((String)it);
            collection.add(d);
        }
        List textWidths = (List)destination$iv$iv;
        Drawer $receiver = drawer2 = drawer;
        $receiver.pushTransforms();
        $receiver.translate((double)($receiver.getWidth() / 2) - ((Number)textWidths.get(0)).doubleValue() / 2.0, margin);
        $receiver.text(texts.get(0), 0.0, 0.0);
        $receiver.popTransforms();
        $receiver.pushTransforms();
        $receiver.translate((double)$receiver.getWidth() - margin, (double)($receiver.getHeight() / 2) - ((Number)textWidths.get(1)).doubleValue() / 2.0);
        $receiver.rotate(90.0);
        $receiver.text(texts.get(1), 0.0, 0.0);
        $receiver.popTransforms();
        FontMap fontMap = drawer.getFontMap();
        double h = fontMap != null ? fontMap.getHeight() : 0.0;
        $receiver.pushTransforms();
        $receiver.translate((double)($receiver.getWidth() / 2) - ((Number)textWidths.get(2)).doubleValue() / 2.0, (double)$receiver.getHeight() - margin + h);
        $receiver.text(texts.get(2), 0.0, 0.0);
        $receiver.popTransforms();
        $receiver.pushTransforms();
        $receiver.translate(margin, (double)($receiver.getHeight() / 2) + ((Number)textWidths.get(3)).doubleValue() / 2.0);
        $receiver.rotate(270.0);
        $receiver.text(texts.get(3), 0.0, 0.0);
        $receiver.popTransforms();
    }

    /*
     * WARNING - void declaration
     */
    public static final void cornerDiagonalTexts(@NotNull Drawer drawer, @NotNull List<String> texts, double margin) {
        Drawer drawer2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(texts, "texts");
        Iterable iterable = $receiver$iv = (Iterable)texts;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            Double d = new Writer(drawer).textWidth((String)it);
            collection.add(d);
        }
        List textWidths = (List)destination$iv$iv;
        Drawer $receiver = drawer2 = drawer;
        drawer.pushTransforms();
        drawer.translate(margin, margin);
        drawer.rotate(45.0);
        drawer.text(texts.get(0), 0.0, 0.0);
        drawer.popTransforms();
        drawer.pushTransforms();
        drawer.translate((double)$receiver.getWidth() - margin, margin);
        drawer.rotate(-45.0);
        drawer.translate(-((Number)textWidths.get(1)).doubleValue(), 0.0);
        drawer.text(texts.get(0), 0.0, 0.0);
        drawer.popTransforms();
        drawer.pushTransforms();
        drawer.translate((double)$receiver.getWidth() - margin, (double)$receiver.getHeight() - margin);
        drawer.rotate(45.0);
        drawer.translate(-((Number)textWidths.get(1)).doubleValue(), 0.0);
        drawer.text(texts.get(0), 0.0, 0.0);
        drawer.popTransforms();
        drawer.pushTransforms();
        drawer.translate(margin, (double)$receiver.getHeight() - margin);
        drawer.rotate(-45.0);
        drawer.text(texts.get(0), 0.0, 0.0);
        drawer.popTransforms();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)RangesKt.until(0, 256);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            Double d = Math.random();
            collection.add(d);
        }
        randoms = (List)var2_2;
    }
}

