#version 330

${uniforms! }

uniform vec4 stroke;
uniform vec4 fill;

uniform float strokeMult;
uniform float strokeThr;

uniform float strokeFillFactor;

uniform sampler2D tex;
uniform vec4 bounds;

in vec3 v_objectPosition;

in vec2 v_ftcoord;
in float v_offset;
out vec4 o_color;

float strokeMask() {
	return min(1.0, (1.0-abs(v_ftcoord.x*2.0-1.0))*strokeMult) * min(1.0, v_ftcoord.y);
}

void main(void) {

    vec3 boundsPosition = vec3(v_objectPosition.xy - bounds.xy, 0.0) / vec3(bounds.zw,1.0);
    vec3 boundsSize = vec3(bounds.zw, 0.0);

    float strokeOffset = v_offset;
	float strokeAlpha = strokeMask();

    vec4 x_stroke = stroke;
    vec4 x_fill = fill;

    { ${fragmentTransform! } }

    vec4 color = mix(x_stroke, x_fill, strokeFillFactor)  * vec4(1,1,1,strokeAlpha);
    vec4 result = color;

    if (strokeAlpha < strokeThr) {
	    discard;
	}

	o_color = result;
	o_color.rgb *= o_color.a;


}