#version 330

${attributes! }
${uniforms! }


${varyingOut! }

uniform mat4 normalMatrix;
uniform mat4 viewMatrix;
uniform mat4 projectionMatrix;
uniform mat4 viewProjectionMatrix;

struct VertexData {
    vec3 position;
    vec3 normal;
};

out VertexData object;
out VertexData view;
out VertexData clip;

${vertexPreamble! }

flat out int v_instance;
void main() {

    int instance = gl_InstanceID;
    ${varyingBridge! }

    vec3 x_normal = vec3(0.0, 0.0, 0.0);
    <#if attributes?contains("vec3 normal;")>
        x_normal = normal;
    </#if>

    vec3 x_position = position;

    mat4 x_normalMatrix = normalMatrix;
    mat4 x_viewMatrix = viewMatrix;
    mat4 x_projectionMatrix = projectionMatrix;
    {
        ${vertexTransform! }
    }

    object.position = x_position;
    object.normal = x_normal;

    vec4 viewPosition = x_viewMatrix * vec4( x_position, 1.0);
    view.position = viewPosition.xyz;
    view.normal = (x_normalMatrix * vec4(x_normal, 0.0)).xyz;

    vec4 clipPosition = x_projectionMatrix * viewPosition;
    clip.position = clipPosition.xyz/clipPosition.w;
    clip.normal = vec3(0.0);

    v_instance = instance;
    gl_Position = clipPosition;

}
