/*
 * Decompiled with CFR 0.152.
 */
import ch.bildspur.postfx.Supervisor;
import ch.bildspur.postfx.builder.PostFX;
import ch.bildspur.postfx.pass.Pass;
import ddf.minim.AudioListener;
import ddf.minim.AudioPlayer;
import ddf.minim.analysis.BeatDetect;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;
import processing.event.MouseEvent;
import processing.opengl.PShader;

public class trbl_processing
extends PApplet {
    int[] blendmodes;
    Moonlander _moon;
    PostFX fx;
    CAPass caPass;
    InvertPass invertPass;
    BeatDetect beat;
    float SCALE;
    boolean SAVE_VIDEO;
    int FPS;
    int MAX_LENGTH;
    String tune;
    float BPM;
    int ROWS_PER_BEAT;
    int LAYERS;
    int W;
    int H;
    String[] sceneList;
    PGraphics[] layerList;
    PImage[] _spriteList;
    PShape[] trbl;
    PShape[] letters;
    PShape[] objects;
    ArrayList<Particle> particles;
    float tickTime;
    boolean ready;
    BeatListener bl;
    float kickSize;
    float snareSize;
    float hatSize;
    float _kick;
    ArrayList<Box> sponge;
    PImage _paletteImage;
    int[] palette;
    int[] currentPalette;
    int[] nextPalette;
    int[][] paletteList;
    String _seedFileName;
    int _seedIndex;
    ArrayList<int[]> _seeds;
    int _randomSeedIndex;
    ArrayList<int[]> _randomSeeds;
    int NOISE_SEED;
    int RANDOM_SEED;
    Boolean _useRandomSeed;
    PGraphics _uiLayer;
    boolean SHOW_FPS;
    boolean SHOW_GRID;
    float _uiPaletteWidth;
    int frameCounter;
    float BPS;
    int SWITCH_EVERY;
    int lastFrameSuggestion;
    int frameOffset;
    int frameDelta;
    int LAST_FRAME;

    public trbl_processing() {
        int[] nArray = new int[10];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 16;
        nArray[4] = 8;
        nArray[5] = 1;
        nArray[6] = 64;
        nArray[7] = 128;
        nArray[8] = 256;
        this.blendmodes = nArray;
        this.SCALE = 1.0f;
        this.SAVE_VIDEO = false;
        this.FPS = 60;
        this.MAX_LENGTH = this.FPS * 69;
        this.tune = "trbl_deux_soundtrack.mp3";
        this.BPM = 107.0f;
        this.ROWS_PER_BEAT = 8;
        this.LAYERS = 7;
        this.W = 1920;
        this.H = 1080;
        this.layerList = new PGraphics[this.LAYERS];
        this.trbl = new PShape[4];
        this.letters = new PShape[4];
        this.objects = new PShape[3];
        this.particles = new ArrayList();
        this.tickTime = 0.0f;
        this.ready = false;
        this.currentPalette = new int[0];
        this.nextPalette = new int[0];
        this.paletteList = new int[this.LAYERS][20];
        this._seedFileName = "seed.txt";
        this._seeds = new ArrayList();
        this._randomSeedIndex = 0;
        this._randomSeeds = new ArrayList();
        this.NOISE_SEED = 18198460;
        this.RANDOM_SEED = 33330108;
        this._useRandomSeed = false;
        this.SHOW_FPS = false;
        this.SHOW_GRID = false;
        this.frameCounter = 0;
        this.BPS = 60.0f / this.BPM;
        this.SWITCH_EVERY = trbl_processing.ceil((float)(this.BPS * (float)this.FPS));
        this.lastFrameSuggestion = trbl_processing.floor((float)(this.MAX_LENGTH / this.SWITCH_EVERY)) * this.SWITCH_EVERY;
        this.frameOffset = 0;
        this.frameDelta = 0;
        this.LAST_FRAME = (this.lastFrameSuggestion + this.frameOffset) * trbl_processing.max((int)1, (int)this.frameDelta);
    }

    public void settings() {
        this.size((int)((float)this.W / this.SCALE), (int)((float)this.H / this.SCALE), "processing.opengl.PGraphics3D");
    }

    public void setup() {
        this.frameRate(this.FPS);
        this.noiseDetail(2);
        this.hint(-6);
        this._moon = Moonlander.initWithSoundtrack((PApplet)this, (String)this.tune, (int)((int)this.BPM), (int)this.ROWS_PER_BEAT);
        this.initSeedManager();
        this.initUtils();
        this.palette = this.getPalette(20);
        int i = 0;
        while (i < this.paletteList.length) {
            this.paletteList[i] = Arrays.copyOf(this.palette, this.palette.length);
            ++i;
        }
        i = 0;
        while (i < this.layerList.length) {
            this.layerList[i] = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
            ++i;
        }
        this._uiLayer = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics2D");
        this.fx = new PostFX((PApplet)this);
        this.caPass = new CAPass();
        this.invertPass = new InvertPass();
        this.loadAssets();
        this.initBeatDetection();
    }

    public void loadAssets() {
        int c = 0;
        while (c < 4) {
            this.trbl[c] = this.loadShape("trbl.obj");
            this.trbl[c].rotateX(trbl_processing.radians((float)90.0f));
            this.trbl[c].rotateZ(trbl_processing.radians((float)180.0f));
            this.trbl[c].scale(0.109375f * (float)this.width);
            ++c;
        }
        this.initSponge();
        int i = 0;
        while (i < 3) {
            this.menger();
            ++i;
        }
        String[] letterObj = new String[]{"d", "e", "u", "x"};
        int i2 = 0;
        while (i2 < letterObj.length) {
            this.letters[i2] = this.loadShape(String.valueOf(letterObj[i2]) + ".obj");
            this.letters[i2].scale(0.15625f * (float)this.width);
            this.letters[i2].rotateX(trbl_processing.radians((float)90.0f));
            ++i2;
        }
    }

    public void prerender() {
        if (!this.ready) {
            PGraphics offscreen = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
            offscreen.beginDraw();
            int i = 0;
            while (i < this.letters.length) {
                offscreen.shape(this.letters[i]);
                ++i;
            }
            i = 0;
            while (i < this._spriteList.length) {
                offscreen.image(this._spriteList[i], 0.0f, 0.0f);
                ++i;
            }
            offscreen.endDraw();
            this._moon.start();
            this.ready = true;
        }
    }

    public void draw() {
        this.prerender();
        this._moon.update();
        this.updateBeatdetection();
        this.lights();
        this.lerpPalette();
        this.clear();
        this.background(this.palette[0]);
        int i = 0;
        while (i < this.layerList.length - 1) {
            int layerIndex = i + 1;
            int sceneIndex = (int)this._moon.getValue("layer" + layerIndex + ":sceneIndex");
            this.setPalette(layerIndex);
            if (sceneIndex > 0) {
                this.setCam(this.layerList[i], layerIndex);
                this.renderScene(this.layerList[i], layerIndex, sceneIndex);
                this.composeScene(this.layerList[i], layerIndex);
            }
            ++i;
        }
        float brightness = (float)this._moon.getValue("postfx:brightness");
        this.caPass.amount = (float)this._moon.getValue("postfx:ca");
        this.invertPass.amount = (float)this._moon.getValue("postfx:invert");
        this.fx.render().bloom((float)this._moon.getValue("postfx:bloom.threshold"), (int)this._moon.getValue("postfx:bloom.blurSize"), (float)this._moon.getValue("postfx:bloom.sigma") * (1.0f + this.getKick())).custom((Pass)this.invertPass).custom((Pass)this.caPass).brightnessContrast(brightness, 1.0f + (float)this._moon.getValue("postfx:contrast")).saturationVibrance((float)this._moon.getValue("postfx:saturation"), (float)this._moon.getValue("postfx:vibrance")).vignette(0.3f, 0.3f).compose();
        int sceneIndex = (int)this._moon.getValue("layer" + this.layerList.length + ":sceneIndex");
        this.setPalette(this.layerList.length);
        if (sceneIndex > 0) {
            this.setCam(this.layerList[this.layerList.length - 1], this.layerList.length);
            this.renderScene(this.layerList[this.layerList.length - 1], this.layerList.length, sceneIndex);
            this.composeScene(this.layerList[this.layerList.length - 1], this.layerList.length);
        }
        this.saveFrames();
        this.drawUI();
        this.closeOnDemoEnd();
    }

    public void closeOnDemoEnd() {
        if ((float)this._moon.getCurrentRow() > 817.0f) {
            this.exit();
        }
    }

    public void renderScene(PGraphics layer, int layerIndex, int sceneIndex) {
        layer.beginDraw();
        layer.clear();
        layer.endDraw();
        this.sceneList = new String[23];
        int i = 0;
        while (i < this.sceneList.length) {
            this.sceneList[i] = "INVALID!";
            ++i;
        }
        this.sceneList[0] = "Nothing";
        this.sceneList[1] = "Sprite";
        this.sceneList[5] = "TRBL-Logo";
        this.sceneList[6] = "deux-Logo";
        this.sceneList[10] = "TorusTunnel";
        this.sceneList[11] = "Menger";
        this.sceneList[12] = "BallonIntro";
        this.sceneList[13] = "TorusTunnel (side)";
        this.sceneList[14] = "3D Gundam";
        this.sceneList[15] = "Stars";
        this.sceneList[16] = "Cube";
        this.sceneList[17] = "Palette";
        this.sceneList[18] = "BackgroundCircle";
        this.sceneList[19] = "ObjectTunnel";
        this.sceneList[20] = "Sphere";
        this.sceneList[21] = "Pyramid";
        this.sceneList[22] = "TextureCube";
        switch (sceneIndex) {
            case 0: {
                break;
            }
            case 1: {
                this.scene_drawSprite(layer, (int)this._moon.getValue("layer" + layerIndex + ":sprite.index"));
                break;
            }
            case 5: {
                this.scene_trbl(layer);
                break;
            }
            case 6: {
                this.scene_deux(layer, this.paletteList[layerIndex - 1]);
                break;
            }
            case 10: {
                this.torusTunnel(layer, this.paletteList[layerIndex - 1]);
                break;
            }
            case 11: {
                this.menger_invert(layer, this.paletteList[layerIndex - 1]);
                break;
            }
            case 12: {
                this.ballonIntro(layer, this.paletteList[layerIndex - 1]);
                break;
            }
            case 13: {
                this.scene_torus_tunnel_side(layer);
                break;
            }
            case 14: {
                this.scene_3D_gundamface(layer, this.paletteList[layerIndex - 1]);
                break;
            }
            case 15: {
                this.scene_stars(layer);
                break;
            }
            case 16: {
                this.scene_cube(layer, this.paletteList[layerIndex - 1]);
                break;
            }
            case 17: {
                this.scene_palette(layer);
                break;
            }
            case 18: {
                this.scene_background_circle(layer, this.paletteList[layerIndex - 1]);
                break;
            }
            case 19: {
                this.scene_objectTunnel(layer, this.paletteList[layerIndex - 1]);
                break;
            }
            case 20: {
                this.scene_sphere(layer, this.paletteList[layerIndex - 1]);
                break;
            }
            case 21: {
                this.scene_pyramid(layer, this.paletteList[layerIndex - 1]);
                break;
            }
            case 22: {
                this.scene_textureCube(layer, this.paletteList[layerIndex - 1], (int)this._moon.getValue("layer" + layerIndex + ":sprite.index"));
            }
        }
    }

    public void composeScene(PGraphics layer, int layerIndex) {
        this.tint(255, trbl_processing.round((float)(255.0f * (1.0f - (float)this._moon.getValue("layer" + layerIndex + ":opacity")))));
        this.blendMode(this.blendmodes[trbl_processing.abs((int)((int)this._moon.getValue("layer" + layerIndex + ":blendmode"))) % this.blendmodes.length]);
        if ((float)this._moon.getValue("layer" + layerIndex + ":fx.blurSize") != 0.0f) {
            this.fx.render(layer).blur((int)this._moon.getValue("layer" + layerIndex + ":fx.blurSize"), (float)this._moon.getValue("layer" + layerIndex + ":fx.blurSigma")).compose();
        } else {
            this.image((PImage)layer, 0.0f, 0.0f);
        }
        this.tint(255);
        this.blendMode(1);
    }

    public void refresh(Boolean keepSeed) {
        if (!keepSeed.booleanValue()) {
            int[] newSeed = this.getNextSeed();
            this.NOISE_SEED = newSeed[0];
            this.RANDOM_SEED = newSeed[1];
            this.noiseSeed(this.NOISE_SEED);
            this.randomSeed(this.RANDOM_SEED);
        }
        this.palette = this.getPalette(20);
    }

    public void initBeatDetection() {
        this.beat = new BeatDetect(Moonlander.song.bufferSize(), Moonlander.song.sampleRate());
        this.hatSize = 16.0f;
        this.snareSize = 16.0f;
        this.kickSize = 16.0f;
        this.bl = new BeatListener(this.beat, Moonlander.song);
    }

    public float getKick() {
        return this._kick * (float)this._moon.getValue("postfx:kickIntensity");
    }

    public void updateBeatdetection() {
        float fallOff = 0.95f;
        int lowBand = 0;
        int highBand = 7;
        int numberOfOnsetsThreshold = 4;
        if (this.beat.isRange(lowBand, highBand, numberOfOnsetsThreshold)) {
            this._kick = 1.0f;
        }
        this._kick = trbl_processing.constrain((float)(this._kick * fallOff), (float)0.0f, (float)1.0f);
    }

    public void drawEQ() {
        this._uiLayer.beginDraw();
        float rectW = this.width / this.beat.detectSize();
        int i = 0;
        while (i < this.beat.detectSize()) {
            if (this.beat.isOnset(i)) {
                this._uiLayer.fill(255);
                this._uiLayer.rect((float)i * rectW, (float)(this.height - 100), rectW, 100.0f);
            }
            ++i;
        }
        int lowBand = 0;
        int highBand = 7;
        int numberOfOnsetsThreshold = 4;
        if (this.beat.isRange(lowBand, highBand, numberOfOnsetsThreshold)) {
            this._uiLayer.fill(255.0f, 0.0f, 0.0f);
            this._uiLayer.rect(rectW * (float)lowBand, (float)(this.height - 150), (float)(highBand - lowBand) * rectW, 100.0f);
        }
        if (this.beat.isKick()) {
            this.kickSize = 32.0f;
        }
        if (this.beat.isSnare()) {
            this.snareSize = 32.0f;
        }
        if (this.beat.isHat()) {
            this.hatSize = 32.0f;
        }
        this._uiLayer.fill(255);
        this._uiLayer.textAlign(3);
        this._uiLayer.textSize(this.kickSize);
        this.text(this._uiLayer, "KICK", this.width / 4, this.height / 2);
        this._uiLayer.textSize(this.snareSize);
        this.text(this._uiLayer, "SNARE", this.width / 2, this.height / 2);
        this._uiLayer.textSize(this.hatSize);
        this.text(this._uiLayer, "HAT", 3 * this.width / 4, this.height / 2);
        float fallOff = 0.95f;
        this.kickSize = trbl_processing.constrain((float)(this.kickSize * fallOff), (float)16.0f, (float)32.0f);
        this.snareSize = trbl_processing.constrain((float)(this.snareSize * fallOff), (float)16.0f, (float)32.0f);
        this.hatSize = trbl_processing.constrain((float)(this.hatSize * fallOff), (float)16.0f, (float)32.0f);
        this._uiLayer.endDraw();
    }

    public void keyPressed() {
        trbl_processing.println((String)(String.valueOf(this.key) + ":" + this.keyCode));
        if (this.key == '+') {
            this._appendTextToFile(this._seedFileName, String.valueOf(this.NOISE_SEED) + ":" + this.RANDOM_SEED);
            trbl_processing.println((String)("saved seed " + this.NOISE_SEED + " and " + this.RANDOM_SEED));
        } else if (this.key == '-') {
            if (!this._useRandomSeed.booleanValue()) {
                this._removeSeedFromFile(String.valueOf(this.NOISE_SEED) + ":" + this.RANDOM_SEED);
                this._loadSeedsFromFile();
                trbl_processing.println((String)("removed seed " + this.NOISE_SEED + " and " + this.RANDOM_SEED));
            }
        } else if (this.keyCode == 23) {
            this._useRandomSeed = this._useRandomSeed == false;
            this._setSeedsFromFile();
            trbl_processing.println((String)("set useRandomSeed to " + this._useRandomSeed));
        } else if (this.keyCode == 101) {
            this.reloadSeedManager();
            this.reloadUtils();
            trbl_processing.println((String)"reloaded config");
        } else if (this.key == 'f') {
            this.SHOW_FPS = !this.SHOW_FPS;
            trbl_processing.println((Object[])new Object[]{"show FPS:", this.SHOW_FPS});
        } else if (this.key == 'g') {
            this.SHOW_GRID = !this.SHOW_GRID;
            trbl_processing.println((Object[])new Object[]{"show Grid:", this.SHOW_GRID});
        }
    }

    public void mouseWheel(MouseEvent event) {
        float e = event.getCount();
        if (this._useRandomSeed.booleanValue()) {
            int[] newSeed = e > 0.0f ? this.getPreviousSeed() : this.getNextSeed();
            this.NOISE_SEED = newSeed[0];
            this.RANDOM_SEED = newSeed[1];
            this.noiseSeed(this.NOISE_SEED);
            this.randomSeed(this.RANDOM_SEED);
            this.refresh(true);
        }
    }

    public void initSponge() {
        this.sponge = new ArrayList();
        Box b = new Box(0.0f, 0.0f, 0.0f, (float)this.width / 1.2f);
        this.sponge.add(b);
    }

    public void menger() {
        ArrayList<Box> next = new ArrayList<Box>();
        for (Box b : this.sponge) {
            ArrayList<Box> newBoxes = b.generate();
            next.addAll(newBoxes);
        }
        this.sponge = next;
    }

    public void initPalette() {
    }

    public int randomColorFromImage() {
        int c = this._paletteImage != null ? this._paletteImage.get(trbl_processing.round((float)this.random(this._paletteImage.width)), trbl_processing.round((float)this.random(this._paletteImage.height))) : this.color(this.random(255.0f), this.random(255.0f), this.random(255.0f));
        return c;
    }

    public int[] getPalette(int amount) {
        int[] pal = new int[]{};
        int i = 0;
        while (i < amount) {
            pal = trbl_processing.append((int[])pal, (int)this.randomColorFromImage());
            ++i;
        }
        return pal;
    }

    public int[] getLayerPalette(int layerIndex, int indexDelta) {
        int[] paletteDouble = new int[this.palette.length * 2];
        int i = 0;
        while (i < paletteDouble.length) {
            paletteDouble[i] = this.palette[i % this.palette.length];
            ++i;
        }
        int startIndex = 0;
        if ((indexDelta %= this.palette.length) < 0) {
            startIndex = this.palette.length;
        }
        int i2 = 0;
        while (i2 < this.palette.length) {
            this.paletteList[layerIndex - 1][i2] = paletteDouble[startIndex + i2 + indexDelta];
            ++i2;
        }
        return this.paletteList[layerIndex - 1];
    }

    public void setPalette(int layerIndex) {
        this.getLayerPalette(layerIndex, (int)this._moon.getValue("layer" + layerIndex + ":palette.delta"));
    }

    public int darken(int p) {
        this.colorMode(3, 360.0f, 100.0f, 100.0f);
        int out = this.color(this.hue(p), this.saturation(p) + 15.0f, this.brightness(p) - 10.0f);
        this.colorMode(1, 255.0f, 255.0f, 255.0f);
        return out;
    }

    public void lerpPalette() {
        if (!this._useRandomSeed.booleanValue()) {
            this._seedIndex = (int)this._moon.getValue("seed:current");
            int seedIndexNext = (int)this._moon.getValue("seed:next");
            int[] newSeed = this.getSeedAt(seedIndexNext);
            this.NOISE_SEED = newSeed[0];
            this.RANDOM_SEED = newSeed[1];
            this.noiseSeed(this.NOISE_SEED);
            this.randomSeed(this.RANDOM_SEED);
            this.nextPalette = this.getPalette(20);
            newSeed = this.getSeedAt(this._seedIndex);
            this.NOISE_SEED = newSeed[0];
            this.RANDOM_SEED = newSeed[1];
            this.noiseSeed(this.NOISE_SEED);
            this.randomSeed(this.RANDOM_SEED);
            this.currentPalette = this.getPalette(20);
            this.palette = this.lerpPalette(this.currentPalette, this.nextPalette, (float)this._moon.getValue("seed:lerp") + this.getKick());
        }
    }

    public int[] lerpPalette(int[] pal1, int[] pal2, float time) {
        int[] col = new int[pal1.length];
        int i = 0;
        while (i < pal1.length) {
            col[i] = this.lerpColor(this.color(pal1[i]), this.color(pal2[i]), time);
            ++i;
        }
        return col;
    }

    public void torus(PGraphics layer, float radius, float tube_radius, int cp, int ts) {
        if (tube_radius == 0.0f) {
            tube_radius = radius / 2.0f;
        }
        int circle_parts = cp;
        float circle_angle = trbl_processing.radians((float)(360.0f / (float)circle_parts));
        int tube_segments = ts;
        float tube_angle = trbl_processing.radians((float)(360.0f / (float)tube_segments));
        int seg = 0;
        while (seg < tube_segments) {
            layer.beginShape(18);
            int idx = 0;
            while (idx < circle_parts + 1) {
                float x1 = (radius + tube_radius * trbl_processing.cos((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)))) * trbl_processing.cos((float)((float)seg * tube_angle + trbl_processing.radians((float)45.0f)));
                float y1 = (radius + tube_radius * trbl_processing.cos((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)))) * trbl_processing.sin((float)((float)seg * tube_angle + trbl_processing.radians((float)45.0f)));
                float z1 = tube_radius * trbl_processing.sin((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)));
                float x1Next = (radius + tube_radius * trbl_processing.cos((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)))) * trbl_processing.cos((float)(((float)(seg + 1) + trbl_processing.radians((float)45.0f)) * tube_angle));
                float y1Next = (radius + tube_radius * trbl_processing.cos((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)))) * trbl_processing.sin((float)(((float)(seg + 1) + trbl_processing.radians((float)45.0f)) * tube_angle));
                float z1Next = tube_radius * trbl_processing.sin((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)));
                float xOff = 0.0f;
                float yOff = 0.0f;
                float zOff = 0.0f;
                layer.vertex(x1 + xOff, y1 + yOff, z1 + zOff);
                layer.vertex(x1Next + xOff, y1Next + yOff, z1Next + zOff);
                idx += 2;
            }
            layer.endShape();
            ++seg;
        }
    }

    public void drawCylinder(PGraphics l, int sides, float r1, float r2, float h) {
        float y;
        float x;
        float angle = 360 / sides;
        float halfHeight = h / 2.0f;
        l.beginShape();
        int i = 0;
        while (i < sides) {
            x = trbl_processing.cos((float)trbl_processing.radians((float)((float)i * angle))) * r1;
            y = trbl_processing.sin((float)trbl_processing.radians((float)((float)i * angle))) * r1;
            l.vertex(x, y, -halfHeight);
            ++i;
        }
        l.endShape(2);
        l.beginShape();
        i = 0;
        while (i < sides) {
            x = trbl_processing.cos((float)trbl_processing.radians((float)((float)i * angle))) * r2;
            y = trbl_processing.sin((float)trbl_processing.radians((float)((float)i * angle))) * r2;
            l.vertex(x, y, halfHeight);
            ++i;
        }
        l.endShape(2);
        l.beginShape(10);
        i = 0;
        while (i < sides + 1) {
            float x1 = trbl_processing.cos((float)trbl_processing.radians((float)((float)i * angle))) * r1;
            float y1 = trbl_processing.sin((float)trbl_processing.radians((float)((float)i * angle))) * r1;
            float x2 = trbl_processing.cos((float)trbl_processing.radians((float)((float)i * angle))) * r2;
            float y2 = trbl_processing.sin((float)trbl_processing.radians((float)((float)i * angle))) * r2;
            l.vertex(x1, y1, -halfHeight);
            l.vertex(x2, y2, halfHeight);
            ++i;
        }
        l.endShape(2);
    }

    public void cylinder(int sides, float r1, float r2, float h, PGraphics l) {
        float y;
        float x;
        float angle = 360 / sides;
        float halfHeight = h / 2.0f;
        l.beginShape();
        int i = 0;
        while (i < sides) {
            x = trbl_processing.cos((float)trbl_processing.radians((float)((float)i * angle))) * r1;
            y = trbl_processing.sin((float)trbl_processing.radians((float)((float)i * angle))) * r1;
            l.vertex(x, y, -halfHeight);
            ++i;
        }
        l.endShape(2);
        l.beginShape();
        i = 0;
        while (i < sides) {
            x = trbl_processing.cos((float)trbl_processing.radians((float)((float)i * angle))) * r2;
            y = trbl_processing.sin((float)trbl_processing.radians((float)((float)i * angle))) * r2;
            l.vertex(x, y, halfHeight);
            ++i;
        }
        l.endShape(2);
        l.beginShape(10);
        i = 0;
        while (i < sides + 1) {
            float x1 = trbl_processing.cos((float)trbl_processing.radians((float)((float)i * angle))) * r1;
            float y1 = trbl_processing.sin((float)trbl_processing.radians((float)((float)i * angle))) * r1;
            float x2 = trbl_processing.cos((float)trbl_processing.radians((float)((float)i * angle))) * r2;
            float y2 = trbl_processing.sin((float)trbl_processing.radians((float)((float)i * angle))) * r2;
            l.vertex(x1, y1, -halfHeight);
            l.vertex(x2, y2, halfHeight);
            ++i;
        }
        l.endShape(2);
    }

    public void drawCylinderElipse(float r1, float h) {
        float y;
        float x;
        float r2 = r1;
        int sides = 6;
        float angle = 360 / sides;
        float halfHeight = h / 2.0f;
        float rHeight = r1 * 3.0f;
        float offsetRot = trbl_processing.radians((float)30.0f);
        this.beginShape();
        int i = 0;
        while (i < sides) {
            x = trbl_processing.cos((float)(offsetRot + trbl_processing.radians((float)((float)i * angle)))) * r1;
            y = trbl_processing.sin((float)(offsetRot + trbl_processing.radians((float)((float)i * angle)))) * rHeight;
            this.vertex(x, y, -halfHeight);
            ++i;
        }
        this.endShape(2);
        this.beginShape();
        i = 0;
        while (i < sides) {
            x = trbl_processing.cos((float)(offsetRot + trbl_processing.radians((float)((float)i * angle)))) * r2;
            y = trbl_processing.sin((float)(offsetRot + trbl_processing.radians((float)((float)i * angle)))) * rHeight;
            this.vertex(x, y, halfHeight);
            ++i;
        }
        this.endShape(2);
        this.beginShape(10);
        i = 0;
        while (i < sides + 1) {
            float x1 = trbl_processing.cos((float)(offsetRot + trbl_processing.radians((float)((float)i * angle)))) * r1;
            float y1 = trbl_processing.sin((float)(offsetRot + trbl_processing.radians((float)((float)i * angle)))) * rHeight;
            float x2 = trbl_processing.cos((float)(offsetRot + trbl_processing.radians((float)((float)i * angle)))) * r2;
            float y2 = trbl_processing.sin((float)(offsetRot + trbl_processing.radians((float)((float)i * angle)))) * rHeight;
            this.vertex(x1, y1, -halfHeight);
            this.vertex(x2, y2, halfHeight);
            ++i;
        }
        this.endShape(2);
    }

    public void torus(float radius, float tube_radius, PGraphics l, PImage texture) {
        if (tube_radius == 0.0f) {
            tube_radius = radius / 2.0f;
        }
        int circle_parts = 12;
        float circle_angle = trbl_processing.radians((float)(360.0f / (float)circle_parts));
        int tube_segments = 21;
        float tube_angle = trbl_processing.radians((float)(360.0f / (float)tube_segments));
        int seg = 0;
        while (seg < tube_segments) {
            l.beginShape(18);
            if (texture != null) {
                l.textureMode(1);
                l.texture(texture);
            }
            int idx = 0;
            while (idx < circle_parts + 1) {
                float x1 = (radius + tube_radius * trbl_processing.cos((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)))) * trbl_processing.cos((float)((float)seg * tube_angle + trbl_processing.radians((float)45.0f)));
                float y1 = (radius + tube_radius * trbl_processing.cos((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)))) * trbl_processing.sin((float)((float)seg * tube_angle + trbl_processing.radians((float)45.0f)));
                float z1 = tube_radius * trbl_processing.sin((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)));
                float x1Next = (radius + tube_radius * trbl_processing.cos((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)))) * trbl_processing.cos((float)(((float)(seg + 1) + trbl_processing.radians((float)45.0f)) * tube_angle));
                float y1Next = (radius + tube_radius * trbl_processing.cos((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)))) * trbl_processing.sin((float)(((float)(seg + 1) + trbl_processing.radians((float)45.0f)) * tube_angle));
                float z1Next = tube_radius * trbl_processing.sin((float)((float)idx * circle_angle + trbl_processing.radians((float)45.0f)));
                float xOff = 0.0f;
                float yOff = 0.0f;
                float zOff = 0.0f;
                l.vertex(x1 + xOff, y1 + yOff, z1 + zOff);
                l.vertex(x1Next + xOff, y1Next + yOff, z1Next + zOff);
                idx += 2;
            }
            l.endShape();
            ++seg;
        }
    }

    public void icosahedron(float radius, PGraphics l) {
        float t = (1.0f + trbl_processing.sqrt((float)radius)) / 2.0f;
        l.beginShape(18);
        l.beginShape(18);
        l.vertex(-1.0f, t, 0.0f);
        l.vertex(1.0f, t, 0.0f);
        l.vertex(-1.0f, -t, 0.0f);
        l.vertex(1.0f, -t, 0.0f);
        l.vertex(0.0f, -1.0f, t);
        l.vertex(0.0f, 1.0f, t);
        l.vertex(0.0f, -1.0f, -t);
        l.vertex(0.0f, 1.0f, -t);
        l.vertex(t, 0.0f, -1.0f);
        l.vertex(t, 0.0f, 1.0f);
        l.vertex(-t, 0.0f, -1.0f);
        l.vertex(-t, 0.0f, 1.0f);
        l.endShape();
    }

    public void TexturedCube(PGraphics layer, PImage texture) {
        layer.beginShape(17);
        layer.texture(texture);
        layer.vertex(-1.0f, -1.0f, 1.0f, 0.0f, 0.0f);
        layer.vertex(1.0f, -1.0f, 1.0f, 1.0f, 0.0f);
        layer.vertex(1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        layer.vertex(-1.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        layer.vertex(1.0f, -1.0f, -1.0f, 0.0f, 0.0f);
        layer.vertex(-1.0f, -1.0f, -1.0f, 1.0f, 0.0f);
        layer.vertex(-1.0f, 1.0f, -1.0f, 1.0f, 1.0f);
        layer.vertex(1.0f, 1.0f, -1.0f, 0.0f, 1.0f);
        layer.vertex(-1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
        layer.vertex(1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        layer.vertex(1.0f, 1.0f, -1.0f, 1.0f, 1.0f);
        layer.vertex(-1.0f, 1.0f, -1.0f, 0.0f, 1.0f);
        layer.vertex(-1.0f, -1.0f, -1.0f, 0.0f, 0.0f);
        layer.vertex(1.0f, -1.0f, -1.0f, 1.0f, 0.0f);
        layer.vertex(1.0f, -1.0f, 1.0f, 1.0f, 1.0f);
        layer.vertex(-1.0f, -1.0f, 1.0f, 0.0f, 1.0f);
        layer.vertex(1.0f, -1.0f, 1.0f, 0.0f, 0.0f);
        layer.vertex(1.0f, -1.0f, -1.0f, 1.0f, 0.0f);
        layer.vertex(1.0f, 1.0f, -1.0f, 1.0f, 1.0f);
        layer.vertex(1.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        layer.vertex(-1.0f, -1.0f, -1.0f, 0.0f, 0.0f);
        layer.vertex(-1.0f, -1.0f, 1.0f, 1.0f, 0.0f);
        layer.vertex(-1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        layer.vertex(-1.0f, 1.0f, -1.0f, 0.0f, 1.0f);
        layer.endShape();
    }

    public void setCam(PGraphics layer, int layerIndex) {
        float scale = (float)this._moon.getValue("cam:shake.scale");
        float intensity = (float)this._moon.getValue("cam:shake.intensity") / 960.0f * (float)this.width;
        float time = (float)this._moon.getCurrentRow();
        float nX = (this.noise(time * scale) * 2.0f - 1.0f) * intensity;
        float nY = (this.noise(0.0f, 1.0f, time * scale) * 2.0f - 1.0f) * intensity;
        float nZ = (this.noise(0.0f, 0.0f, time * scale) * 2.0f - 1.0f) * intensity;
        if (layerIndex == this.layerList.length) {
            nX = 0.0f;
            nY = 0.0f;
            nZ = 0.0f;
        }
        float radius = (float)this.width / 2.0f * (1.0f + (float)this._moon.getValue("layer" + layerIndex + ":camRot.radius"));
        float x = trbl_processing.radians((float)((float)this._moon.getValue("layer" + layerIndex + ":camRot.x")));
        float y = trbl_processing.radians((float)((float)this._moon.getValue("layer" + layerIndex + ":camRot.y")));
        float z = trbl_processing.radians((float)((float)this._moon.getValue("layer" + layerIndex + ":camRot.z")));
        float FOV = 90.0f + (float)this._moon.getValue("layer" + layerIndex + ":FOV");
        layer.beginCamera();
        layer.camera(0.0f + nX, 0.0f + nY, radius + nZ, (float)this._moon.getValue("layer" + layerIndex + ":camOrient.x") / 960.0f * (float)this.width, (float)this._moon.getValue("layer" + layerIndex + ":camOrient.y") / 960.0f * (float)this.width, 0.0f, 0.0f, 1.0f, 0.0f);
        float fov = trbl_processing.radians((float)FOV);
        layer.perspective(fov, PApplet.parseFloat((int)this.width) / PApplet.parseFloat((int)this.height), radius / 10.0f, radius * 10.0f);
        layer.rotateY(y);
        layer.rotateX(x);
        layer.rotateZ(z);
        layer.endCamera();
    }

    public void torusTunnel(PGraphics layer, int[] palette) {
        float camZ = -((float)this._moon.getCurrentRow()) - 1.0416666f * (float)this.width;
        float endDiameter = 1.0f + (float)this._moon.getValue("scene:torusTunnel.endDiameter");
        layer.beginDraw();
        layer.stroke(palette[0]);
        layer.strokeWeight(0.0027777778f * (float)this.width);
        int depth = 100;
        int z = 0;
        while (z < depth) {
            int col = z % 2 == 0 ? this.color(this.red(palette[2]), this.green(palette[2]), this.blue(palette[2]), 100.0f - 100.0f / (float)depth * (float)z) : this.color(this.red(palette[3]), this.green(palette[3]), this.blue(palette[3]), 100.0f - 100.0f / (float)depth * (float)z);
            layer.fill(col);
            layer.pushMatrix();
            layer.translate(0.0f, 0.0f, (float)z * (0.010416667f * (float)this.width));
            layer.rotateZ((float)(z * 10));
            layer.translate(0.0f, 0.0f, (float)(-z) * (0.104166664f * (float)this.width) - camZ);
            float diameter = endDiameter / (float)depth * (float)z;
            this.torus(layer, 0.3125f * (float)this.width, 0.15625f * (float)this.width * diameter, 12, 12);
            layer.popMatrix();
            ++z;
        }
        layer.endDraw();
    }

    public void scene_textureCube(PGraphics layer, int[] palette, int spriteIndex) {
        layer.beginDraw();
        layer.textureMode(1);
        layer.fill(palette[0]);
        layer.stroke(palette[1]);
        layer.pushMatrix();
        layer.strokeWeight(2.6041667E-5f * (float)this.width);
        layer.scale(0.052083332f * (float)this.width);
        this.TexturedCube(layer, this._spriteList[trbl_processing.max((int)0, (int)spriteIndex) % this._spriteList.length]);
        layer.popMatrix();
        layer.endDraw();
    }

    public void menger_invert(PGraphics layer, int[] palette) {
        layer.beginDraw();
        layer.strokeWeight(0.0010416667f * (float)this.width);
        layer.strokeJoin(2);
        layer.strokeCap(2);
        layer.pushMatrix();
        layer.fill(palette[1]);
        float size = this.width;
        layer.translate((float)(this.width / 2) - size / 2.0f, (float)(this.height / 2) - size / 2.0f, -0.5208333f * (float)this.width);
        layer.popMatrix();
        layer.pushMatrix();
        layer.stroke(this.darken(palette[1]), 0.15625f * (float)this.width);
        layer.strokeWeight(3.0f);
        int i = 0;
        while (i < this.sponge.size() - 1) {
            int c = i + 1;
            float dist = trbl_processing.dist((float)this.sponge.get((int)i).pos.x, (float)this.sponge.get((int)i).pos.y, (float)this.sponge.get((int)i).pos.z, (float)this.sponge.get((int)c).pos.x, (float)this.sponge.get((int)c).pos.y, (float)this.sponge.get((int)c).pos.z);
            layer.strokeWeight(trbl_processing.min((float)5.0f, (float)trbl_processing.map((float)dist, (float)0.0f, (float)100.0f, (float)1.0f, (float)5.0f)));
            layer.line(this.sponge.get((int)i).pos.x, this.sponge.get((int)i).pos.y, this.sponge.get((int)i).pos.z, this.sponge.get((int)c).pos.x, this.sponge.get((int)c).pos.y, this.sponge.get((int)c).pos.z);
            ++i;
        }
        layer.strokeWeight(0.0010416667f * (float)this.width);
        layer.stroke(this.darken(palette[1]));
        for (Box b : this.sponge) {
            b.show(layer, palette);
        }
        layer.popMatrix();
        layer.endDraw();
    }

    public void ballonIntro(PGraphics layer, int[] palette) {
        layer.beginDraw();
        layer.fill(palette[2]);
        layer.stroke(palette[3], 150.0f);
        layer.strokeWeight(0.004166667f * (float)this.width);
        layer.sphereDetail(6);
        int amount = 10;
        float dia = (float)this.height / 5.0f;
        float offsetX = -((float)amount * dia / 2.0f + dia / 4.0f);
        float offsetY = -((float)amount * dia) / 2.0f;
        int x = 1;
        while (x < amount) {
            int y = 1;
            while (y < amount) {
                layer.pushMatrix();
                layer.translate(offsetX + (y % 2 == 0 ? 0.0f : dia / 2.0f) + (float)x * dia, offsetY + (float)y * dia);
                layer.rotateX((float)this._moon.getCurrentRow() / 5.0f);
                layer.rotateY((float)this._moon.getCurrentRow() / 15.0f);
                layer.rotateZ(-((float)this._moon.getCurrentRow()) / 20.0f);
                layer.sphere(dia * 0.5f);
                layer.popMatrix();
                ++y;
            }
            ++x;
        }
        layer.endDraw();
    }

    public void scene_3D_gundamface(PGraphics layer, int[] palette) {
        layer.beginDraw();
        layer.strokeWeight(0.0013888889f * (float)this.width);
        this.randomSeed((long)this._moon.getValue("scene:gundamFace.seed"));
        layer.rotateZ(trbl_processing.radians((float)7.0f));
        int i = 0;
        while (i < 32) {
            int colorIndex = PApplet.parseInt((float)this.random(palette.length));
            float rotX = this.random(1.0f) > 0.5f ? -1 : 1;
            float rotY = this.random(1.0f) > 0.5f ? -1 : 1;
            float rotZ = this.random(1.0f) > 0.5f ? -1 : 1;
            int idx = PApplet.parseInt((float)this.random(7.0f));
            float diameter = (this.random(1.0f) * (float)this.width / 5.0f + (float)(this.width / 20)) / 2.0f;
            layer.fill(palette[colorIndex]);
            layer.stroke(this.darken(palette[colorIndex]));
            layer.pushMatrix();
            layer.rotateZ(trbl_processing.radians((float)(this.tickTime * 360.0f * rotZ + (float)(i / 10))) + trbl_processing.radians((float)((float)this._moon.getValue("scene:gundamFace.rotZ"))));
            layer.rotateY(trbl_processing.radians((float)(this.tickTime * 360.0f * rotY + (float)(i / 10))) + trbl_processing.radians((float)((float)this._moon.getValue("scene:gundamFace.rotY"))));
            layer.rotateX(trbl_processing.radians((float)(this.tickTime * 360.0f * rotX + (float)(i / 10))) + trbl_processing.radians((float)((float)this._moon.getValue("scene:gundamFace.rotX"))));
            switch (idx) {
                case 0: {
                    this.torus(diameter, diameter / 3.0f, layer, null);
                    break;
                }
                case 1: {
                    layer.box(diameter);
                    break;
                }
                case 2: {
                    this.cylinder(5, 0.0f, diameter, diameter * 2.0f, layer);
                    break;
                }
                case 3: {
                    layer.sphereDetail(8);
                    layer.sphere(diameter / 2.0f);
                    break;
                }
                case 4: {
                    layer.box(diameter, diameter / 3.0f, diameter * 3.0f);
                    break;
                }
                case 5: {
                    int c = 1;
                    while (c < 8) {
                        float w = diameter / 15.0f;
                        layer.translate(0.0f, (float)c * w);
                        layer.box(w, w, diameter * 3.0f);
                        ++c;
                    }
                    break;
                }
                case 6: {
                    int x = 0;
                    while (x < 10) {
                        int y = 0;
                        while (y < 5) {
                            layer.pushMatrix();
                            float w = this.width / 50;
                            layer.translate((float)x * w, (float)y * w);
                            this.cylinder(6, w / 2.0f, w / 2.0f, w / 4.0f, layer);
                            layer.popMatrix();
                            ++y;
                        }
                        ++x;
                    }
                    break;
                }
            }
            layer.popMatrix();
            ++i;
        }
        layer.copy(0, 0, this.width / 2, this.height, this.width, 0, -this.width / 2, this.height);
        layer.copy(this.width / 2, 0, this.width / 2, this.height, this.width / 2, 0, -this.width / 2, this.height);
        layer.endDraw();
    }

    public void scene_torus_tunnel_side(PGraphics layer) {
        layer.beginDraw();
        layer.fill(this.palette[this.palette.length - 1]);
        layer.stroke(this.palette[this.palette.length - 2]);
        float radius = 0.3125f * (float)this.width;
        float girth = radius / 5.0f;
        int amount_x = 12;
        int amount_z = 12;
        float tOff = trbl_processing.radians((float)(this.tickTime * 360.0f));
        int z = 0;
        while (z < amount_z) {
            int x = 0;
            while (x < amount_x) {
                float offsetZ = trbl_processing.sin((float)((float)Math.PI * 2 / (float)amount_z * (float)z)) * girth;
                float offsetRadius = trbl_processing.cos((float)((float)Math.PI * 2 / (float)amount_z * (float)z)) * girth;
                float rotX = trbl_processing.sin((float)((float)Math.PI * 2 / (float)amount_x * (float)x + tOff));
                float rotY = trbl_processing.cos((float)((float)Math.PI * 2 / (float)amount_x * (float)x + tOff));
                float offsetX = rotX * (radius + offsetRadius);
                float offsetY = rotY * (radius + offsetRadius);
                layer.pushMatrix();
                layer.translate((float)(this.width / 2), (float)(this.height / 2), 0.0f);
                layer.translate(offsetX, offsetY, offsetZ);
                this.torus(0.015625f * (float)this.width, 0.0078125f * (float)this.width, layer, null);
                layer.popMatrix();
                ++x;
            }
            ++z;
        }
        layer.pushMatrix();
        layer.rotateX(tOff);
        layer.rotateY(tOff);
        layer.translate((float)(this.width / 2), (float)(this.height / 2));
        layer.popMatrix();
        layer.endDraw();
    }

    public void scene_stars(PGraphics layer) {
    }

    public void scene_cube(PGraphics layer, int[] palette) {
        layer.beginDraw();
        layer.lights();
        layer.fill(palette[0]);
        layer.strokeWeight(0.0010416667f * (float)this.width);
        layer.stroke(this.darken(palette[0]));
        layer.pushMatrix();
        layer.box(0.078125f * (float)this.width);
        layer.popMatrix();
        layer.endDraw();
    }

    public void scene_sphere(PGraphics layer, int[] palette) {
        layer.beginDraw();
        layer.fill(palette[0]);
        layer.strokeWeight(0.0020833334f * (float)this.width);
        layer.stroke(this.darken(palette[0]));
        layer.sphereDetail(8);
        layer.pushMatrix();
        layer.sphere(0.078125f * (float)this.width);
        layer.popMatrix();
        layer.endDraw();
    }

    public void scene_pyramid(PGraphics layer, int[] palette) {
        layer.beginDraw();
        layer.fill(palette[0]);
        layer.strokeWeight(0.0020833334f * (float)this.width);
        layer.stroke(this.darken(palette[0]));
        layer.sphereDetail(2);
        layer.pushMatrix();
        float diameter = 0.078125f * (float)this.width;
        this.drawCylinder(layer, 4, diameter, 0.0f, diameter * 2.0f);
        layer.popMatrix();
        layer.endDraw();
    }

    public void scene_background_circle(PGraphics layer, int[] palette) {
        layer.beginDraw();
        layer.strokeWeight(0.0010416667f * (float)this.width);
        int amount_x = 20;
        int amount_y = 20;
        float dist_x = this.width / amount_x;
        float dist_y = this.width / amount_y;
        float size = dist_x / 4.0f;
        float offX = 0.0f;
        float offY = 0.0f;
        layer.noFill();
        layer.pushMatrix();
        layer.translate((float)(-this.width / 2), (float)(-this.height / 2));
        int x = 0;
        while (x <= amount_x) {
            int y = 0;
            while (y <= amount_y) {
                int min = 0;
                int max = palette.length - 1;
                int colIndex = trbl_processing.floor((float)(this.noise(offX * (float)x, offY * (float)y) * (float)(max - min + 1))) + min;
                layer.stroke(palette[colIndex]);
                float diameter = trbl_processing.lerp((float)this.noise((float)x + offX, (float)y + offY), (float)this.noise((float)x + offX, (float)y + offY + 16.0f), (float)trbl_processing.sin((float)(((float)this._moon.getCurrentRow() + (float)this.frameOffset) * 0.01f))) * size;
                layer.pushMatrix();
                layer.translate((float)x * dist_x + (y % 2 == 0 ? dist_x / 2.0f : 0.0f), (float)y * dist_y);
                layer.rotateY((float)this._moon.getCurrentRow() * 0.05f);
                layer.rotateZ((float)this._moon.getCurrentRow() * 0.05f);
                this.drawCylinder(layer, 3, diameter, 0.0f, diameter);
                layer.popMatrix();
                ++y;
            }
            ++x;
        }
        layer.popMatrix();
        layer.endDraw();
    }

    public void scene_objectTunnel(PGraphics layer, int[] palette) {
        int i = 0;
        while (i < 8) {
            layer.pushMatrix();
            this.scene_objectTunnel(layer, palette, i, -i * this.width / 2);
            layer.popMatrix();
            ++i;
        }
    }

    public void scene_objectTunnel(PGraphics layer, int[] palette, int seedOffset, float zOffset) {
        int sides = 12;
        float angle = 360 / sides;
        int nX = (int)this._moon.getValue("scene:objectTunnel.seed") + seedOffset;
        int nY = 1;
        int min = 0;
        int max = palette.length - 1;
        float cube_radius = 0.052083332f * (float)this.width;
        float speed = (float)this._moon.getCurrentRow();
        layer.beginDraw();
        layer.pushMatrix();
        int offsets = 0;
        while (offsets < 2) {
            float offset_rot = 15 * offsets;
            int amount_elements = 6;
            switch (offsets) {
                case 0: {
                    amount_elements = 6;
                    break;
                }
                case 1: {
                    amount_elements = 2;
                }
            }
            int elements = 0;
            while (elements < amount_elements) {
                int i = 0;
                while (i < sides) {
                    layer.strokeWeight(0.0010416667f * (float)this.width);
                    float radius = cube_radius / 2.0f + this.noise(nX, nY + elements + offsets) * (float)this.width / 2.0f;
                    float x = trbl_processing.cos((float)(trbl_processing.radians((float)((float)i * angle)) + trbl_processing.radians((float)offset_rot))) * radius;
                    float y = trbl_processing.sin((float)(trbl_processing.radians((float)((float)i * angle)) + trbl_processing.radians((float)offset_rot))) * radius;
                    layer.pushMatrix();
                    layer.translate(x, y, zOffset);
                    layer.rotateX(trbl_processing.radians((float)-75.0f) + trbl_processing.radians((float)offset_rot));
                    layer.rotateY(trbl_processing.radians((float)((float)i * angle)) + trbl_processing.radians((float)90.0f) + trbl_processing.radians((float)offset_rot));
                    layer.rotateZ(trbl_processing.radians((float)((float)i * angle)) + trbl_processing.radians((float)(speed + (float)this.frameOffset)));
                    min = 0;
                    max = 5;
                    int ele = trbl_processing.floor((float)(this.noise((float)nX + (float)elements * 10.0f, nY + elements + offsets) * (float)(max - min + 1))) + min;
                    min = 0;
                    max = palette.length - 1;
                    int colIndex = trbl_processing.floor((float)(this.noise((float)nX + (float)elements * 10.0f, nY + elements + offsets) * (float)(max - min + 1))) + min;
                    layer.fill(palette[colIndex]);
                    layer.stroke(this.darken(palette[colIndex]));
                    float diameter = this.noise(nX + elements * 100, nY + elements + offsets) * (0.046875f * (float)this.width);
                    float len = this.noise(nX + elements * 100, nY + elements + offsets) * (0.296875f * (float)this.width);
                    switch (ele) {
                        case 0: {
                            this.drawCylinder(layer, elements % 2 == 0 ? 1 : 3, diameter, diameter / 3.0f, len);
                            break;
                        }
                        case 1: {
                            this.drawCylinder(layer, elements % 2 == 0 ? 1 : 3, diameter / 5.0f, diameter, len);
                            break;
                        }
                        case 2: {
                            layer.sphereDetail(2);
                            layer.rotateX(trbl_processing.radians((float)90.0f) + (speed + (float)this.frameOffset) * 0.01f);
                            layer.sphere(diameter);
                            break;
                        }
                        case 3: {
                            layer.sphereDetail(4);
                            layer.rotateX(-trbl_processing.radians((float)90.0f) + (speed + (float)this.frameOffset) * 0.01f);
                            layer.sphere(diameter);
                            break;
                        }
                        case 4: {
                            layer.box(diameter);
                            break;
                        }
                        case 5: {
                            layer.box(diameter, diameter * 3.0f, diameter * 3.0f);
                        }
                    }
                    layer.popMatrix();
                    ++i;
                }
                ++elements;
            }
            ++offsets;
        }
        layer.popMatrix();
        layer.endDraw();
    }

    public void scene_deux(PGraphics layer, int[] palette) {
        layer.beginDraw();
        layer.lights();
        layer.pushMatrix();
        layer.translate((float)(-this.width) / 14.0f, (float)(-this.width) / 12.6f);
        int i = 0;
        while (i < this.letters.length) {
            layer.pushMatrix();
            if (i < 2) {
                layer.translate((float)(this.width / 7 * i), 0.0f);
            } else {
                layer.translate((float)(this.width / 7 * (i - 2)), (float)this.width / 6.3f);
            }
            this.letters[i].setFill(palette[1]);
            this.letters[i].setStroke(true);
            this.letters[i].setStrokeWeight(1.40625E-5f * (float)this.width);
            this.letters[i].setStroke(this.darken(palette[1]));
            layer.shape(this.letters[i], 0.0f, 0.0f);
            layer.popMatrix();
            ++i;
        }
        layer.popMatrix();
        layer.endDraw();
    }

    public void scene_trbl(PGraphics l) {
        l.beginDraw();
        l.lights();
        l.pushMatrix();
        String[] TRBL = new String[]{"top", "right", "bottom", "left"};
        int i = 0;
        while (i < this.trbl.length) {
            l.pushMatrix();
            int fill = this.lerpColor(this.color(-1), this.color(-51456), (float)this._moon.getValue("trbl:" + TRBL[i] + ".colorFade"));
            this.trbl[i].setFill(this.color(this.red(fill), this.green(fill), this.blue(fill), (float)this._moon.getValue("trbl:" + TRBL[i] + ".opacity")));
            l.rotateZ(trbl_processing.radians((float)90.0f) * (float)i);
            l.scale((float)this._moon.getValue("trbl:" + TRBL[i] + ".scale"));
            l.shape(this.trbl[i]);
            l.popMatrix();
            ++i;
        }
        l.popMatrix();
        l.endDraw();
    }

    public void scene_drawSprite(PGraphics layer, int spriteIndex) {
        layer.beginDraw();
        layer.pushMatrix();
        layer.translate((float)(-this.width / 2), (float)(-this.height / 2));
        if (spriteIndex > -1) {
            layer.image(this._spriteList[trbl_processing.max((int)0, (int)spriteIndex) % this._spriteList.length], 0.0f, 0.0f, (float)this.width, (float)this.height);
        }
        layer.popMatrix();
        layer.endDraw();
    }

    public void scene_palette(PGraphics layer) {
        float w = (float)this.width / (float)this.paletteList[0].length;
        float h = (float)this.height / (float)this.paletteList.length;
        layer.beginDraw();
        layer.pushMatrix();
        layer.translate((float)(-this.width / 2), (float)(-this.height / 2));
        int layerI = 0;
        while (layerI < this.layerList.length) {
            int paletteI = 0;
            while (paletteI < this.paletteList[layerI].length) {
                layer.fill(this.paletteList[layerI][paletteI]);
                layer.rect(w * (float)paletteI, h * (float)layerI, w, h);
                ++paletteI;
            }
            ++layerI;
        }
        layer.popMatrix();
        layer.endDraw();
    }

    public void initSeedManager() {
        int[] rnd = new int[]{(int)((float)this.frameCount * this.random(0.0f, 9001.0f)), (int)((float)this.frameCount * this.random(0.0f, 9001.0f))};
        this._randomSeeds.add(rnd);
        this._seedIndex = 0;
        this._setSeedsFromFile();
    }

    public void reloadSeedManager() {
        this._seedIndex = 0;
        this._setSeedsFromFile();
    }

    public int[] getSeed() {
        if (this._useRandomSeed.booleanValue()) {
            return this._randomSeeds.get(this._randomSeedIndex);
        }
        if (this._seedIndex > this._seeds.size()) {
            this._seedIndex = 0;
        }
        return this._seeds.get(this._seedIndex);
    }

    public int[] getSeedAt(int seedIndex) {
        int index = seedIndex;
        if (index < 0) {
            index = 0;
        }
        return this._seeds.get(index %= this._seeds.size());
    }

    public int[] getLastSeed() {
        if (this._useRandomSeed.booleanValue()) {
            return this._getRandomLastSeed();
        }
        return this._getLastSeed();
    }

    public int[] getNextSeed() {
        if (this._useRandomSeed.booleanValue()) {
            return this._getRandomNextSeed();
        }
        return this._getNextSeed();
    }

    public int[] getPreviousSeed() {
        if (this._useRandomSeed.booleanValue()) {
            return this._getRandomPreviousSeed();
        }
        return this._getPreviousSeed();
    }

    public int[] _getNextSeed() {
        ++this._seedIndex;
        if (this._seedIndex >= this._seeds.size()) {
            this._seedIndex = 0;
        }
        trbl_processing.println((String)("getNextSeed - " + this._seedIndex + "/" + this._seeds.size()));
        return this._seeds.get(this._seedIndex);
    }

    public int[] _getRandomNextSeed() {
        ++this._randomSeedIndex;
        if (this._randomSeedIndex >= this._randomSeeds.size()) {
            int[] rnd = new int[]{(int)((float)this.frameCount * this.random(0.0f, 9001.0f)), (int)((float)this.frameCount * this.random(0.0f, 9001.0f))};
            this._randomSeeds.add(rnd);
        }
        trbl_processing.println((String)("getRandomNextSeed - " + this._randomSeedIndex + "/" + this._randomSeeds.size()));
        return this._randomSeeds.get(this._randomSeedIndex);
    }

    public int[] _getLastSeed() {
        return this._seeds.get(trbl_processing.max((int)0, (int)(this._seedIndex - 1)));
    }

    public int[] _getRandomLastSeed() {
        int pntr = this._randomSeedIndex - 1;
        if (pntr < 0) {
            int[] rnd = new int[]{(int)((float)this.frameCount * this.random(0.0f, 9001.0f)), (int)((float)this.frameCount * this.random(0.0f, 9001.0f))};
            this._randomSeeds.add(0, rnd);
            pntr = 0;
            this._randomSeedIndex = 1;
        }
        return this._randomSeeds.get(pntr);
    }

    public int[] _getPreviousSeed() {
        --this._seedIndex;
        if (this._seedIndex < 0) {
            this._seedIndex = this._seeds.size() - 1;
        } else if (this._seedIndex > this._seeds.size()) {
            this._seedIndex = 0;
        }
        trbl_processing.println((String)("getPreviousSeed - " + this._seedIndex + "/" + this._seeds.size()));
        return this._seeds.get(this._seedIndex);
    }

    public int[] _getRandomPreviousSeed() {
        --this._randomSeedIndex;
        if (this._randomSeedIndex < 0) {
            int[] rnd = new int[]{(int)((float)this.frameCount * this.random(0.0f, 9001.0f)), (int)((float)this.frameCount * this.random(0.0f, 9001.0f))};
            this._randomSeeds.add(0, rnd);
            this._randomSeedIndex = 0;
        }
        trbl_processing.println((String)("getRandomPreviousSeed - " + this._randomSeedIndex + "/" + this._randomSeeds.size()));
        return this._randomSeeds.get(this._randomSeedIndex);
    }

    public void _loadSeedsFromFile() {
        String[] lines = this.loadStrings(this._seedFileName);
        this._seeds = new ArrayList();
        trbl_processing.println((String)("reading seeds from " + this._seedFileName));
        int i = 0;
        while (i < lines.length) {
            String[] s = lines[i].split(":");
            int noise = Integer.parseInt(s[0]);
            int random = Integer.parseInt(s[1]);
            int[] rnd = new int[]{noise, random};
            this._seeds.add(rnd);
            ++i;
        }
    }

    public void _setSeedsFromFile() {
        this._loadSeedsFromFile();
        this.NOISE_SEED = this.getSeed()[0];
        this.RANDOM_SEED = this.getSeed()[1];
        this.randomSeed(this.NOISE_SEED);
        this.randomSeed(this.RANDOM_SEED);
        trbl_processing.println((String)("loaded " + this._seeds.size() + " seeds from file, setting " + this.NOISE_SEED + " and " + this.RANDOM_SEED));
    }

    public void _removeSeedFromFile(String text) {
        String[] lines = this.loadStrings(this._seedFileName);
        String[] newSeedFileContents = new String[]{};
        int i = 0;
        while (i < lines.length) {
            if (!text.equals(lines[i])) {
                newSeedFileContents = trbl_processing.append((String[])newSeedFileContents, (String)lines[i]);
            }
            ++i;
        }
        this.saveStrings("data/" + this._seedFileName, newSeedFileContents);
    }

    public void drawUI() {
        if (this.SHOW_FPS || this.SHOW_GRID) {
            this._uiLayer.beginDraw();
            this._uiLayer.clear();
            if (this.SHOW_FPS) {
                this.showFPS();
            }
            if (this.SHOW_GRID) {
                this.showGrid();
            }
            this.image((PImage)this._uiLayer, 0.0f, 0.0f);
            this._uiLayer.endDraw();
        }
    }

    public void text(PGraphics layer, String text, float x, float y) {
        layer.blendMode(1);
        layer.fill(-16777216);
        float radius = 1.5f;
        int amount = 16;
        int i = 0;
        while (i < amount) {
            float c = trbl_processing.radians((float)(360.0f / (float)amount * (float)i));
            layer.text(text, x + trbl_processing.sin((float)c) * radius, y + trbl_processing.cos((float)c) * radius);
            ++i;
        }
        layer.fill(-1);
        layer.text(text, x, y);
    }

    public void showLayerOverview() {
        this._uiLayer.beginDraw();
        this._uiLayer.textAlign(39, 101);
        String text = "";
        String sceneName = "";
        int i = 0;
        while (i < this.LAYERS) {
            boolean inBounds;
            String[] bmodes = new String[]{"BLEND", "ADD", "SUBTRACT", "DARKEST", "LIGHTEST", "BLEND", "EXCLUSION", "MULTIPLY", "SCREEN", "REPLACE"};
            String blendmode = bmodes[trbl_processing.max((int)0, (int)((int)this._moon.getValue("layer" + (i + 1) + ":blendmode") % bmodes.length))];
            int index = (int)this._moon.getValue("layer" + (i + 1) + ":sceneIndex");
            boolean bl = inBounds = index >= 0 && index < this.sceneList.length;
            if (inBounds) {
                sceneName = this.sceneList[index];
                if (index == 1) {
                    int spriteIndex = (int)this._moon.getValue("layer" + (i + 1) + ":sprite.index");
                    sceneName = String.valueOf(sceneName) + "(" + spriteIndex + ")";
                }
            } else {
                sceneName = "INVALID!";
            }
            text = String.valueOf(text) + sceneName + "|" + blendmode + "|layer" + (i + 1) + "\n";
            ++i;
        }
        this.text(this._uiLayer, text, (float)(this.width - 15) - this._uiPaletteWidth, 10.0f);
        this._uiLayer.endDraw();
    }

    public void showPalette() {
        this._uiPaletteWidth = 0.20833333f * (float)this.width;
        float w = this._uiPaletteWidth / (float)this.paletteList[0].length;
        float h = 0.12291667f * (float)this.width / (float)this.paletteList.length;
        this._uiLayer.beginDraw();
        float startX = (float)this.width - w * (float)this.paletteList[0].length - 10.0f;
        float startY = 10.0f;
        int layerI = 0;
        while (layerI < this.layerList.length) {
            int paletteI = 0;
            while (paletteI < this.paletteList[layerI].length) {
                this._uiLayer.fill(this.paletteList[layerI][paletteI]);
                this._uiLayer.rect(startX + w * (float)paletteI, startY + h * (float)layerI, w, h);
                ++paletteI;
            }
            ++layerI;
        }
        this._uiLayer.endDraw();
    }

    public void showGrid() {
        this._uiLayer.beginDraw();
        this._uiLayer.blendMode(64);
        this._uiLayer.stroke(-1);
        this._uiLayer.strokeWeight(1.0f);
        this._uiLayer.line((float)this.width / 3.0f, 0.0f, (float)this.width / 3.0f, (float)this.height);
        this._uiLayer.line((float)this.width / 3.0f * 2.0f, 0.0f, (float)this.width / 3.0f * 2.0f, (float)this.height);
        this._uiLayer.line(0.0f, (float)this.height / 3.0f, (float)this.width, (float)this.height / 3.0f);
        this._uiLayer.line(0.0f, (float)this.height / 3.0f * 2.0f, (float)this.width, (float)this.height / 3.0f * 2.0f);
        this._uiLayer.blendMode(1);
        this._uiLayer.endDraw();
    }

    public void showFPS() {
        this._uiLayer.textSize(0.011458334f * (float)this.width);
        this.showLayerOverview();
        this.showPalette();
        this._uiLayer.beginDraw();
        this._uiLayer.fill(-1);
        this._uiLayer.textAlign(37, 101);
        this.text(this._uiLayer, "" + trbl_processing.round((float)this.frameRate), 10.0f, 10.0f);
        this._uiLayer.endDraw();
        this.drawEQ();
    }

    public void initUtils() {
        String path = this.sketchPath();
        String[] fileList = this.listFileNames(String.valueOf(path) + "/data");
        this._paletteImage = this.loadImage(this.filterArray(fileList, "palette")[0]);
        String[] spriteFileList = this.filterArray(fileList, "sprite");
        trbl_processing.println((String)"after:");
        spriteFileList = trbl_processing.sort((String[])spriteFileList);
        this._spriteList = new PImage[spriteFileList.length];
        int i = 0;
        while (i < spriteFileList.length) {
            this._spriteList[i] = this.loadImage(spriteFileList[i]);
            ++i;
        }
    }

    public void reloadUtils() {
        this._paletteImage = this.loadImage("palette.png");
    }

    public String[] filterArray(String[] array, String startsWith) {
        String[] filtered = new String[]{};
        int i = 0;
        while (i < array.length) {
            if (array[i].startsWith(startsWith)) {
                filtered = trbl_processing.append((String[])filtered, (String)array[i]);
            }
            ++i;
        }
        return filtered;
    }

    public void saveFrames() {
        if (this.SAVE_VIDEO) {
            if (this.frameCount > this.frameOffset && this.frameCount <= this.LAST_FRAME) {
                this.saveFrame("frame/" + this.frameCounter++ + ".png");
            }
            if (this.frameCount > this.frameOffset && this.frameCount == this.LAST_FRAME) {
                trbl_processing.print((String)"done");
                this.exit();
            }
        }
    }

    public void _appendTextToFile(String fileName, String text) {
        File f = new File(this.dataPath(fileName));
        if (!f.exists()) {
            this._createFile(f);
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));
            out.println(text);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void _createFile(File f) {
        File parentDir = f.getParentFile();
        try {
            parentDir.mkdirs();
            f.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] listFileNames(String dir) {
        File file = new File(dir);
        if (file.isDirectory()) {
            String[] names = file.list();
            return names;
        }
        return null;
    }

    public PImage createGradientImage(int w, int h, int[] colors) {
        PImage img = this.createImage(w, h, 1);
        int divideColors = colors.length - 1;
        int stepSize = img.height / divideColors;
        img.loadPixels();
        int y = 0;
        while (y < img.height) {
            int cS = colors[y / stepSize];
            int cE = colors[trbl_processing.min((int)(y / stepSize + 1), (int)divideColors)];
            float amt = (float)(y % stepSize) / (float)stepSize;
            this.lerpColor(cS, cE, amt * 1.3f);
            int x = 0;
            while (x < img.width) {
                int c1 = this.lerpColor(colors[0], colors[1], (float)x / (float)this.width / 2.0f + (float)y / (float)this.height / 2.0f);
                int index = x + y * img.width;
                img.pixels[index] = c1;
                ++x;
            }
            ++y;
        }
        img.updatePixels();
        return img;
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#080808", "--hide-stop", "trbl_processing"};
        if (passedArgs != null) {
            PApplet.main((String[])trbl_processing.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class BeatListener
    implements AudioListener {
        private BeatDetect beat;
        private AudioPlayer source;

        BeatListener(BeatDetect beat, AudioPlayer source) {
            this.source = source;
            this.source.addListener((AudioListener)this);
            this.beat = beat;
        }

        public void samples(float[] samps) {
            this.beat.detect(this.source.mix);
        }

        public void samples(float[] sampsL, float[] sampsR) {
            this.beat.detect(this.source.mix);
        }
    }

    class Box {
        PVector pos;
        float r;
        int detail;

        Box(float x, float y, float z, float r_) {
            this.pos = new PVector(x, y, z);
            this.r = r_;
            this.detail = 3 + (int)trbl_processing.this.random(3.0f);
        }

        public ArrayList<Box> generate() {
            ArrayList<Box> boxes = new ArrayList<Box>();
            int x = -2;
            while (x < 4) {
                int y = -2;
                while (y < 3) {
                    int z = -2;
                    while (z < 3) {
                        int sum = trbl_processing.abs((int)x) + trbl_processing.abs((int)y) + trbl_processing.abs((int)z);
                        float newR = this.r / 3.0f;
                        if (sum < 2) {
                            Box b = new Box(this.pos.x + (float)x * newR, this.pos.y + (float)y * newR, this.pos.z + (float)z * newR, newR);
                            boxes.add(b);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            return boxes;
        }

        public void show(PGraphics layer, int[] palette) {
            trbl_processing.this.noiseSeed(0L);
            float speed = (float)trbl_processing.this._moon.getCurrentRow() / 50.0f;
            layer.pushMatrix();
            float n = trbl_processing.this.noise(this.pos.x + 0.0f, this.pos.y + 0.0f, this.pos.z + speed);
            float dia = n * this.r;
            layer.translate(this.pos.x + n * 50.0f, this.pos.y + n * 50.0f, this.pos.z + n * 50.0f);
            layer.fill(trbl_processing.this.lerpColor(palette[1], palette[2], n));
            layer.rotateX(n * 360.0f / 80.0f);
            layer.rotateY(-n * 360.0f / 80.0f);
            layer.rotateZ(n * 360.0f / 80.0f);
            layer.sphereDetail(this.detail);
            layer.sphere(dia + (trbl_processing.sin((float)((float)trbl_processing.this._moon.getCurrentRow() / 70.0f)) + 1.0f) * 3.0f);
            layer.popMatrix();
            trbl_processing.this.noiseSeed(trbl_processing.this.NOISE_SEED);
        }
    }

    class CAPass
    implements Pass {
        PShader shader;
        private float amount;

        public CAPass() {
            this.shader = trbl_processing.this.loadShader("caFrag.glsl");
        }

        public void prepare(Supervisor supervisor) {
        }

        public void apply(Supervisor supervisor) {
            PGraphics pass = supervisor.getNextPass();
            supervisor.clearPass(pass);
            this.shader.set("amount", this.amount);
            pass.beginDraw();
            pass.shader(this.shader);
            pass.image((PImage)supervisor.getCurrentPass(), 0.0f, 0.0f);
            pass.endDraw();
        }

        public void setAmount(float amount) {
            this.amount = amount;
        }

        public float getAmount() {
            return this.amount;
        }
    }

    class InvertPass
    implements Pass {
        PShader shader;
        private float amount;

        public InvertPass() {
            this.shader = trbl_processing.this.loadShader("invertFrag.glsl");
        }

        public void prepare(Supervisor supervisor) {
        }

        public void apply(Supervisor supervisor) {
            PGraphics pass = supervisor.getNextPass();
            supervisor.clearPass(pass);
            this.shader.set("amount", this.amount);
            pass.beginDraw();
            pass.shader(this.shader);
            pass.image((PImage)supervisor.getCurrentPass(), 0.0f, 0.0f);
            pass.endDraw();
        }

        public void setAmount(float amount) {
            this.amount = amount;
        }

        public float getAmount() {
            return this.amount;
        }
    }

    class Particle {
        PVector pos;
        float diameter;
        int col;
        PShape obj;

        Particle(PVector pos, PShape obj, float diameter, int col) {
            this.pos = pos;
            this.obj = obj;
            this.diameter = diameter;
            this.col = col;
        }
    }
}

