/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioBuffer;
import ddf.minim.Minim;

final class MAudioBuffer
implements AudioBuffer {
    private float[] samples;

    MAudioBuffer(int bufferSize) {
        this.samples = new float[bufferSize];
    }

    @Override
    public synchronized int size() {
        return this.samples.length;
    }

    @Override
    public synchronized float get(int i) {
        return this.samples[i];
    }

    public synchronized float get(float i) {
        int lowSamp = (int)i;
        int hiSamp = lowSamp + 1;
        if (hiSamp == this.samples.length) {
            return this.samples[lowSamp];
        }
        float lerp = i - (float)lowSamp;
        return this.samples[lowSamp] + lerp * (this.samples[hiSamp] - this.samples[lowSamp]);
    }

    public synchronized void set(float[] buffer) {
        if (buffer.length != this.samples.length) {
            Minim.error("MAudioBuffer.set: passed array (" + buffer.length + ") " + "must be the same length (" + this.samples.length + ") as this MAudioBuffer.");
        } else {
            this.samples = buffer;
        }
    }

    public synchronized void mix(float[] b1, float[] b2) {
        if (b1.length != b2.length || b1.length != this.samples.length || b2.length != this.samples.length) {
            Minim.error("MAudioBuffer.mix: The two passed buffers must be the same size as this MAudioBuffer.");
        } else {
            for (int i = 0; i < this.samples.length; ++i) {
                this.samples[i] = (b1[i] + b2[i]) / 2.0f;
            }
        }
    }

    public synchronized void clear() {
        this.samples = new float[this.samples.length];
    }

    @Override
    public synchronized float level() {
        float level = 0.0f;
        for (int i = 0; i < this.samples.length; ++i) {
            level += this.samples[i] * this.samples[i];
        }
        level /= (float)this.samples.length;
        level = (float)Math.sqrt(level);
        return level;
    }

    @Override
    public synchronized float[] toArray() {
        float[] ret = new float[this.samples.length];
        System.arraycopy(this.samples, 0, ret, 0, this.samples.length);
        return ret;
    }
}

