/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;

public class GranulateRandom
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(UGen.InputType.AUDIO);
    public UGen.UGenInput grainLenMin = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput spaceLenMin = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput fadeLenMin = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput grainLenMax = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput spaceLenMax = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput fadeLenMax = new UGen.UGenInput(UGen.InputType.CONTROL);
    private boolean insideGrain;
    private float timeSinceGrainStart;
    private float timeSinceGrainStop;
    private float timeStep;
    private float fadeLength = 0.0025f;
    private float grainLength = 0.01f;
    private float spaceLength = 0.02f;
    private float fadeLengthMin = 0.0025f;
    private float grainLengthMin = 0.01f;
    private float spaceLengthMin = 0.02f;
    private float fadeLengthMax = 0.0025f;
    private float grainLengthMax = 0.01f;
    private float spaceLengthMax = 0.02f;
    private float minAmp = 0.0f;
    private float maxAmp = 1.0f;

    public GranulateRandom() {
        this(0.01f, 0.02f, 0.0025f, 0.1f, 0.2f, 0.025f, 0.0f, 1.0f);
    }

    public GranulateRandom(float grainLengthMin, float spaceLengthMin, float fadeLengthMin, float grainLengthMax, float spaceLengthMax, float fadeLengthMax) {
        this(grainLengthMin, spaceLengthMin, fadeLengthMin, grainLengthMax, spaceLengthMax, fadeLengthMax, 0.0f, 1.0f);
    }

    public GranulateRandom(float grainLengthMin, float spaceLengthMin, float fadeLengthMin, float grainLengthMax, float spaceLengthMax, float fadeLengthMax, float minAmp, float maxAmp) {
        this.setAllParameters(grainLengthMin, spaceLengthMin, fadeLengthMin, grainLengthMax, spaceLengthMax, fadeLengthMax, minAmp, maxAmp);
        this.insideGrain = false;
        this.timeSinceGrainStart = 0.0f;
        this.timeSinceGrainStop = 0.0f;
        this.timeStep = 0.0f;
    }

    @Override
    protected void sampleRateChanged() {
        this.timeStep = 1.0f / this.sampleRate();
    }

    public void setAllTimeParameters(float grainLengthMin, float spaceLengthMin, float fadeLengthMin, float grainLengthMax, float spaceLengthMax, float fadeLengthMax) {
        this.setAllParameters(grainLengthMin, spaceLengthMin, fadeLengthMin, grainLengthMax, spaceLengthMax, fadeLengthMax, this.minAmp, this.maxAmp);
    }

    public void setAllParameters(float grainLengthMin, float spaceLengthMin, float fadeLengthMin, float grainLengthMax, float spaceLengthMax, float fadeLengthMax, float minAmp, float maxAmp) {
        this.grainLenMin.setLastValue(grainLengthMin);
        this.grainLenMax.setLastValue(grainLengthMax);
        this.fadeLenMin.setLastValue(fadeLengthMin);
        this.fadeLenMax.setLastValue(fadeLengthMax);
        this.spaceLenMin.setLastValue(spaceLengthMin);
        this.spaceLenMax.setLastValue(spaceLengthMax);
        this.grainLengthMin = grainLengthMin;
        this.spaceLengthMin = spaceLengthMin;
        this.fadeLengthMin = fadeLengthMin;
        this.grainLengthMax = grainLengthMax;
        this.spaceLengthMax = spaceLengthMax;
        this.fadeLengthMax = fadeLengthMax;
        this.minAmp = minAmp;
        this.maxAmp = maxAmp;
    }

    private void checkFadeLength() {
        this.fadeLength = Math.min(this.fadeLength, this.grainLength / 2.0f);
    }

    private float randomBetween(float min, float max) {
        return (max - min) * (float)Math.random() + min;
    }

    @Override
    protected void uGenerate(float[] channels) {
        if (this.insideGrain) {
            float amp = this.maxAmp;
            if (this.timeSinceGrainStart < this.fadeLength) {
                amp *= this.timeSinceGrainStart / this.fadeLength;
            } else if (this.timeSinceGrainStart > this.grainLength - this.fadeLength) {
                amp *= (this.grainLength - this.timeSinceGrainStart) / this.fadeLength;
            }
            for (int i = 0; i < channels.length; ++i) {
                channels[i] = amp * this.audio.getLastValues()[i];
            }
            this.timeSinceGrainStart += this.timeStep;
            if (this.timeSinceGrainStart > this.grainLength) {
                this.timeSinceGrainStop = 0.0f;
                this.insideGrain = false;
                this.spaceLengthMin = this.spaceLenMin.getLastValue();
                this.spaceLengthMax = this.spaceLenMax.getLastValue();
                this.spaceLength = this.randomBetween(this.spaceLengthMin, this.spaceLengthMax);
            }
        } else {
            for (int i = 0; i < channels.length; ++i) {
                channels[i] = this.minAmp;
            }
            this.timeSinceGrainStop += this.timeStep;
            if (this.timeSinceGrainStop > this.spaceLength) {
                this.timeSinceGrainStart = 0.0f;
                this.insideGrain = true;
                this.grainLengthMin = this.grainLenMin.getLastValue();
                this.grainLengthMax = this.grainLenMax.getLastValue();
                this.grainLength = this.randomBetween(this.grainLengthMin, this.grainLengthMax);
                this.fadeLengthMin = this.fadeLenMin.getLastValue();
                this.fadeLengthMax = this.fadeLenMax.getLastValue();
                this.fadeLength = this.randomBetween(this.fadeLengthMin, this.fadeLengthMax);
                this.checkFadeLength();
            }
        }
    }
}

