/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.utils.Array;

public class ButtonGroup<T extends Button> {
    private final Array<T> buttons = new Array();
    private Array<T> checkedButtons = new Array(1);
    private int minCheckCount;
    private int maxCheckCount = 1;
    private boolean uncheckLast = true;
    private T lastChecked;

    public ButtonGroup() {
        this.minCheckCount = 1;
    }

    public ButtonGroup(T ... buttons) {
        this.minCheckCount = 0;
        this.add((T)buttons);
        this.minCheckCount = 1;
    }

    public void add(T button2) {
        if (button2 == null) {
            throw new IllegalArgumentException("button cannot be null.");
        }
        ((Button)button2).buttonGroup = null;
        boolean shouldCheck = ((Button)button2).isChecked() || this.buttons.size < this.minCheckCount;
        ((Button)button2).setChecked(false);
        ((Button)button2).buttonGroup = this;
        this.buttons.add(button2);
        ((Button)button2).setChecked(shouldCheck);
    }

    public void add(T ... buttons) {
        if (buttons == null) {
            throw new IllegalArgumentException("buttons cannot be null.");
        }
        int n = buttons.length;
        for (int i = 0; i < n; ++i) {
            this.add(buttons[i]);
        }
    }

    public void remove(T button2) {
        if (button2 == null) {
            throw new IllegalArgumentException("button cannot be null.");
        }
        ((Button)button2).buttonGroup = null;
        this.buttons.removeValue(button2, true);
        this.checkedButtons.removeValue(button2, true);
    }

    public void remove(T ... buttons) {
        if (buttons == null) {
            throw new IllegalArgumentException("buttons cannot be null.");
        }
        int n = buttons.length;
        for (int i = 0; i < n; ++i) {
            this.remove(buttons[i]);
        }
    }

    public void clear() {
        this.buttons.clear();
        this.checkedButtons.clear();
    }

    public void setChecked(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text cannot be null.");
        }
        int n = this.buttons.size;
        for (int i = 0; i < n; ++i) {
            Button button2 = (Button)this.buttons.get(i);
            if (!(button2 instanceof TextButton) || !text.contentEquals(((TextButton)button2).getText())) continue;
            button2.setChecked(true);
            return;
        }
    }

    protected boolean canCheck(T button2, boolean newState) {
        if (((Button)button2).isChecked == newState) {
            return false;
        }
        if (!newState) {
            if (this.checkedButtons.size <= this.minCheckCount) {
                return false;
            }
            this.checkedButtons.removeValue(button2, true);
        } else {
            if (this.maxCheckCount != -1 && this.checkedButtons.size >= this.maxCheckCount) {
                if (this.uncheckLast) {
                    int old = this.minCheckCount;
                    this.minCheckCount = 0;
                    ((Button)this.lastChecked).setChecked(false);
                    this.minCheckCount = old;
                } else {
                    return false;
                }
            }
            this.checkedButtons.add(button2);
            this.lastChecked = button2;
        }
        return true;
    }

    public void uncheckAll() {
        int old = this.minCheckCount;
        this.minCheckCount = 0;
        int n = this.buttons.size;
        for (int i = 0; i < n; ++i) {
            Button button2 = (Button)this.buttons.get(i);
            button2.setChecked(false);
        }
        this.minCheckCount = old;
    }

    public T getChecked() {
        if (this.checkedButtons.size > 0) {
            return (T)((Button)this.checkedButtons.get(0));
        }
        return null;
    }

    public int getCheckedIndex() {
        if (this.checkedButtons.size > 0) {
            return this.buttons.indexOf(this.checkedButtons.get(0), true);
        }
        return -1;
    }

    public Array<T> getAllChecked() {
        return this.checkedButtons;
    }

    public Array<T> getButtons() {
        return this.buttons;
    }

    public void setMinCheckCount(int minCheckCount) {
        this.minCheckCount = minCheckCount;
    }

    public void setMaxCheckCount(int maxCheckCount) {
        if (maxCheckCount == 0) {
            maxCheckCount = -1;
        }
        this.maxCheckCount = maxCheckCount;
    }

    public void setUncheckLast(boolean uncheckLast) {
        this.uncheckLast = uncheckLast;
    }
}

