/*
 * Decompiled with CFR 0.152.
 */
package com.demoframe;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.support.jdk7.AutoCloseableKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/demoframe/Shader;", "", "type", "", "(I)V", "id", "getId", "()I", "checkStatus", "", "name", "", "compile", "delete", "source", "", "Companion", "core"})
final class Shader {
    private final int id;
    public static final Companion Companion = new Companion(null);

    public final int getId() {
        return this.id;
    }

    public final void source(@Nullable CharSequence source) {
        GL20.glShaderSource(this.id, source);
    }

    public final void compile(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        GL20.glCompileShader(this.id);
        this.checkStatus(name);
    }

    private final void checkStatus(String name) {
        int status = GL20.glGetShaderi(this.id, 35713);
        if (status != 1) {
            throw (Throwable)new RuntimeException(name + " -> \n" + GL20.glGetShaderInfoLog(this.id));
        }
    }

    public final void delete() {
        GL20.glDeleteShader(this.id);
    }

    public Shader(int type) {
        this.id = GL20.glCreateShader(type);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a8\u0006\r"}, d2={"Lcom/demoframe/Shader$Companion;", "", "()V", "createShader", "Lcom/demoframe/Shader;", "type", "", "source", "", "name", "", "path", "loadShader", "core"})
    public static final class Companion {
        private final Shader createShader(int type, CharSequence source, String name) {
            Shader shader = new Shader(type);
            shader.source(source);
            shader.compile(name);
            return shader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Shader loadShader(int type, @Nullable String path) {
            String string;
            StringBuilder builder = new StringBuilder();
            switch (type) {
                case 35633: {
                    string = "vertex shader";
                    break;
                }
                case 35632: {
                    string = "fragment shader";
                    break;
                }
                default: {
                    string = "unknown shader type!";
                }
            }
            String shaderType = string;
            try {
                AutoCloseable $receiver$iv = new FileInputStream(path);
                boolean closed$iv = false;
                try {
                    Object inside = (FileInputStream)$receiver$iv;
                    boolean bl = false;
                    AutoCloseable $receiver$iv2 = new BufferedReader(new InputStreamReader((InputStream)inside));
                    boolean closed$iv2 = false;
                    try {
                        Object reader = (BufferedReader)$receiver$iv2;
                        boolean bl2 = false;
                        Ref.ObjectRef line = new Ref.ObjectRef();
                        while (true) {
                            String string2 = ((BufferedReader)reader).readLine();
                            boolean bl3 = false;
                            boolean bl4 = false;
                            String it = string2;
                            boolean bl5 = false;
                            line.element = it;
                            if (string2 == null) break;
                            builder.append((String)line.element).append("\n");
                        }
                        reader = Unit.INSTANCE;
                    }
                    catch (Throwable e$iv) {
                        try {
                            closed$iv2 = true;
                            AutoCloseableKt.closeSuppressed($receiver$iv2, e$iv);
                            throw e$iv;
                        }
                        catch (Throwable throwable) {
                            if (!closed$iv2) {
                                $receiver$iv2.close();
                            }
                            throw throwable;
                        }
                    }
                    $receiver$iv2.close();
                    inside = Unit.INSTANCE;
                }
                catch (Throwable e$iv) {
                    try {
                        closed$iv = true;
                        AutoCloseableKt.closeSuppressed($receiver$iv, e$iv);
                        throw e$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv) {
                            $receiver$iv.close();
                        }
                        throw throwable;
                    }
                }
                $receiver$iv.close();
            }
            catch (IOException ex) {
                throw (Throwable)new RuntimeException("Failed to load a (" + shaderType + ") file!" + System.lineSeparator() + ex.getMessage());
            }
            String string3 = builder.toString();
            Intrinsics.checkExpressionValueIsNotNull(string3, "builder.toString()");
            CharSequence source = string3;
            return this.createShader(type, source, '[' + path + ", " + shaderType + ']');
        }

        @NotNull
        public final Shader createShader(@NotNull String source, @NotNull String path, int type) {
            String string;
            Intrinsics.checkParameterIsNotNull(source, "source");
            Intrinsics.checkParameterIsNotNull(path, "path");
            switch (type) {
                case 35633: {
                    string = "vertex shader";
                    break;
                }
                case 35632: {
                    string = "fragment shader";
                    break;
                }
                default: {
                    string = "unknown shader type!";
                }
            }
            String shaderType = string;
            return this.createShader(type, (CharSequence)source, '[' + path + ", " + shaderType + ']');
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

