/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AILogStreamCallback;
import org.lwjgl.assimp.AILogStreamCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiLogStream")
public class AILogStream
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CALLBACK;
    public static final int USER;

    public AILogStream(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AILogStream.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="aiLogStreamCallback")
    public AILogStreamCallback callback() {
        return AILogStream.ncallback(this.address());
    }

    @NativeType(value="void *")
    public long user() {
        return AILogStream.nuser(this.address());
    }

    public AILogStream callback(@NativeType(value="aiLogStreamCallback") AILogStreamCallbackI value) {
        AILogStream.ncallback(this.address(), value);
        return this;
    }

    public AILogStream user(@NativeType(value="void *") long value) {
        AILogStream.nuser(this.address(), value);
        return this;
    }

    public AILogStream set(AILogStreamCallbackI callback, long user) {
        this.callback(callback);
        this.user(user);
        return this;
    }

    public AILogStream set(AILogStream src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AILogStream malloc() {
        return AILogStream.wrap(AILogStream.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AILogStream calloc() {
        return AILogStream.wrap(AILogStream.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AILogStream create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AILogStream.wrap(AILogStream.class, MemoryUtil.memAddress(container), container);
    }

    public static AILogStream create(long address) {
        return AILogStream.wrap(AILogStream.class, address);
    }

    @Nullable
    public static AILogStream createSafe(long address) {
        return address == 0L ? null : AILogStream.wrap(AILogStream.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AILogStream.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AILogStream.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AILogStream.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AILogStream.__create(capacity, SIZEOF);
        return AILogStream.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AILogStream.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AILogStream.wrap(Buffer.class, address, capacity);
    }

    public static AILogStream mallocStack() {
        return AILogStream.mallocStack(MemoryStack.stackGet());
    }

    public static AILogStream callocStack() {
        return AILogStream.callocStack(MemoryStack.stackGet());
    }

    public static AILogStream mallocStack(MemoryStack stack) {
        return AILogStream.wrap(AILogStream.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AILogStream callocStack(MemoryStack stack) {
        return AILogStream.wrap(AILogStream.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AILogStream.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AILogStream.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AILogStream.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AILogStream.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AILogStreamCallback ncallback(long struct) {
        return AILogStreamCallback.create(MemoryUtil.memGetAddress(struct + (long)CALLBACK));
    }

    public static long nuser(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USER);
    }

    public static void ncallback(long struct, AILogStreamCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CALLBACK, value.address());
    }

    public static void nuser(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USER, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CALLBACK));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)USER));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AILogStream.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = AILogStream.__struct(AILogStream.__member(POINTER_SIZE), AILogStream.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CALLBACK = layout.offsetof(0);
        USER = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AILogStream, Buffer>
    implements NativeResource {
        private static final AILogStream ELEMENT_FACTORY = AILogStream.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AILogStream getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="aiLogStreamCallback")
        public AILogStreamCallback callback() {
            return AILogStream.ncallback(this.address());
        }

        @NativeType(value="void *")
        public long user() {
            return AILogStream.nuser(this.address());
        }

        public Buffer callback(@NativeType(value="aiLogStreamCallback") AILogStreamCallbackI value) {
            AILogStream.ncallback(this.address(), value);
            return this;
        }

        public Buffer user(@NativeType(value="void *") long value) {
            AILogStream.nuser(this.address(), value);
            return this;
        }
    }
}

