/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMaterialProperty")
public class AIMaterialProperty
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MKEY;
    public static final int MSEMANTIC;
    public static final int MINDEX;
    public static final int MDATALENGTH;
    public static final int MTYPE;
    public static final int MDATA;

    public AIMaterialProperty(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIMaterialProperty.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mKey() {
        return AIMaterialProperty.nmKey(this.address());
    }

    @NativeType(value="unsigned int")
    public int mSemantic() {
        return AIMaterialProperty.nmSemantic(this.address());
    }

    @NativeType(value="unsigned int")
    public int mIndex() {
        return AIMaterialProperty.nmIndex(this.address());
    }

    @NativeType(value="unsigned int")
    public int mDataLength() {
        return AIMaterialProperty.nmDataLength(this.address());
    }

    @NativeType(value="aiPropertyTypeInfo")
    public int mType() {
        return AIMaterialProperty.nmType(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer mData() {
        return AIMaterialProperty.nmData(this.address());
    }

    public static AIMaterialProperty create(long address) {
        return AIMaterialProperty.wrap(AIMaterialProperty.class, address);
    }

    @Nullable
    public static AIMaterialProperty createSafe(long address) {
        return address == 0L ? null : AIMaterialProperty.wrap(AIMaterialProperty.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return AIMaterialProperty.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIMaterialProperty.wrap(Buffer.class, address, capacity);
    }

    public static AIString nmKey(long struct) {
        return AIString.create(struct + (long)MKEY);
    }

    public static int nmSemantic(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSEMANTIC);
    }

    public static int nmIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINDEX);
    }

    public static int nmDataLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)MDATALENGTH);
    }

    public static int nmType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MTYPE);
    }

    public static ByteBuffer nmData(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)MDATA), AIMaterialProperty.nmDataLength(struct));
    }

    static {
        Struct.Layout layout = AIMaterialProperty.__struct(AIMaterialProperty.__member(AIString.SIZEOF, AIString.ALIGNOF), AIMaterialProperty.__member(4), AIMaterialProperty.__member(4), AIMaterialProperty.__member(4), AIMaterialProperty.__member(4), AIMaterialProperty.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MKEY = layout.offsetof(0);
        MSEMANTIC = layout.offsetof(1);
        MINDEX = layout.offsetof(2);
        MDATALENGTH = layout.offsetof(3);
        MTYPE = layout.offsetof(4);
        MDATA = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<AIMaterialProperty, Buffer> {
        private static final AIMaterialProperty ELEMENT_FACTORY = AIMaterialProperty.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIMaterialProperty getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mKey() {
            return AIMaterialProperty.nmKey(this.address());
        }

        @NativeType(value="unsigned int")
        public int mSemantic() {
            return AIMaterialProperty.nmSemantic(this.address());
        }

        @NativeType(value="unsigned int")
        public int mIndex() {
            return AIMaterialProperty.nmIndex(this.address());
        }

        @NativeType(value="unsigned int")
        public int mDataLength() {
            return AIMaterialProperty.nmDataLength(this.address());
        }

        @NativeType(value="aiPropertyTypeInfo")
        public int mType() {
            return AIMaterialProperty.nmType(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer mData() {
            return AIMaterialProperty.nmData(this.address());
        }
    }
}

