/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiVectorKey")
public class AIVectorKey
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUE;

    public AIVectorKey(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIVectorKey.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIVectorKey.nmTime(this.address());
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mValue() {
        return AIVectorKey.nmValue(this.address());
    }

    public AIVectorKey mTime(double value) {
        AIVectorKey.nmTime(this.address(), value);
        return this;
    }

    public AIVectorKey mValue(@NativeType(value="struct aiVector3D") AIVector3D value) {
        AIVectorKey.nmValue(this.address(), value);
        return this;
    }

    public AIVectorKey mValue(Consumer<AIVector3D> consumer) {
        consumer.accept(this.mValue());
        return this;
    }

    public AIVectorKey set(double mTime, AIVector3D mValue) {
        this.mTime(mTime);
        this.mValue(mValue);
        return this;
    }

    public AIVectorKey set(AIVectorKey src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIVectorKey malloc() {
        return AIVectorKey.wrap(AIVectorKey.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIVectorKey calloc() {
        return AIVectorKey.wrap(AIVectorKey.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIVectorKey create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIVectorKey.wrap(AIVectorKey.class, MemoryUtil.memAddress(container), container);
    }

    public static AIVectorKey create(long address) {
        return AIVectorKey.wrap(AIVectorKey.class, address);
    }

    @Nullable
    public static AIVectorKey createSafe(long address) {
        return address == 0L ? null : AIVectorKey.wrap(AIVectorKey.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIVectorKey.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIVectorKey.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIVectorKey.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIVectorKey.__create(capacity, SIZEOF);
        return AIVectorKey.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIVectorKey.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIVectorKey.wrap(Buffer.class, address, capacity);
    }

    public static AIVectorKey mallocStack() {
        return AIVectorKey.mallocStack(MemoryStack.stackGet());
    }

    public static AIVectorKey callocStack() {
        return AIVectorKey.callocStack(MemoryStack.stackGet());
    }

    public static AIVectorKey mallocStack(MemoryStack stack) {
        return AIVectorKey.wrap(AIVectorKey.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIVectorKey callocStack(MemoryStack stack) {
        return AIVectorKey.wrap(AIVectorKey.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIVectorKey.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIVectorKey.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIVectorKey.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIVectorKey.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nmTime(long struct) {
        return UNSAFE.getDouble(null, struct + (long)MTIME);
    }

    public static AIVector3D nmValue(long struct) {
        return AIVector3D.create(struct + (long)MVALUE);
    }

    public static void nmTime(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)MTIME, value);
    }

    public static void nmValue(long struct, AIVector3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MVALUE, AIVector3D.SIZEOF);
    }

    static {
        Struct.Layout layout = AIVectorKey.__struct(AIVectorKey.__member(8), AIVectorKey.__member(AIVector3D.SIZEOF, AIVector3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIVectorKey, Buffer>
    implements NativeResource {
        private static final AIVectorKey ELEMENT_FACTORY = AIVectorKey.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIVectorKey getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public double mTime() {
            return AIVectorKey.nmTime(this.address());
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mValue() {
            return AIVectorKey.nmValue(this.address());
        }

        public Buffer mTime(double value) {
            AIVectorKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValue(@NativeType(value="struct aiVector3D") AIVector3D value) {
            AIVectorKey.nmValue(this.address(), value);
            return this;
        }

        public Buffer mValue(Consumer<AIVector3D> consumer) {
            consumer.accept(this.mValue());
            return this;
        }
    }
}

